/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting.datatypes;

import com.autocasting.datatypes.RuneType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.runelite.api.EquipmentInventorySlot;

public enum InfiniteRuneItem {
    STAFF_OF_AIR(1381, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.AIR}),
    AIR_BATTLESTAFF(1397, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.AIR}),
    MYSTIC_AIR_STAFF(1405, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.AIR}),
    STAFF_OF_WATER(1383, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.WATER}),
    WATER_BATTLESTAFF(1395, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.WATER}),
    MYSTIC_WATER_STAFF(1403, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.WATER}),
    STAFF_OF_EARTH(1385, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.EARTH}),
    EARTH_BATTLESTAFF(1399, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.EARTH}),
    MYSTIC_EARTH_STAFF(1407, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.EARTH}),
    STAFF_OF_FIRE(1387, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.FIRE}),
    FIRE_BATTLESTAFF(1393, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.FIRE}),
    MYSTIC_FIRE_STAFF(1401, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.FIRE}),
    MIST_BATTLESTAFF(20730, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.AIR, RuneType.WATER}),
    DUST_BATTLESTAFF(20736, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.AIR, RuneType.EARTH}),
    MUD_BATTLESTAFF(6562, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.WATER, RuneType.EARTH}),
    SMOKE_BATTLESTAFF(11998, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.AIR, RuneType.FIRE}),
    STEAM_BATTLESTAFF(11787, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.WATER, RuneType.FIRE}),
    LAVA_BATTLESTAFF(3053, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.EARTH, RuneType.FIRE}),
    MYSTIC_MIST_STAFF(20733, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.AIR, RuneType.WATER}),
    MYSTIC_DUST_STAFF(20739, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.AIR, RuneType.EARTH}),
    MYSTIC_MUD_STAFF(6563, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.WATER, RuneType.EARTH}),
    MYSTIC_SMOKE_STAFF(12000, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.AIR, RuneType.FIRE}),
    MYSTIC_STEAM_STAFF(11789, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.WATER, RuneType.FIRE}),
    MYSTIC_LAVA_STAFF(3054, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.EARTH, RuneType.FIRE}),
    KODAI_WAND(21006, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.WATER}),
    KODAI_WAND_23626(23626, EquipmentInventorySlot.WEAPON, new RuneType[]{RuneType.WATER}),
    TOME_OF_WATER(25574, EquipmentInventorySlot.SHIELD, new RuneType[]{RuneType.WATER}),
    TOME_OF_FIRE(20714, EquipmentInventorySlot.SHIELD, new RuneType[]{RuneType.FIRE});

    private final int itemId;
    private final EquipmentInventorySlot slot;
    private final RuneType[] matchingTypes;
    private static final Map<Integer, InfiniteRuneItem> INFINITE_RUNE_ITEM_MAP;

    public static InfiniteRuneItem getInfiniteRuneItem(int itemId) {
        return INFINITE_RUNE_ITEM_MAP.getOrDefault(itemId, null);
    }

    private InfiniteRuneItem(int itemId, EquipmentInventorySlot slot, RuneType[] matchingTypes) {
        this.itemId = itemId;
        this.slot = slot;
        this.matchingTypes = matchingTypes;
    }

    public int getItemId() {
        return this.itemId;
    }

    public EquipmentInventorySlot getSlot() {
        return this.slot;
    }

    public RuneType[] getMatchingTypes() {
        return this.matchingTypes;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (InfiniteRuneItem item : InfiniteRuneItem.values()) {
            builder.put((Object)item.getItemId(), (Object)item);
        }
        INFINITE_RUNE_ITEM_MAP = builder.build();
    }
}

