/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting;

import com.autocasting.AutocastingState;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.InventoryID;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.PostClientTick;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class AutocastingSubscriptions {
    @Inject
    private AutocastingState state;
    private boolean updateRunesPostClientTick = false;

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        switch (event.getVarbitId()) {
            case 276: 
            case 357: {
                this.state.updateAutocastSpell();
                this.state.updateIsEquippedWeaponMagic();
                break;
            }
            case 29: 
            case 1622: 
            case 1623: 
            case 1624: 
            case 1625: 
            case 1626: 
            case 14285: 
            case 14286: {
                this.updateRunesPostClientTick = true;
                break;
            }
            case 4145: {
                this.state.updateCastsRemaining(false);
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        switch (event.getGroupId()) {
            case 12: 
            case 15: 
            case 192: {
                this.state.setBanking(true);
            }
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed event) {
        switch (event.getGroupId()) {
            case 12: 
            case 15: 
            case 192: {
                this.state.setBanking(false);
            }
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        if (event.getSkill() == Skill.MAGIC) {
            int boostedLevel = event.getBoostedLevel();
            this.state.updateMagicLevel(boostedLevel);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.EQUIPMENT.getId()) {
            this.state.updateInfiniteRuneSources();
        }
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.state.updateRunes();
        }
    }

    @Subscribe
    public void onPostClientTick(PostClientTick event) {
        if (this.updateRunesPostClientTick) {
            this.state.updateRunes();
            this.updateRunesPostClientTick = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.state.updateCombatStatus();
    }
}

