/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting;

import com.autocasting.AutocastingClientData;
import com.autocasting.AutocastingNotifications;
import com.autocasting.AutocastingRuneUtil;
import com.autocasting.datatypes.PlayerInventory;
import com.autocasting.datatypes.RuneType;
import com.autocasting.datatypes.Spell;
import com.autocasting.dependencies.attackstyles.WeaponType;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AutocastingState {
    @Inject
    private AutocastingClientData clientData;
    @Inject
    private AutocastingRuneUtil runeUtil;
    @Inject
    private AutocastingNotifications notifications;
    private boolean magicLevelTooLowForSpell;
    private boolean isEquippedWeaponMagic;
    private WeaponType currentWeaponType;
    private Spell currentAutocastSpell;
    private PlayerInventory playerInventory;
    private boolean consideredInCombat;
    private int lastCombatTick;
    private Map<RuneType, Integer> availableRunes;
    private int castsRemaining;
    private boolean banking;

    public void updateAutocastSpell() {
        Spell newAutocastSpell = this.clientData.getAutocastSpell();
        if (newAutocastSpell == null) {
            return;
        }
        this.setMagicLevelTooLowForSpell(false);
        if (this.currentAutocastSpell == null || newAutocastSpell.getVarbitValue() != this.currentAutocastSpell.getVarbitValue()) {
            this.currentAutocastSpell = newAutocastSpell;
        }
        this.updateCastsRemaining(true);
    }

    public boolean hasActiveAutocast() {
        return this.currentAutocastSpell != null && this.currentAutocastSpell != Spell.NO_SPELL;
    }

    public void updateRunes() {
        this.setPlayerInventory(this.runeUtil.updateInventory(this.playerInventory));
        this.calculateNetRuneTypes();
    }

    public void updateInfiniteRuneSources() {
        this.setPlayerInventory(this.runeUtil.updateEquipment(this.playerInventory));
        this.calculateNetRuneTypes();
    }

    private void calculateNetRuneTypes() {
        this.setAvailableRunes(this.runeUtil.availableRunes(this.playerInventory));
        this.updateCastsRemaining(false);
    }

    public void updateCastsRemaining(boolean autocastSpellUpdate) {
        if (this.currentAutocastSpell == null || this.currentAutocastSpell == Spell.NO_SPELL) {
            this.castsRemaining = 0;
            return;
        }
        int newCastsRemaining = this.runeUtil.calculateCastsRemaining(this.currentAutocastSpell, this.availableRunes);
        if (!autocastSpellUpdate && this.castsRemaining != newCastsRemaining) {
            this.notifications.handleCastsUpdated(this.castsRemaining, newCastsRemaining);
        }
        this.castsRemaining = newCastsRemaining;
    }

    public void updateIsEquippedWeaponMagic() {
        int weaponTypeID = this.clientData.getWeaponTypeId();
        WeaponType newWeaponType = WeaponType.getWeaponType(weaponTypeID);
        if (newWeaponType == this.currentWeaponType) {
            return;
        }
        this.currentWeaponType = newWeaponType;
        this.isEquippedWeaponMagic = newWeaponType == WeaponType.TYPE_18 || newWeaponType == WeaponType.TYPE_21;
    }

    public void updateMagicLevel(int boostedLevel) {
        Spell autocastSpell = Spell.getSpell(this.clientData.getAutocastVarbit());
        if (boostedLevel < autocastSpell.getLevelRequirement()) {
            if (!this.magicLevelTooLowForSpell) {
                this.magicLevelTooLowForSpell = true;
                this.notifications.notifyStatDrain();
            }
        } else {
            this.magicLevelTooLowForSpell = false;
        }
    }

    public void updateCombatStatus() {
        boolean inCombat = this.clientData.isInCombat();
        int currentTick = this.clientData.getGameTick();
        if (inCombat) {
            this.lastCombatTick = currentTick;
            this.consideredInCombat = true;
        } else {
            this.consideredInCombat = currentTick - this.lastCombatTick <= 2;
        }
    }

    public boolean isMagicLevelTooLowForSpell() {
        return this.magicLevelTooLowForSpell;
    }

    public void setMagicLevelTooLowForSpell(boolean magicLevelTooLowForSpell) {
        this.magicLevelTooLowForSpell = magicLevelTooLowForSpell;
    }

    public boolean isEquippedWeaponMagic() {
        return this.isEquippedWeaponMagic;
    }

    public void setEquippedWeaponMagic(boolean isEquippedWeaponMagic) {
        this.isEquippedWeaponMagic = isEquippedWeaponMagic;
    }

    public WeaponType getCurrentWeaponType() {
        return this.currentWeaponType;
    }

    public void setCurrentWeaponType(WeaponType currentWeaponType) {
        this.currentWeaponType = currentWeaponType;
    }

    public Spell getCurrentAutocastSpell() {
        return this.currentAutocastSpell;
    }

    public void setCurrentAutocastSpell(Spell currentAutocastSpell) {
        this.currentAutocastSpell = currentAutocastSpell;
    }

    public PlayerInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public void setPlayerInventory(PlayerInventory playerInventory) {
        this.playerInventory = playerInventory;
    }

    public boolean isConsideredInCombat() {
        return this.consideredInCombat;
    }

    public void setConsideredInCombat(boolean consideredInCombat) {
        this.consideredInCombat = consideredInCombat;
    }

    public int getLastCombatTick() {
        return this.lastCombatTick;
    }

    public void setLastCombatTick(int lastCombatTick) {
        this.lastCombatTick = lastCombatTick;
    }

    public Map<RuneType, Integer> getAvailableRunes() {
        return this.availableRunes;
    }

    public void setAvailableRunes(Map<RuneType, Integer> availableRunes) {
        this.availableRunes = availableRunes;
    }

    public int getCastsRemaining() {
        return this.castsRemaining;
    }

    public void setCastsRemaining(int castsRemaining) {
        this.castsRemaining = castsRemaining;
    }

    public boolean isBanking() {
        return this.banking;
    }

    public void setBanking(boolean banking) {
        this.banking = banking;
    }
}

