/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting;

import com.autocasting.AutocastingClientData;
import com.autocasting.AutocastingConstants;
import com.autocasting.datatypes.InfiniteRuneItem;
import com.autocasting.datatypes.PlayerInventory;
import com.autocasting.datatypes.Pouch;
import com.autocasting.datatypes.RuneItem;
import com.autocasting.datatypes.RuneItemQuantity;
import com.autocasting.datatypes.RuneType;
import com.autocasting.datatypes.RuneTypeQuantity;
import com.autocasting.datatypes.Spell;
import java.util.EnumMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.EnumComposition;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;

public class AutocastingRuneUtil {
    @Inject
    private AutocastingClientData clientData;

    public PlayerInventory updateInventory(PlayerInventory current) {
        ItemContainer inventory;
        PlayerInventory updated = new PlayerInventory();
        if (current != null) {
            updated.setMainHand(current.getMainHand());
            updated.setOffHand(current.getOffHand());
        }
        if ((inventory = this.clientData.getInventory()) == null) {
            return updated;
        }
        for (Item item : inventory.getItems()) {
            RuneItem rune;
            int itemId = item.getId();
            int quantity = item.getQuantity();
            Pouch pouch = Pouch.getPouch(itemId);
            if (pouch != null) {
                updated.setPouch(pouch);
            }
            if ((rune = RuneItem.getRuneItem(itemId)) == null) continue;
            updated.addRuneStack(new RuneItemQuantity(rune, quantity));
        }
        return updated;
    }

    public PlayerInventory updateEquipment(PlayerInventory current) {
        PlayerInventory updated = new PlayerInventory();
        if (current != null) {
            updated.setRunes(current.getRunes());
            updated.setPouch(current.getPouch());
        }
        ItemContainer equipment = this.clientData.getEquipment();
        Item weaponSlot = equipment.getItem(EquipmentInventorySlot.WEAPON.getSlotIdx());
        Item shieldSlot = equipment.getItem(EquipmentInventorySlot.SHIELD.getSlotIdx());
        InfiniteRuneItem mainHand = weaponSlot == null ? null : InfiniteRuneItem.getInfiniteRuneItem(weaponSlot.getId());
        updated.setMainHand(mainHand);
        InfiniteRuneItem offHand = shieldSlot == null ? null : InfiniteRuneItem.getInfiniteRuneItem(shieldSlot.getId());
        updated.setOffHand(offHand);
        return updated;
    }

    public Map<RuneType, Integer> availableRunes(PlayerInventory player) {
        InfiniteRuneItem offHand;
        InfiniteRuneItem weapon;
        RuneType t;
        int n;
        RuneType[] runeTypeArray;
        EnumMap<RuneType, Integer> runes = new EnumMap<RuneType, Integer>(RuneType.class);
        for (RuneItemQuantity item : player.getRunes()) {
            runeTypeArray = item.getRune().getMatchingTypes();
            n = runeTypeArray.length;
            for (int i = 0; i < n; ++i) {
                t = runeTypeArray[i];
                runes.merge(t, item.getQuantity(), Integer::sum);
            }
        }
        if (player.getPouch() != null) {
            int pouchSize = 4;
            switch (player.getPouch().getPouchType()) {
                case THREE_SLOTS: {
                    pouchSize = 3;
                }
                case FOUR_SLOTS: {
                    int amount;
                    EnumComposition runepouchEnum = this.clientData.getRunepouchEnum();
                    for (int i = 0; i < pouchSize; ++i) {
                        int runeId;
                        RuneItem rune;
                        int runepouchId = this.clientData.varbitValue(AutocastingConstants.VARBIT_RUNE_POUCH_RUNES[i]);
                        amount = this.clientData.varbitValue(AutocastingConstants.VARBIT_RUNE_POUCH_AMOUNTS[i]);
                        if (runepouchId == 0 || amount <= 0 || (rune = RuneItem.getRuneItem(runeId = runepouchEnum.getIntValue(runepouchId))) == null) continue;
                        for (RuneType t2 : rune.getMatchingTypes()) {
                            runes.merge(t2, amount, Integer::sum);
                        }
                    }
                    break;
                }
                case LMS: {
                    runes.put(RuneType.WATER, Integer.MAX_VALUE);
                    runes.put(RuneType.DEATH, Integer.MAX_VALUE);
                    runes.put(RuneType.BLOOD, Integer.MAX_VALUE);
                    runes.put(RuneType.SOUL, Integer.MAX_VALUE);
                    break;
                }
                case INFINITE: {
                    int amount;
                    runeTypeArray = RuneType.values();
                    n = runeTypeArray.length;
                    for (amount = 0; amount < n; ++amount) {
                        t = runeTypeArray[amount];
                        runes.put(t, Integer.MAX_VALUE);
                    }
                    break;
                }
            }
        }
        if ((weapon = player.getMainHand()) != null) {
            for (EnumComposition rune : weapon.getMatchingTypes()) {
                runes.put((RuneType)rune, Integer.MAX_VALUE);
            }
        }
        if ((offHand = player.getOffHand()) != null) {
            for (RuneType rune : offHand.getMatchingTypes()) {
                runes.put(rune, Integer.MAX_VALUE);
            }
        }
        return runes;
    }

    public int calculateCastsRemaining(Spell spell, Map<RuneType, Integer> runes) {
        if (runes == null) {
            return 0;
        }
        if (this.clientData.varbitValue(4145) == 1) {
            return Integer.MAX_VALUE;
        }
        RuneTypeQuantity[] cost = spell.getSpellCost().getRuneCost();
        int lowestCasts = Integer.MAX_VALUE;
        for (RuneTypeQuantity rune : cost) {
            RuneType runeType = rune.getRuneType();
            int specificRuneCost = rune.getQuantity();
            Integer amountHeld = runes.getOrDefault((Object)runeType, null);
            if (amountHeld == null) {
                return 0;
            }
            int casts = amountHeld == Integer.MAX_VALUE ? Integer.MAX_VALUE : amountHeld / specificRuneCost;
            lowestCasts = Math.min(casts, lowestCasts);
        }
        return lowestCasts;
    }
}

