/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting;

import com.autocasting.AutocastingConfig;
import com.autocasting.AutocastingOverlay;
import com.autocasting.AutocastingState;
import com.autocasting.AutocastingSubscriptions;
import com.autocasting.datatypes.Spell;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Autocasting", description="Tracks your autocast spell and alerts you when it can't be used.", tags={"notifier", "notifications", "mage", "magic", "reduced", "reduction", "level", "drain", "autocasting", "autocast", "cast", "casts", "utilities", "brew", "runes", "tracker", "alert"})
public class AutocastingPlugin
extends Plugin {
    @Inject
    private AutocastingState state;
    @Inject
    private AutocastingOverlay autocastOverlay;
    @Inject
    private AutocastingSubscriptions subscriptions;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this.subscriptions);
        this.clientThread.invoke(this::onStartup);
        this.overlayManager.add((Overlay)this.autocastOverlay);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this.subscriptions);
        this.overlayManager.remove((Overlay)this.autocastOverlay);
    }

    private void onStartup() {
        this.state.setCurrentAutocastSpell(Spell.NO_SPELL);
    }

    @Provides
    AutocastingConfig provideConfig(ConfigManager configManager) {
        return (AutocastingConfig)configManager.getConfig(AutocastingConfig.class);
    }
}

