/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting;

import com.autocasting.AutocastingClientData;
import com.autocasting.AutocastingConfig;
import com.autocasting.AutocastingConstants;
import com.autocasting.AutocastingPlugin;
import com.autocasting.AutocastingState;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.inject.Singleton;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.SplitComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

@Singleton
class AutocastingOverlay
extends OverlayPanel {
    private float timeIntoFlash = 0.0f;
    private boolean isFlashing = true;
    private final int GAP_SIZE = 4;
    private final AutocastingState state;
    private final AutocastingConfig config;
    private final AutocastingClientData clientData;
    @Inject
    private SpriteManager spriteManager;

    @Inject
    AutocastingOverlay(AutocastingPlugin plugin, AutocastingConfig config, AutocastingState state, AutocastingClientData clientData) {
        super((Plugin)plugin);
        this.config = config;
        this.state = state;
        this.clientData = clientData;
        super.setDynamicFont(true);
    }

    public Dimension render(Graphics2D graphics) {
        boolean shouldRender;
        boolean bl = shouldRender = this.config.showOverlay() && this.state.isEquippedWeaponMagic() && (this.config.showOverlayOutsideCombat() || this.state.isConsideredInCombat());
        if (!shouldRender) {
            return null;
        }
        int casts = this.state.getCastsRemaining();
        boolean displayCasts = this.config.showCastsRemaining() && casts <= this.config.displayCastLimit() && this.state.hasActiveAutocast();
        String overrideText = this.getOverrideText(casts);
        TitleComponent textComponent = null;
        String textPart = "";
        if (this.config.showSpellName() || displayCasts || overrideText != null) {
            if (this.config.showSpellName() && displayCasts) {
                textPart = String.format("%s (%s)", this.getCurrentSpellName(), casts);
            } else {
                String string = textPart = displayCasts ? Integer.toString(casts) : this.getCurrentSpellName();
            }
            if (overrideText != null) {
                textPart = overrideText;
            }
            textComponent = TitleComponent.builder().text(textPart).build();
        }
        ImageComponent imageComponent = null;
        if (this.config.showSpellIcon()) {
            imageComponent = new ImageComponent(this.getCurrentSpellImage());
        }
        if (textComponent == null && imageComponent == null) {
            return null;
        }
        Object component = textComponent != null && imageComponent != null ? SplitComponent.builder().first((LayoutableRenderableEntity)textComponent).second((LayoutableRenderableEntity)imageComponent).orientation(ComponentOrientation.HORIZONTAL).gap(new Point(4, 0)).build() : (textComponent != null ? textComponent : imageComponent);
        this.panelComponent.getChildren().add(component);
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(textPart) + 10, 0));
        this.configureBackground(casts);
        return super.render(graphics);
    }

    private String getOverrideText(int casts) {
        String override;
        if (!this.config.enableOverrideText()) {
            return null;
        }
        if (this.state.isMagicLevelTooLowForSpell() && !(override = this.config.lowMagicLevelText().strip()).equals("")) {
            return override;
        }
        if (casts == 0 && this.state.hasActiveAutocast() && !(override = this.config.noRunesText().strip()).equals("")) {
            return override;
        }
        return null;
    }

    private void configureBackground(int casts) {
        boolean shouldAlert;
        boolean bl = shouldAlert = this.state.isMagicLevelTooLowForSpell() || casts == 0 && this.state.hasActiveAutocast();
        if (this.config.overlayAlertStyle() == AutocastingConstants.OverlayNotificationType.FLASH) {
            this.flashBackground(shouldAlert);
        } else {
            this.solidBackground(shouldAlert);
        }
    }

    private void flashBackground(boolean alert) {
        if (alert) {
            this.panelComponent.setBackgroundColor(this.isFlashing ? this.config.overlayAlertColor() : ComponentConstants.STANDARD_BACKGROUND_COLOR);
            this.timeIntoFlash += 100.0f / (float)this.clientData.fps();
            if (this.timeIntoFlash >= (float)this.config.getFlashPeriod()) {
                this.isFlashing = !this.isFlashing;
                this.timeIntoFlash = 0.0f;
            }
        } else {
            this.panelComponent.setBackgroundColor(ComponentConstants.STANDARD_BACKGROUND_COLOR);
            this.isFlashing = true;
            this.timeIntoFlash = 0.0f;
        }
    }

    private void solidBackground(boolean alert) {
        if (alert && this.config.overlayAlertStyle() == AutocastingConstants.OverlayNotificationType.SOLID) {
            this.panelComponent.setBackgroundColor(this.config.overlayAlertColor());
        } else {
            this.panelComponent.setBackgroundColor(ComponentConstants.STANDARD_BACKGROUND_COLOR);
        }
    }

    private BufferedImage getCurrentSpellImage() {
        int spriteId = this.state.getCurrentAutocastSpell().getSpriteID();
        return this.spriteManager.getSprite(spriteId, 0);
    }

    private String getCurrentSpellName() {
        return this.state.getCurrentAutocastSpell().getName();
    }
}

