/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting;

import com.autocasting.AutocastingConfig;
import com.autocasting.AutocastingConstants;
import com.autocasting.AutocastingState;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.client.Notifier;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;

@Singleton
public class AutocastingNotifications {
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private Notifier notifier;
    @Inject
    private AutocastingConfig config;
    @Inject
    private AutocastingState state;

    public void notifyStatDrain() {
        String autocastName = this.state.getCurrentAutocastSpell().getName();
        String message = String.format("Your Magic level has dropped too low to autocast %s!", autocastName);
        this.sendNotification(message, this.config.notifyOnStatDrain());
    }

    public void handleCastsUpdated(int previous, int current) {
        if (current == 0) {
            if (previous != 0) {
                this.notifyNoCasts();
            }
        } else {
            int threshold = this.config.lowCastNotificationThreshold();
            if (previous > threshold && current <= threshold) {
                this.notifyLowCasts(current);
            }
        }
    }

    private void notifyNoCasts() {
        String autocastName = this.state.getCurrentAutocastSpell().getName();
        String message = String.format("Out of runes to autocast %s!", autocastName);
        this.sendNotification(message, this.config.notifyOnNoCasts());
    }

    private void notifyLowCasts(int amount) {
        String autocastName = this.state.getCurrentAutocastSpell().getName();
        String message = String.format("%s casts of %s remaining.", amount, autocastName);
        this.sendNotification(message, this.config.notifyOnLowCasts());
    }

    private void sendNotification(String message, AutocastingConstants.ChatNotificationType notificationSetting) {
        boolean shouldSendMessage;
        boolean bl = shouldSendMessage = (this.state.isConsideredInCombat() || this.config.notifyOutOfCombat()) && !this.state.isBanking();
        if (!shouldSendMessage) {
            return;
        }
        switch (notificationSetting) {
            case GAME: {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message).build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                break;
            }
            case BOTH: {
                this.notifier.notify(message);
            }
        }
    }
}

