/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting;

import com.autocasting.AutocastingConstants;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="autocasting")
public interface AutocastingConfig
extends Config {
    @ConfigSection(name="Overlay", description="Overlay Settings", position=0)
    public static final String overlaySettings = "overlay";
    @ConfigSection(name="Notifications", description="In-Game and Desktop Notification Settings", position=13)
    public static final String notificationSettings = "notifications";

    @ConfigItem(keyName="showOverlay", name="Show Overlay", description="Show/hide overlay", position=1, section="overlay")
    default public boolean showOverlay() {
        return true;
    }

    @ConfigItem(keyName="showOverlayOutsideCombat", name="Show Outside of Combat", description="Display the autocast overlay panel outside of combat.", position=2, section="overlay")
    default public boolean showOverlayOutsideCombat() {
        return true;
    }

    @ConfigItem(keyName="showSpellName", name="Show Spell Name", description="Show/hide spell name", position=3, section="overlay")
    default public boolean showSpellName() {
        return true;
    }

    @ConfigItem(keyName="showSpellIcon", name="Show Spell Icon", description="Show/hide spell icon", position=4, section="overlay")
    default public boolean showSpellIcon() {
        return true;
    }

    @ConfigItem(keyName="enableOverrideText", name="Enable Override Text", description="Allow custom text to be displayed during alerts.", position=5, section="overlay")
    default public boolean enableOverrideText() {
        return true;
    }

    @ConfigItem(keyName="lowMagicLevelText", name="Low Magic Level Override Text", description="Text to override spell name when your magic level drops below the required level. Will not override if left blank.", position=6, section="overlay")
    default public String lowMagicLevelText() {
        return "RESTORE";
    }

    @ConfigItem(keyName="noRunesText", name="No Runes Override Text", description="Text to override spell name when you run out of runes for your autocast. Will not override if left blank.", position=7, section="overlay")
    default public String noRunesText() {
        return "NO RUNES";
    }

    @ConfigItem(keyName="overlayAlertStyle", name="Overlay Alert Style", description="Configures how the overlay behaves when the autocast is unusable.", position=8, section="overlay")
    default public AutocastingConstants.OverlayNotificationType overlayAlertStyle() {
        return AutocastingConstants.OverlayNotificationType.FLASH;
    }

    @Alpha
    @ConfigItem(keyName="overlayAlertColor", name="Overlay Alert Color", description="Color of Autocast overlay when flashing/solid", position=9, section="overlay")
    default public Color overlayAlertColor() {
        return AutocastingConstants.RED_FLASH_COLOR;
    }

    @Range(min=1)
    @ConfigItem(keyName="flashPeriod", name="Overlay Flash Period", description="Period (in hundredths of seconds) at which the Autocast overlay flashes. Lower numbers flash faster.", position=10, section="overlay")
    default public int getFlashPeriod() {
        return 60;
    }

    @ConfigItem(keyName="showCastsRemaining", name="Display Casts Remaining", description="Puts the amount of casts of your autocast spell you have left, based on your current runes.", position=11, section="overlay")
    default public boolean showCastsRemaining() {
        return true;
    }

    @Range(min=1, max=999999)
    @ConfigItem(keyName="castRemainingThreshold", name="Display Cast Limit", description="Max amount of remaining casts which will be displayed. (1-999,999)", position=12, section="overlay")
    default public int displayCastLimit() {
        return 1000;
    }

    @ConfigItem(keyName="notifyOutOfCombat", name="Notify Out Of Combat", description="Controls if notifications for autocast spells will appear outside of combat.", position=14, section="notifications")
    default public boolean notifyOutOfCombat() {
        return true;
    }

    @ConfigItem(keyName="notifyOnStatDrain", name="Stat Drain Notification", description="Notifies you when your magic level falls below the level required for your autocast spell.", position=15, section="notifications")
    default public AutocastingConstants.ChatNotificationType notifyOnStatDrain() {
        return AutocastingConstants.ChatNotificationType.BOTH;
    }

    @ConfigItem(keyName="notifyOnLowCasts", name="Low Casts Notification", description="Notifies you when your amount of casts falls to or below the Low Cast Threshold.", position=16, section="notifications")
    default public AutocastingConstants.ChatNotificationType notifyOnLowCasts() {
        return AutocastingConstants.ChatNotificationType.BOTH;
    }

    @Range(min=1, max=999999)
    @ConfigItem(keyName="lowCastNotificationThreshold", name="Low Cast Threshold", description="Amount of casts to notify you on, based on your current runes.", position=17, section="notifications")
    default public int lowCastNotificationThreshold() {
        return 100;
    }

    @ConfigItem(keyName="notifyOnLowCasts", name="No Casts Notification", description="Notifies you when you run out of runes to cast your autocast spell.", position=18, section="notifications")
    default public AutocastingConstants.ChatNotificationType notifyOnNoCasts() {
        return AutocastingConstants.ChatNotificationType.BOTH;
    }
}

