/*
 * Decompiled with CFR 0.152.
 */
package com.autocasting;

import com.autocasting.datatypes.Spell;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import org.apache.commons.lang3.ArrayUtils;

public class AutocastingClientData {
    @Inject
    private Client client;

    public int getAutocastVarbit() {
        return this.client.getVarbitValue(276);
    }

    public Spell getAutocastSpell() {
        int varbitValue = this.getAutocastVarbit();
        return Spell.getSpell(varbitValue);
    }

    public int getWeaponTypeId() {
        return this.client.getVarbitValue(357);
    }

    public boolean isInCombat() {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return false;
        }
        Actor interacting = localPlayer.getInteracting();
        boolean fightingNPC = interacting instanceof NPC && ArrayUtils.contains((Object[])((NPC)interacting).getComposition().getActions(), (Object)"Attack");
        boolean fightingPlayer = interacting instanceof Player && this.client.getVarbitValue(8121) == 1;
        return fightingNPC || fightingPlayer;
    }

    public int getGameTick() {
        return this.client.getTickCount();
    }

    public int fps() {
        return this.client.getFPS();
    }

    public EnumComposition getRunepouchEnum() {
        return this.client.getEnum(982);
    }

    public int varbitValue(int varbit) {
        return this.client.getVarbitValue(varbit);
    }

    public ItemContainer getInventory() {
        return this.client.getItemContainer(InventoryID.INVENTORY);
    }

    public ItemContainer getEquipment() {
        return this.client.getItemContainer(InventoryID.EQUIPMENT);
    }
}

