/*
 * Decompiled with CFR 0.152.
 */
package com.projectilerage.runelite.partyplay.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.client.config.FontType;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.TextComponent;

public class DynamicTextComponent
implements LayoutableRenderableEntity {
    private String text;
    private Color color;
    private Font font;
    private Point preferredLocation;
    private Dimension preferredSize;
    private final Rectangle bounds;

    public Dimension render(Graphics2D graphics) {
        int baseX = this.preferredLocation.x;
        int baseY = this.preferredLocation.y;
        FontMetrics metrics = graphics.getFontMetrics(this.font);
        TextComponent textComponent = new TextComponent();
        int x = Math.max(baseX, baseX + (this.preferredSize.width - metrics.stringWidth(this.text)) / 2);
        int y = baseY + metrics.getHeight();
        textComponent.setFont(this.font);
        textComponent.setText(this.text);
        textComponent.setColor(this.color);
        textComponent.setPosition(new Point(x, y));
        Dimension dimension = textComponent.render(graphics);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(new Dimension(dimension.width + (x - baseX) * 2, dimension.height));
        return this.bounds.getSize();
    }

    private static Color $default$color() {
        return Color.WHITE;
    }

    private static Font $default$font() {
        return FontType.REGULAR.getFont();
    }

    private static Point $default$preferredLocation() {
        return new Point();
    }

    private static Dimension $default$preferredSize() {
        return new Dimension(129, 0);
    }

    private static Rectangle $default$bounds() {
        return new Rectangle();
    }

    DynamicTextComponent(String text, Color color, Font font, Point preferredLocation, Dimension preferredSize, Rectangle bounds) {
        this.text = text;
        this.color = color;
        this.font = font;
        this.preferredLocation = preferredLocation;
        this.preferredSize = preferredSize;
        this.bounds = bounds;
    }

    public static DynamicTextComponentBuilder builder() {
        return new DynamicTextComponentBuilder();
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public static class DynamicTextComponentBuilder {
        private String text;
        private boolean color$set;
        private Color color;
        private boolean font$set;
        private Font font;
        private boolean preferredLocation$set;
        private Point preferredLocation;
        private boolean preferredSize$set;
        private Dimension preferredSize;
        private boolean bounds$set;
        private Rectangle bounds;

        DynamicTextComponentBuilder() {
        }

        public DynamicTextComponentBuilder text(String text) {
            this.text = text;
            return this;
        }

        public DynamicTextComponentBuilder color(Color color) {
            this.color = color;
            this.color$set = true;
            return this;
        }

        public DynamicTextComponentBuilder font(Font font) {
            this.font = font;
            this.font$set = true;
            return this;
        }

        public DynamicTextComponentBuilder preferredLocation(Point preferredLocation) {
            this.preferredLocation = preferredLocation;
            this.preferredLocation$set = true;
            return this;
        }

        public DynamicTextComponentBuilder preferredSize(Dimension preferredSize) {
            this.preferredSize = preferredSize;
            this.preferredSize$set = true;
            return this;
        }

        public DynamicTextComponentBuilder bounds(Rectangle bounds) {
            this.bounds = bounds;
            this.bounds$set = true;
            return this;
        }

        public DynamicTextComponent build() {
            Color color = this.color;
            if (!this.color$set) {
                color = DynamicTextComponent.$default$color();
            }
            Font font = this.font;
            if (!this.font$set) {
                font = DynamicTextComponent.$default$font();
            }
            Point preferredLocation = this.preferredLocation;
            if (!this.preferredLocation$set) {
                preferredLocation = DynamicTextComponent.$default$preferredLocation();
            }
            Dimension preferredSize = this.preferredSize;
            if (!this.preferredSize$set) {
                preferredSize = DynamicTextComponent.$default$preferredSize();
            }
            Rectangle bounds = this.bounds;
            if (!this.bounds$set) {
                bounds = DynamicTextComponent.$default$bounds();
            }
            return new DynamicTextComponent(this.text, color, font, preferredLocation, preferredSize, bounds);
        }

        public String toString() {
            return "DynamicTextComponent.DynamicTextComponentBuilder(text=" + this.text + ", color=" + this.color + ", font=" + this.font + ", preferredLocation=" + this.preferredLocation + ", preferredSize=" + this.preferredSize + ", bounds=" + this.bounds + ")";
        }
    }
}

