/*
 * Decompiled with CFR 0.152.
 */
package com.projectilerage.runelite.partyplay.ui.components;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;

public class DynamicSplitComponent
implements LayoutableRenderableEntity {
    private LayoutableRenderableEntity first;
    private LayoutableRenderableEntity second;
    private Point preferredLocation;
    private Dimension preferredSize;
    private ComponentOrientation orientation;
    private Point gap;
    private final Rectangle bounds;

    public Dimension render(Graphics2D graphics) {
        int totalHeight;
        int totalWidth;
        this.first.setPreferredLocation(this.preferredLocation);
        this.first.setPreferredSize(this.preferredSize);
        Dimension firstDimension = this.first.render(graphics);
        int x = 0;
        int y = 0;
        if (this.orientation == ComponentOrientation.VERTICAL) {
            y = firstDimension.height + this.gap.y;
            this.preferredSize.width = Math.max(firstDimension.width, this.preferredSize.width);
        } else {
            x = firstDimension.width + this.gap.x;
            this.preferredSize.height = Math.max(firstDimension.height, this.preferredSize.height);
        }
        this.second.setPreferredLocation(new Point(x + this.preferredLocation.x, y + this.preferredLocation.y));
        this.second.setPreferredSize(new Dimension(this.preferredSize.width - x, this.preferredSize.height - y));
        Dimension secondDimension = this.second.render(graphics);
        if (this.orientation == ComponentOrientation.VERTICAL) {
            totalWidth = Math.max(firstDimension.width, secondDimension.width);
            totalHeight = y + secondDimension.height;
        } else {
            totalHeight = Math.max(firstDimension.height, secondDimension.height);
            totalWidth = x + secondDimension.width;
        }
        Dimension dimension = new Dimension(totalWidth, totalHeight);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(dimension);
        return dimension;
    }

    private static Point $default$preferredLocation() {
        return new Point();
    }

    private static Dimension $default$preferredSize() {
        return new Dimension(129, 0);
    }

    private static ComponentOrientation $default$orientation() {
        return ComponentOrientation.VERTICAL;
    }

    private static Point $default$gap() {
        return new Point(0, 0);
    }

    private static Rectangle $default$bounds() {
        return new Rectangle();
    }

    DynamicSplitComponent(LayoutableRenderableEntity first, LayoutableRenderableEntity second, Point preferredLocation, Dimension preferredSize, ComponentOrientation orientation, Point gap, Rectangle bounds) {
        this.first = first;
        this.second = second;
        this.preferredLocation = preferredLocation;
        this.preferredSize = preferredSize;
        this.orientation = orientation;
        this.gap = gap;
        this.bounds = bounds;
    }

    public static DynamicSplitComponentBuilder builder() {
        return new DynamicSplitComponentBuilder();
    }

    public void setFirst(LayoutableRenderableEntity first) {
        this.first = first;
    }

    public void setSecond(LayoutableRenderableEntity second) {
        this.second = second;
    }

    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public void setOrientation(ComponentOrientation orientation) {
        this.orientation = orientation;
    }

    public void setGap(Point gap) {
        this.gap = gap;
    }

    public LayoutableRenderableEntity getFirst() {
        return this.first;
    }

    public LayoutableRenderableEntity getSecond() {
        return this.second;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public static class DynamicSplitComponentBuilder {
        private LayoutableRenderableEntity first;
        private LayoutableRenderableEntity second;
        private boolean preferredLocation$set;
        private Point preferredLocation;
        private boolean preferredSize$set;
        private Dimension preferredSize;
        private boolean orientation$set;
        private ComponentOrientation orientation;
        private boolean gap$set;
        private Point gap;
        private boolean bounds$set;
        private Rectangle bounds;

        DynamicSplitComponentBuilder() {
        }

        public DynamicSplitComponentBuilder first(LayoutableRenderableEntity first) {
            this.first = first;
            return this;
        }

        public DynamicSplitComponentBuilder second(LayoutableRenderableEntity second) {
            this.second = second;
            return this;
        }

        public DynamicSplitComponentBuilder preferredLocation(Point preferredLocation) {
            this.preferredLocation = preferredLocation;
            this.preferredLocation$set = true;
            return this;
        }

        public DynamicSplitComponentBuilder preferredSize(Dimension preferredSize) {
            this.preferredSize = preferredSize;
            this.preferredSize$set = true;
            return this;
        }

        public DynamicSplitComponentBuilder orientation(ComponentOrientation orientation) {
            this.orientation = orientation;
            this.orientation$set = true;
            return this;
        }

        public DynamicSplitComponentBuilder gap(Point gap) {
            this.gap = gap;
            this.gap$set = true;
            return this;
        }

        public DynamicSplitComponentBuilder bounds(Rectangle bounds) {
            this.bounds = bounds;
            this.bounds$set = true;
            return this;
        }

        public DynamicSplitComponent build() {
            Point preferredLocation = this.preferredLocation;
            if (!this.preferredLocation$set) {
                preferredLocation = DynamicSplitComponent.$default$preferredLocation();
            }
            Dimension preferredSize = this.preferredSize;
            if (!this.preferredSize$set) {
                preferredSize = DynamicSplitComponent.$default$preferredSize();
            }
            ComponentOrientation orientation = this.orientation;
            if (!this.orientation$set) {
                orientation = DynamicSplitComponent.$default$orientation();
            }
            Point gap = this.gap;
            if (!this.gap$set) {
                gap = DynamicSplitComponent.$default$gap();
            }
            Rectangle bounds = this.bounds;
            if (!this.bounds$set) {
                bounds = DynamicSplitComponent.$default$bounds();
            }
            return new DynamicSplitComponent(this.first, this.second, preferredLocation, preferredSize, orientation, gap, bounds);
        }

        public String toString() {
            return "DynamicSplitComponent.DynamicSplitComponentBuilder(first=" + this.first + ", second=" + this.second + ", preferredLocation=" + this.preferredLocation + ", preferredSize=" + this.preferredSize + ", orientation=" + this.orientation + ", gap=" + this.gap + ", bounds=" + this.bounds + ")";
        }
    }
}

