/*
 * Decompiled with CFR 0.152.
 */
package com.projectilerage.runelite.partyplay.ui.components;

import com.projectilerage.runelite.partyplay.ui.Padding;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.runelite.client.ui.overlay.components.BackgroundComponent;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class DynamicPanelComponent
extends PanelComponent {
    private final Rectangle bounds = new Rectangle();
    private Padding padding = new Padding(0, 0, 0, 0);
    private Point preferredLocation = new Point();
    private Dimension preferredSize = new Dimension(129, 0);
    private Color backgroundColor = ComponentConstants.STANDARD_BACKGROUND_COLOR;
    private final List<LayoutableRenderableEntity> children = new ArrayList<LayoutableRenderableEntity>();
    private ComponentOrientation orientation = ComponentOrientation.VERTICAL;
    private Rectangle border = new Rectangle(4, 4, 4, 4);
    private Point gap = new Point(0, 0);
    private final Dimension cachedDimensions = new Dimension();

    public Dimension render(Graphics2D graphics) {
        if (this.children.isEmpty()) {
            return new Dimension(0, 0);
        }
        int prefWidth = Math.max(this.preferredSize.width, this.cachedDimensions.width);
        int prefHeight = Math.max(this.preferredSize.height, this.cachedDimensions.height);
        if (this.backgroundColor != null) {
            BackgroundComponent backgroundComponent = new BackgroundComponent();
            backgroundComponent.setRectangle(new Rectangle(this.preferredLocation, new Dimension(prefWidth, prefHeight)));
            backgroundComponent.setBackgroundColor(this.backgroundColor);
            backgroundComponent.render(graphics);
        }
        int baseX = this.preferredLocation.x + this.border.x + this.padding.getLeft();
        int baseY = this.preferredLocation.y + this.border.y + this.padding.getTop();
        int totalHorizontalOffset = this.border.x + this.border.width + this.padding.getHorizontal();
        int totalVerticalOffset = this.border.y + this.border.height + this.padding.getVertical();
        int width = 0;
        int height = 0;
        int x = baseX;
        int y = baseY;
        Dimension childPreferredSize = new Dimension(prefWidth - totalHorizontalOffset, prefHeight - totalVerticalOffset);
        int totalHeight = 0;
        int totalWidth = 0;
        for (LayoutableRenderableEntity child : this.children) {
            switch (this.orientation) {
                case VERTICAL: {
                    child.setPreferredSize(new Dimension(childPreferredSize.width, 0));
                    break;
                }
                case HORIZONTAL: {
                    child.setPreferredSize(new Dimension(0, childPreferredSize.height));
                }
            }
            child.setPreferredLocation(new Point(x, y));
            Dimension childDimension = child.render(graphics);
            if (this.orientation == ComponentOrientation.VERTICAL) {
                y = baseY + (height += childDimension.height + this.gap.y);
                width = Math.max(childDimension.width, width);
            } else {
                x = baseX + (width += childDimension.width + this.gap.x);
                height = Math.max(childDimension.height, height);
            }
            totalWidth = Math.max(totalWidth, width);
            totalHeight = Math.max(totalHeight, height);
        }
        if (this.orientation == ComponentOrientation.HORIZONTAL) {
            totalWidth -= this.gap.x;
        } else {
            totalHeight -= this.gap.y;
        }
        this.cachedDimensions.setSize(totalWidth += totalHorizontalOffset, totalHeight += totalVerticalOffset);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(totalWidth, totalHeight);
        return this.bounds.getSize();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setPadding(Padding padding) {
        this.padding = padding;
    }

    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public List<LayoutableRenderableEntity> getChildren() {
        return this.children;
    }

    public void setOrientation(ComponentOrientation orientation) {
        this.orientation = orientation;
    }

    public void setBorder(Rectangle border) {
        this.border = border;
    }

    public void setGap(Point gap) {
        this.gap = gap;
    }
}

