/*
 * Decompiled with CFR 0.152.
 */
package com.projectilerage.runelite.partyplay.ui.components;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.components.BackgroundComponent;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

public class DynamicInfoBoxComponent
implements LayoutableRenderableEntity {
    private static final int DEFAULT_SIZE = 32;
    private final TooltipManager tooltipManager;
    private final Client client;
    private String tooltip;
    private final Rectangle bounds = new Rectangle();
    private Point preferredLocation = new Point();
    private Dimension preferredSize = new Dimension(32, 32);
    private String text;
    private Color color = Color.WHITE;
    private Font font = FontManager.getDefaultFont();
    private boolean outline;
    private Color backgroundColor = ComponentConstants.STANDARD_BACKGROUND_COLOR;
    private BufferedImage image;

    public DynamicInfoBoxComponent(Client client, TooltipManager tooltipManager) {
        this.client = client;
        this.tooltipManager = tooltipManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.image == null) {
            return new Dimension();
        }
        graphics.setFont(this.getSize() < 32 ? FontManager.getRunescapeSmallFont() : this.font);
        int baseX = this.preferredLocation.x;
        int baseY = this.preferredLocation.y;
        int width = Math.max(this.image.getWidth(), this.preferredSize.width);
        int height = Math.max(this.image.getHeight(), this.preferredSize.height);
        int calcX = Math.max(baseX, baseX + (width - this.image.getWidth(null)) / 2);
        int calcY = Math.max(baseY, baseY + (height - this.image.getHeight(null)) / 2);
        Rectangle bounds = new Rectangle(baseX, baseY, width, height);
        if (this.backgroundColor != null) {
            BackgroundComponent backgroundComponent = new BackgroundComponent();
            backgroundComponent.setBackgroundColor(this.backgroundColor);
            backgroundComponent.setRectangle(bounds);
            backgroundComponent.render(graphics);
        }
        graphics.drawImage((Image)this.image, calcX, calcY, null);
        if (!Strings.isNullOrEmpty((String)this.text)) {
            int y = calcY + this.image.getHeight();
            int x = calcX + this.image.getWidth() / 2 - graphics.getFontMetrics().stringWidth(this.text) / 2;
            TextComponent textComponent = new TextComponent();
            textComponent.setColor(this.color);
            textComponent.setOutline(this.outline);
            textComponent.setFont(graphics.getFont());
            textComponent.setText(this.text);
            textComponent.setPosition(new Point(x, y));
            textComponent.render(graphics);
        }
        this.bounds.setBounds(bounds);
        if (!Strings.isNullOrEmpty((String)this.tooltip)) {
            Point mouse = new Point(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY());
            Rectangle intersectionRectangle = new Rectangle(this.getBounds());
            intersectionRectangle.translate(Math.abs(graphics.getClipBounds().x), Math.abs(graphics.getClipBounds().y));
            if (intersectionRectangle.contains(mouse)) {
                this.tooltipManager.add(new Tooltip(this.tooltip));
            }
        }
        return bounds.getSize();
    }

    private int getSize() {
        return Math.max(this.preferredSize.width, this.preferredSize.height);
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }
}

