/*
 * Decompiled with CFR 0.152.
 */
package com.projectilerage.runelite.partyplay;

import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.projectilerage.runelite.partyplay.ActivityInfo;
import com.projectilerage.runelite.partyplay.GameEventType;
import com.projectilerage.runelite.partyplay.PartyPlayConfig;
import com.projectilerage.runelite.partyplay.PartyPlayPlugin;
import com.projectilerage.runelite.partyplay.PartyPresence;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.messages.PartyMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class PartyState {
    private static final Logger log = LoggerFactory.getLogger(PartyState.class);
    private final List<EventWithTime> events = Collections.synchronizedList(new LinkedList());
    private final PartyPlayConfig config;
    private final PartyPlayPlugin plugin;
    private final PartyService partyService;
    private final String defaultLocalPlayerName = "<unknown>";
    private final WSClient wsClient;
    private PartyPresence lastPresence = null;
    private String localPlayerName = "<unknown>";

    @Inject
    private PartyState(PartyPlayConfig config, PartyPlayPlugin plugin, PartyService partyService, WSClient wsClient) {
        this.config = config;
        this.plugin = plugin;
        this.partyService = partyService;
        this.wsClient = wsClient;
    }

    void setLocalPlayerName(String name) {
        boolean shouldUpdate = false;
        if (Strings.isNullOrEmpty((String)name)) {
            if (this.localPlayerName.equals(this.defaultLocalPlayerName)) {
                log.debug("PPD:: setLocalPlayerName.null");
                if (this.partyService.getLocalMember() != null) {
                    log.debug("PPD:: setLocalPlayerName.memberId");
                    this.localPlayerName = String.valueOf(this.partyService.getLocalMember().getMemberId());
                } else {
                    log.debug("PPD:: setLocalPlayerName.default");
                    this.localPlayerName = "<unknown>";
                }
                shouldUpdate = true;
            }
        } else {
            log.debug("PPD:: setLocalPlayerName.name");
            this.localPlayerName = name;
            shouldUpdate = true;
        }
        if (shouldUpdate) {
            log.debug("PPD:: setLocalPlayerName.shouldUpdate");
            if (this.lastPresence != null) {
                log.debug("PPD:: setLocalPlayerName.lastPresence");
                this.maybeSharePresence(this.lastPresence);
            } else {
                log.debug("PPD:: setLocalPlayerName.updatePresenceWithLatestEvent");
                this.updatePresenceWithLatestEvent();
            }
        }
    }

    void reset() {
        log.debug("Resetting");
        this.events.clear();
        this.lastPresence = null;
        this.plugin.clearSlayerState();
    }

    void refresh() {
        log.debug("Refreshing: \n\t" + this.partyService.getLocalMember() + "\n\t" + this.lastPresence);
        this.maybeSharePresence(this.lastPresence, true);
    }

    void triggerEvent(GameEventType eventType) {
        EventWithTime event;
        if (eventType == null) {
            log.error("Tried to pass null event type");
            log.error(Thread.currentThread().getStackTrace().toString());
            return;
        }
        Optional<EventWithTime> foundEvent = this.events.stream().filter(e -> e.type == eventType).findFirst();
        if (foundEvent.isPresent()) {
            event = foundEvent.get();
        } else {
            event = new EventWithTime(eventType);
            event.setStart(Instant.now());
            this.events.add(event);
        }
        event.setUpdated(Instant.now());
        if (event.getType().isShouldClear()) {
            log.debug("Clearing events");
            this.events.removeAll(this.events.parallelStream().filter(e -> e.getType() != eventType && e.getType().isShouldBeCleared()).collect(Collectors.toList()));
        }
        if (event.getType().isShouldRestart()) {
            event.setStart(Instant.now());
        }
        this.events.sort((a, b) -> ComparisonChain.start().compare(b.getType().getPriority(), a.getType().getPriority()).compare((Comparable)b.getUpdated(), (Comparable)a.getUpdated()).result());
        this.updatePresenceWithLatestEvent();
    }

    private void updatePresenceWithLatestEvent() {
        if (this.events.isEmpty()) {
            this.reset();
            return;
        }
        EventWithTime event = this.events.get(0);
        String activity = null;
        String area = null;
        GameEventType activityEvent = null;
        GameEventType areaEvent = null;
        for (EventWithTime eventWithTime : this.events) {
            GameEventType eventType = eventWithTime.getType();
            if (activity == null && eventType.getAreaType() == null) {
                activity = eventType.getState() != null ? eventType.getState() : eventType.getDetails();
                activityEvent = eventType;
            }
            if (area == null && eventType.getAreaType() != null) {
                area = eventType.getState();
                areaEvent = eventType;
            }
            if (activity == null || area == null) continue;
            break;
        }
        PartyPresence presence = PartyPresence.builder().activity(activity).area(area).activityEvent(activityEvent).areaEvent(areaEvent).build();
        this.maybeSharePresence(presence);
        this.lastPresence = presence;
    }

    private void maybeSharePresence(PartyPresence presence) {
        this.maybeSharePresence(presence, false);
    }

    private void maybeSharePresence(PartyPresence presence, boolean force) {
        PartyMember localMember;
        if (presence == null) {
            return;
        }
        if (!(!force && presence.equals(this.lastPresence) && presence.getName().equals(this.localPlayerName) || (localMember = this.partyService.getLocalMember()) == null)) {
            ActivityInfo.ActivityInfoBuilder infoBuild = ActivityInfo.builder();
            if (presence.getActivityEvent() == GameEventType.IN_MENU) {
                if (this.config.showMainMenu()) {
                    infoBuild.activity(presence.getActivity());
                }
            } else if (this.config.showSkillingActivity()) {
                infoBuild.activity(presence.getActivity());
            } else {
                infoBuild.activity(GameEventType.IN_GAME.getState());
            }
            boolean showAreaType = false;
            if (presence.getAreaEvent() != null) {
                switch (presence.getAreaEvent().getAreaType()) {
                    case RAIDS: {
                        if (!this.config.showRaidingActivity()) break;
                        showAreaType = true;
                        break;
                    }
                    case BOSSES: {
                        if (!this.config.showBossActivity()) break;
                        showAreaType = true;
                        break;
                    }
                    case CITIES: {
                        if (!this.config.showCityActivity()) break;
                        showAreaType = true;
                        break;
                    }
                    case REGIONS: {
                        if (!this.config.showRegionsActivity()) break;
                        showAreaType = true;
                        break;
                    }
                    case DUNGEONS: {
                        if (!this.config.showDungeonActivity()) break;
                        showAreaType = true;
                        break;
                    }
                    case MINIGAMES: {
                        if (!this.config.showMinigameActivity()) break;
                        showAreaType = true;
                    }
                }
            }
            if (showAreaType) {
                infoBuild.location(presence.getArea());
            } else {
                infoBuild.location("Gielinor");
            }
            String name = this.localPlayerName;
            infoBuild.userId(name);
            presence.setName(name);
            ActivityInfo info = infoBuild.build();
            info.setMemberId(localMember.getMemberId());
            this.partyService.send((PartyMessage)info);
            this.plugin.setActivityInfo(info);
        }
    }

    void checkForTimeout() {
        if (this.events.isEmpty()) {
            log.debug("PPD:: Events is empty. Exiting timeouts check");
            return;
        }
        log.debug("PPD:: Checking for timeouts");
        Duration actionTimeout = Duration.ofMinutes(this.config.actionTimeout());
        Instant now = Instant.now();
        int initalLength = this.events.size();
        List eventsToRemove = this.events.parallelStream().filter(event -> event.getType().isShouldTimeout() && now.isAfter(event.getUpdated().plus(actionTimeout))).collect(Collectors.toList());
        if (!eventsToRemove.isEmpty()) {
            this.events.removeAll(eventsToRemove);
            log.debug(this.events.size() - initalLength + " events removed. Updating");
            this.updatePresenceWithLatestEvent();
            if (eventsToRemove.parallelStream().anyMatch(event -> event.getType() == GameEventType.TRAINING_SLAYER)) {
                log.debug("PPD:: Slayer event timed-out. Triggering slayer removal");
                this.plugin.clearSlayerState();
            }
        }
    }

    boolean containsEventType(GameEventType eventType) {
        return this.events.parallelStream().anyMatch(e -> e.getType() == eventType);
    }

    private static class EventWithTime {
        private final GameEventType type;
        private Instant start;
        private Instant updated;

        public EventWithTime(GameEventType type) {
            this.type = type;
        }

        public GameEventType getType() {
            return this.type;
        }

        public Instant getStart() {
            return this.start;
        }

        public Instant getUpdated() {
            return this.updated;
        }

        public void setStart(Instant start) {
            this.start = start;
        }

        public void setUpdated(Instant updated) {
            this.updated = updated;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventWithTime)) {
                return false;
            }
            EventWithTime other = (EventWithTime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GameEventType this$type = this.getType();
            GameEventType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Instant this$start = this.getStart();
            Instant other$start = other.getStart();
            if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
                return false;
            }
            Instant this$updated = this.getUpdated();
            Instant other$updated = other.getUpdated();
            return !(this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EventWithTime;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GameEventType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Instant $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            Instant $updated = this.getUpdated();
            result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
            return result;
        }

        public String toString() {
            return "PartyState.EventWithTime(type=" + this.getType() + ", start=" + this.getStart() + ", updated=" + this.getUpdated() + ")";
        }
    }
}

