/*
 * Decompiled with CFR 0.152.
 */
package com.projectilerage.runelite.partyplay;

import com.google.common.base.Strings;
import com.google.inject.Provides;
import com.projectilerage.runelite.partyplay.ActivityInfo;
import com.projectilerage.runelite.partyplay.GameEventType;
import com.projectilerage.runelite.partyplay.PartyOverlay;
import com.projectilerage.runelite.partyplay.PartyPlayConfig;
import com.projectilerage.runelite.partyplay.PartyState;
import com.projectilerage.runelite.partyplay.PartyStateInfo;
import com.projectilerage.runelite.partyplay.SlayerInfo;
import com.projectilerage.runelite.partyplay.SlayerTask;
import com.projectilerage.runelite.partyplay.ui.components.DynamicInfoBoxComponent;
import java.awt.image.BufferedImage;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.FontType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.events.UserJoin;
import net.runelite.client.party.events.UserPart;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.party.messages.UserSync;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.party.messages.StatusUpdate;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Party Play", description="Makes Runescape a little less single-player", tags={"action", "activity", "status"})
@Singleton
public class PartyPlayPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PartyPlayPlugin.class);
    @Inject
    private Client client;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private PartyPlayConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PartyService partyService;
    @Inject
    private PartyOverlay partyOverlay;
    @Inject
    private PartyState state;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private WSClient wsClient;
    private final Map<Skill, Integer> skillExp = new HashMap<Skill, Integer>();
    private final Map<Long, PartyStateInfo> partyStateInfoMap = Collections.synchronizedMap(new HashMap());
    private final Integer DEFAULT_SLAYER_ITEM = 11864;
    private GameEventType curArea;
    private boolean loginFlag;

    protected void startUp() throws Exception {
        this.wsClient.registerMessage(ActivityInfo.class);
        this.wsClient.registerMessage(SlayerInfo.class);
        this.state.reset();
        this.checkForGameStateUpdate();
        this.checkForAreaUpdate();
        this.overlayManager.add((Overlay)this.partyOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.partyOverlay);
        this.wsClient.unregisterMessage(ActivityInfo.class);
        this.wsClient.unregisterMessage(SlayerInfo.class);
        this.state.reset();
        this.partyStateInfoMap.clear();
    }

    @Subscribe
    public void onUserJoin(UserJoin event) {
        log.debug("onUserJoin: " + this.partyService.getLocalMember());
        this.state.refresh();
        this.processSlayerConfig();
    }

    @Subscribe
    public void onUserSync(UserSync event) {
        log.debug("onUserSync: " + this.partyService.getLocalMember());
        this.state.refresh();
        this.processSlayerConfig();
    }

    @Subscribe
    public void onUserPart(UserPart event) {
        log.debug("onUserPart: " + this.partyService.getLocalMember());
        this.partyStateInfoMap.remove(event.getMemberId());
    }

    @Subscribe
    public void onPartyChanged(PartyChanged event) {
        log.debug("onPartyChange: " + this.partyService.getLocalMember());
        this.partyStateInfoMap.clear();
        this.state.refresh();
        this.processSlayerConfig();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("partyplay")) {
            log.debug("Config changed; refreshing");
            this.state.refresh();
            this.processSlayerConfig();
        } else if (event.getGroup().equals("slayer")) {
            this.processSlayerConfig();
        }
    }

    @Provides
    public PartyPlayConfig provideConfig(ConfigManager configManager) {
        return (PartyPlayConfig)configManager.getConfig(PartyPlayConfig.class);
    }

    private String getLocalPlayerName() {
        String name = this.client.getLocalPlayer().getName();
        if (name != null) {
            return name;
        }
        return "Client Unknown";
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: {
                this.state.reset();
                this.checkForGameStateUpdate();
                return;
            }
            case LOGGING_IN: {
                this.loginFlag = true;
                break;
            }
            case LOGGED_IN: {
                if (this.loginFlag) {
                    this.loginFlag = false;
                    this.state.reset();
                    this.processSlayerConfig();
                    this.checkForGameStateUpdate();
                }
                this.checkForAreaUpdate();
            }
        }
    }

    private void checkForGameStateUpdate() {
        boolean isLoggedIn;
        boolean bl = isLoggedIn = this.client.getGameState() == GameState.LOGGED_IN;
        if (this.config.showMainMenu() || isLoggedIn) {
            this.state.triggerEvent(isLoggedIn ? GameEventType.IN_GAME : GameEventType.IN_MENU);
        }
    }

    @Subscribe
    public void onStatusUpdate(StatusUpdate statusUpdate) {
        if (statusUpdate.getMemberId() == this.partyService.getLocalMember().getMemberId()) {
            log.debug("PPD:: onStatusUpdate: Setting " + Strings.nullToEmpty((String)statusUpdate.getCharacterName()));
            this.state.setLocalPlayerName(statusUpdate.getCharacterName());
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        int exp;
        Skill skill = statChanged.getSkill();
        Integer previous = this.skillExp.put(skill, exp = statChanged.getXp());
        if (previous == null || previous >= exp) {
            return;
        }
        GameEventType event = GameEventType.fromSkill(skill);
        if (event != null) {
            this.state.triggerEvent(event);
        }
    }

    @Schedule(period=1L, unit=ChronoUnit.MINUTES)
    public void trimStateEvents() {
        this.state.checkForTimeout();
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS)
    public void maybeCheckForAreaUpdate() {
        if (!GameState.LOGGED_IN.equals((Object)this.client.getGameState())) {
            return;
        }
        int regionId = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        if (this.curArea == null || Arrays.stream(this.curArea.getRegionIds()).noneMatch(oldRegionId -> oldRegionId == regionId)) {
            log.debug("Area Update Check");
            this.checkForAreaUpdate();
        }
    }

    private void checkForAreaUpdate() {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        int playerRegionID = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        if (playerRegionID == 0) {
            return;
        }
        EnumSet worldType = this.client.getWorldType();
        if (worldType.contains(WorldType.DEADMAN)) {
            this.state.triggerEvent(GameEventType.PLAYING_DEADMAN);
        } else if (WorldType.isPvpWorld((Collection)worldType)) {
            this.state.triggerEvent(GameEventType.PLAYING_PVP);
        }
        GameEventType gameEventType = GameEventType.fromRegion(playerRegionID);
        if (GameEventType.MG_NIGHTMARE_ZONE == gameEventType && this.client.getLocalPlayer().getWorldLocation().getPlane() == 0) {
            gameEventType = null;
        }
        if (gameEventType == null) {
            log.debug("Triggering In Game Event: " + playerRegionID);
            this.state.triggerEvent(GameEventType.IN_GAME);
            return;
        }
        log.debug("Triggering Area Event: " + gameEventType.getState());
        this.curArea = gameEventType;
        this.state.triggerEvent(gameEventType);
    }

    @Subscribe
    public void onActivityInfo(ActivityInfo event) {
        log.debug("PPD:: onActivityInfo");
        this.setActivityInfo(event);
    }

    ActivityInfo getActivityInfo(Long uuid) {
        PartyStateInfo partyStateInfo = this.partyStateInfoMap.get(uuid);
        return partyStateInfo != null ? partyStateInfo.getActivityInfo() : null;
    }

    void setActivityInfo(ActivityInfo activityInfo) {
        PartyStateInfo partyStateInfo = this.partyStateInfoMap.get(activityInfo.getMemberId());
        log.debug("PPD:: setActivityInfo");
        if (partyStateInfo != null) {
            partyStateInfo.setActivityInfo(activityInfo);
        } else {
            this.partyStateInfoMap.put(activityInfo.getMemberId(), new PartyStateInfo(activityInfo));
        }
    }

    public DynamicInfoBoxComponent getSlayerInfoBox(SlayerTask task) {
        if (task == null || task.getName() == null) {
            log.debug("PPD:: Slayer task null; Exiting Slayer InfoBox creation");
            return null;
        }
        int size = (Integer)this.configManager.getConfiguration("runelite", "infoBoxSize", Integer.class);
        FontType font = (FontType)this.configManager.getConfiguration("runelite", "infoboxFontType", FontType.class);
        boolean outline = (Boolean)this.configManager.getConfiguration("runelite", "infoBoxTextOutline", Boolean.class);
        int item = task.getItemSpriteId();
        AsyncBufferedImage rawImage = this.itemManager.getImage(item != 0 ? item : this.DEFAULT_SLAYER_ITEM);
        BufferedImage image = ImageUtil.resizeImage((BufferedImage)rawImage, (int)size, (int)size, (boolean)true);
        DynamicInfoBoxComponent box = new DynamicInfoBoxComponent(this.client, this.tooltipManager);
        box.setImage(image);
        box.setFont(font.getFont());
        box.setOutline(outline);
        return box;
    }

    SlayerInfo getSlayerInfo(Long uuid) {
        PartyStateInfo partyStateInfo = this.partyStateInfoMap.get(uuid);
        return partyStateInfo != null ? partyStateInfo.getSlayerInfo() : null;
    }

    void setSlayerInfo(SlayerInfo slayerInfo) {
        PartyStateInfo partyStateInfo = this.partyStateInfoMap.get(slayerInfo.getMemberId());
        if (partyStateInfo != null) {
            partyStateInfo.setSlayerInfo(slayerInfo);
        } else if (slayerInfo.getSlayerTask() != null) {
            this.partyStateInfoMap.put(slayerInfo.getMemberId(), new PartyStateInfo(slayerInfo));
        }
    }

    @Subscribe
    void onSlayerInfo(SlayerInfo slayerInfo) {
        this.setSlayerInfo(slayerInfo);
    }

    void processSlayerConfig() {
        if (this.partyService.getLocalMember() == null || !this.state.containsEventType(GameEventType.TRAINING_SLAYER) || !this.config.showSlayerActivity()) {
            log.debug("PPD:: Slayer Event Non-applicable; Clearing Slayer state");
            this.clearSlayerState();
            return;
        }
        String taskName = this.configManager.getRSProfileConfiguration("slayer", "taskName");
        String amount = this.configManager.getRSProfileConfiguration("slayer", "amount");
        if (Strings.isNullOrEmpty((String)taskName) || Strings.isNullOrEmpty((String)amount)) {
            log.debug("PPD:: Null Slayer Event");
            return;
        }
        if (Integer.parseInt(amount) == 0) {
            log.debug("PPD:: Task completed. Clearing state");
            this.clearSlayerState();
            return;
        }
        SlayerInfo slayerInfo = this.getSlayerInfo(this.partyService.getLocalMember().getMemberId());
        if (slayerInfo == null) {
            slayerInfo = new SlayerInfo();
            slayerInfo.setMemberId(this.partyService.getLocalMember().getMemberId());
        }
        String initialAmount = this.configManager.getRSProfileConfiguration("slayer", "initialAmount");
        String taskLocation = this.configManager.getRSProfileConfiguration("slayer", "taskLocation");
        log.debug("PPD:: Slayer task left: " + amount);
        slayerInfo.setAmount(Integer.parseInt(amount));
        if (slayerInfo.getSlayerTask() == null || !taskName.equals(slayerInfo.getSlayerTask().getName())) {
            log.debug("PPD:: Slayer task name: " + taskName);
            slayerInfo.setSlayerTask(SlayerTask.getTask(taskName));
        }
        if (!Strings.isNullOrEmpty((String)initialAmount)) {
            log.debug("PPD:: Slayer task start: " + initialAmount);
            slayerInfo.setInitialAmount(Integer.parseInt(initialAmount));
        }
        if (!Strings.isNullOrEmpty((String)taskLocation)) {
            log.debug("PPD:: Slayer task location: " + taskLocation);
            slayerInfo.setLocation(taskLocation);
        }
        this.setSlayerInfo(slayerInfo);
        this.partyService.send((PartyMessage)slayerInfo);
    }

    void clearSlayerState() {
        if (this.partyService.getLocalMember() == null) {
            return;
        }
        long localId = this.partyService.getLocalMember().getMemberId();
        if (localId != 0L) {
            PartyStateInfo partyStateInfo = this.partyStateInfoMap.get(localId);
            if (partyStateInfo != null && partyStateInfo.getSlayerInfo() != null) {
                log.debug("PPD:: Removing slayer state");
                SlayerInfo slayerInfo = partyStateInfo.getSlayerInfo();
                slayerInfo.reset();
                this.partyService.send((PartyMessage)slayerInfo);
            }
        } else {
            log.debug("PPD:: Null Local Member; Can't clear Slayer state");
        }
    }

    Map<Long, PartyStateInfo> getPartyStateInfoMap() {
        return this.partyStateInfoMap;
    }
}

