/*
 * Decompiled with CFR 0.152.
 */
package com.projectilerage.runelite.partyplay;

import com.projectilerage.runelite.partyplay.ActivityInfo;
import com.projectilerage.runelite.partyplay.GameEventType;
import com.projectilerage.runelite.partyplay.PartyPlayConfig;
import com.projectilerage.runelite.partyplay.PartyPlayPlugin;
import com.projectilerage.runelite.partyplay.PartyState;
import com.projectilerage.runelite.partyplay.PartyStateInfo;
import com.projectilerage.runelite.partyplay.SlayerInfo;
import com.projectilerage.runelite.partyplay.SplitComponentWrapper;
import com.projectilerage.runelite.partyplay.ui.components.DynamicInfoBoxComponent;
import com.projectilerage.runelite.partyplay.ui.components.DynamicTextComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import lombok.NonNull;
import net.runelite.api.MenuAction;
import net.runelite.client.party.PartyService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.util.ColorUtil;

public class PartyOverlay
extends OverlayPanel {
    private final PartyPlayPlugin plugin;
    private final PartyState state;
    private final PartyService party;
    private final PartyPlayConfig config;
    private final Map<Long, SplitComponentWrapper> splitMap = new HashMap<Long, SplitComponentWrapper>();
    private final GameEventType longestEvent = GameEventType.REGION_DRILL_SERGEANT;
    private int width = 0;

    @Inject
    private PartyOverlay(PartyPlayPlugin plugin, PartyState state, PartyService party, PartyPlayConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.state = state;
        this.party = party;
        this.config = config;
        this.setResizable(false);
        this.panelComponent.setBorder(new Rectangle());
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Leave", "Party"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension render(Graphics2D graphics) {
        Map<Long, PartyStateInfo> partyDataMap = this.plugin.getPartyStateInfoMap();
        if (partyDataMap.isEmpty()) {
            return new Dimension();
        }
        int width = graphics.getFontMetrics().stringWidth(this.longestEvent.getState());
        int height = graphics.getFontMetrics().getHeight() * 3;
        this.setPreferredSize(new Dimension(width, height));
        this.panelComponent.setBackgroundColor(null);
        Map<Long, PartyStateInfo> map = partyDataMap;
        synchronized (map) {
            partyDataMap.forEach((uuid, stateInfo) -> {
                DynamicInfoBoxComponent box;
                SlayerInfo slayerInfo;
                boolean isSelf;
                if (stateInfo == null || stateInfo.getActivityInfo() == null) {
                    return;
                }
                boolean bl = isSelf = this.party.getLocalMember() != null && this.party.getLocalMember().getMemberId() == uuid.longValue();
                if (!this.config.includeSelf() && isSelf) {
                    return;
                }
                SplitComponentWrapper split = this.splitMap.get(uuid);
                if (split == null) {
                    split = new SplitComponentWrapper();
                    this.splitMap.put((Long)uuid, split);
                }
                split.clearChildren();
                ActivityInfo activityInfo = stateInfo.getActivityInfo();
                DynamicTextComponent name = DynamicTextComponent.builder().text(activityInfo.getUserId()).color(this.config.recolorNames() ? ColorUtil.fromObject((Object)activityInfo.getUserId()) : Color.WHITE).build();
                split.firstPanel.getChildren().add(name);
                if (stateInfo.getActivityInfo().getActivity() != null) {
                    DynamicTextComponent activity = DynamicTextComponent.builder().text(activityInfo.getActivity()).color(ColorUtil.fromObject((Object)activityInfo.getActivity())).build();
                    split.firstPanel.getChildren().add(activity);
                }
                if (stateInfo.getActivityInfo().getLocation() != null) {
                    DynamicTextComponent location = DynamicTextComponent.builder().text(activityInfo.getLocation()).color(ColorUtil.fromObject((Object)activityInfo.getLocation())).build();
                    split.firstPanel.getChildren().add(location);
                }
                if ((slayerInfo = stateInfo.getSlayerInfo()) != null && slayerInfo.getSlayerTask() != null && this.config.showSlayerActivity() && (box = this.plugin.getSlayerInfoBox(slayerInfo.getSlayerTask())) != null) {
                    box.setText(Integer.toString(slayerInfo.getAmount()));
                    box.setBackgroundColor(null);
                    box.setTooltip(PartyOverlay.getSlayerTooltip(slayerInfo));
                    split.secondPanel.getChildren().add(box);
                }
                this.panelComponent.getChildren().add(split.split);
            });
        }
        return super.render(graphics);
    }

    static String getSlayerTooltip(@NonNull SlayerInfo slayerInfo) {
        if (slayerInfo == null) {
            throw new NullPointerException("slayerInfo is marked @NonNull but is null");
        }
        String taskTooltip = ColorUtil.wrapWithColorTag((String)"%s", (Color)new Color(157, 8, 8)) + "</br>";
        if (slayerInfo.getLocation() != null && !slayerInfo.getLocation().isEmpty()) {
            taskTooltip = taskTooltip + slayerInfo.getLocation() + "</br>";
        }
        if (slayerInfo.getInitialAmount() > 0) {
            taskTooltip = taskTooltip + "</br>" + ColorUtil.wrapWithColorTag((String)"Start:", (Color)Color.YELLOW) + " " + slayerInfo.getInitialAmount();
        }
        return String.format(taskTooltip, slayerInfo.getSlayerTask().getName());
    }
}

