/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorpro.uiSpedwards;

import com.calculatorpro.CalculatorProPlugin;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.swing.JTextField;

public class DisplayField
extends JTextField {
    Double result;
    public String previousResult = "0";
    public String input = "";
    public String output = "0";
    boolean calcDone = false;

    protected void calculateResult() {
        String[] components = this.input.split("(?<=[-+*/^()\\[\\]])|(?=[-+*/^()\\[\\]])");
        switch (components.length) {
            case 1: {
                return;
            }
            case 2: {
                if (components[0].equals("-") || components[0].equals("(")) {
                    return;
                }
            }
            case 3: {
                if (!components[0].equals("-") && !components[0].equals("(") || !components[1].equals("-") && !components[1].equals("(")) break;
                return;
            }
        }
        switch (components[components.length - 1]) {
            case "+": 
            case "-": 
            case "*": 
            case "/": 
            case "^": 
            case "(": {
                components[components.length - 1] = "";
                this.input = "";
                for (String component : components) {
                    this.input = this.input + component;
                }
                this.calculateResult();
                return;
            }
        }
        if (components[components.length - 1].length() != 1 && components[components.length - 1].charAt(components[components.length - 1].length() - 1) == '.') {
            components[components.length - 1] = components[components.length - 1].substring(0, components[components.length - 1].length() - 1);
        }
        int countOpenParen = 0;
        int countClosedParen = 0;
        this.input = "";
        String[] stringArray = components;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String component;
            switch (component = stringArray[i]) {
                case "(": {
                    ++countOpenParen;
                    break;
                }
                case ")": {
                    ++countClosedParen;
                    break;
                }
            }
            this.input = this.input + component;
        }
        if (countOpenParen - countClosedParen != 0) {
            for (int n2 = 0; n2 < countOpenParen - countClosedParen; ++n2) {
                this.input = this.input + ")";
            }
        }
        this.result = CalculatorProPlugin.eval(this.input.replaceAll(",", ""));
        if (this.result.toString().charAt(0) == 'I') {
            this.output = "Cant divide by 0";
            this.calcDone = true;
            return;
        }
        DecimalFormat df = new DecimalFormat("#,###.###");
        df.setRoundingMode(RoundingMode.HALF_UP);
        this.output = df.format(this.result);
        this.calcDone = true;
        this.previousResult = this.output;
    }

    protected void reset() {
        this.result = 0.0;
        this.input = "";
        this.update();
    }

    protected void clear() {
        this.reset();
    }

    protected void update() {
        if (this.calcDone) {
            super.setText(this.input + " = " + this.output);
            this.input = "";
            this.calcDone = false;
        } else {
            super.setText(this.input);
        }
        this.repaint();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisplayField)) {
            return false;
        }
        DisplayField other = (DisplayField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCalcDone() != other.isCalcDone()) {
            return false;
        }
        Double this$result = this.getResult();
        Double other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        String this$previousResult = this.getPreviousResult();
        String other$previousResult = other.getPreviousResult();
        if (this$previousResult == null ? other$previousResult != null : !this$previousResult.equals(other$previousResult)) {
            return false;
        }
        String this$input = this.getInput();
        String other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        String this$output = this.getOutput();
        String other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !this$output.equals(other$output));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DisplayField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCalcDone() ? 79 : 97);
        Double $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        String $previousResult = this.getPreviousResult();
        result = result * 59 + ($previousResult == null ? 43 : $previousResult.hashCode());
        String $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        String $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        return result;
    }

    public Double getResult() {
        return this.result;
    }

    public String getPreviousResult() {
        return this.previousResult;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean isCalcDone() {
        return this.calcDone;
    }

    public void setResult(Double result) {
        this.result = result;
    }

    public void setPreviousResult(String previousResult) {
        this.previousResult = previousResult;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setCalcDone(boolean calcDone) {
        this.calcDone = calcDone;
    }

    @Override
    public String toString() {
        return "DisplayField(result=" + this.getResult() + ", previousResult=" + this.getPreviousResult() + ", input=" + this.getInput() + ", output=" + this.getOutput() + ", calcDone=" + this.isCalcDone() + ")";
    }
}

