/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorpro.uiSpedwards;

import com.calculatorpro.uiSpedwards.CalculatorButton;
import com.calculatorpro.uiSpedwards.CalculatorPluginPanel;
import com.calculatorpro.uiSpedwards.DisplayField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class CalculatorPanel
extends JPanel {
    private static final Insets INSETS_LEFT_BORDER = new Insets(1, 0, 1, 1);
    private static final Insets INSETS_RIGHT_BORDER = new Insets(1, 1, 1, 0);
    private static final Insets INSETS = new Insets(1, 1, 1, 1);
    private final CalculatorPluginPanel panel;
    private final DisplayField displayField;
    private final GridBagConstraints c;

    protected CalculatorPanel(CalculatorPluginPanel panel) {
        this.panel = panel;
        this.displayField = panel.getDisplayField();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(0, 1, 0, 1));
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.addButton("+");
        this.addButton("7");
        this.addButton("8");
        this.addButton("9");
        this.addButton("-");
        this.addButton("4");
        this.addButton("5");
        this.addButton("6");
        this.addButton("*");
        this.addButton("1");
        this.addButton("2");
        this.addButton("3");
        this.addButton("/");
        this.addButton(".");
        this.addButton("0");
        this.addButton("=");
        this.addButton("(");
        this.addButton(")");
        this.addButton("^");
        this.addButton("<");
        this.addButton("C");
        this.c.gridwidth = 3;
        this.addButton("Clear History");
    }

    private void addButton(String key) {
        CalculatorButton btn = new CalculatorButton(key);
        btn.addActionListener(e -> {
            String text;
            switch (text = btn.getText()) {
                case "=": {
                    if (this.displayField.input.equals("")) {
                        return;
                    }
                    this.displayField.calculateResult();
                    if (!this.displayField.calcDone) break;
                    this.panel.getHistoryPanel().addHistoryItem(this.displayField.input + " =", this.displayField.output);
                    break;
                }
                case "C": {
                    this.displayField.clear();
                    return;
                }
                case "Clear History": {
                    this.panel.getHistoryPanel().clearHistory();
                    this.displayField.previousResult = "0";
                    return;
                }
                case "<": {
                    this.displayField.input = this.deleteLastCharacter(this.displayField.input);
                    break;
                }
                default: {
                    this.displayField.input = this.displayField.input + text;
                    if (this.inputValid(this.displayField.input.replaceAll(",", ""))) break;
                    this.displayField.input = this.deleteLastCharacter(this.displayField.input);
                    return;
                }
            }
            this.displayField.update();
        });
        this.addComp(btn);
    }

    private void addComp(Component component) {
        switch (this.c.gridx) {
            case 0: {
                this.c.insets = INSETS_LEFT_BORDER;
                break;
            }
            case 3: {
                this.c.insets = INSETS_RIGHT_BORDER;
                break;
            }
            default: {
                this.c.insets = INSETS;
            }
        }
        if (this.c.gridwidth == 3) {
            this.c.insets = INSETS_RIGHT_BORDER;
        }
        this.add(component, this.c);
        ++this.c.gridx;
        this.c.gridx %= 4;
        this.c.gridy = this.c.gridx == 0 ? (this.c.gridy = this.c.gridy + 1) : this.c.gridy;
    }

    private String deleteLastCharacter(String string) {
        if (string.equals("")) {
            return string;
        }
        return string.substring(0, string.length() - 1);
    }

    private boolean inputValid(String input) {
        String[] components = input.split("(?<=[-+*/^()\\[\\]])|(?=[-+*/^()\\[\\]])");
        int length = components.length;
        int countOpenParen = 0;
        int countClosedParen = 0;
        String[] stringArray = components;
        int n = stringArray.length;
        block57: for (int i = 0; i < n; ++i) {
            String component;
            switch (component = stringArray[i]) {
                case "(": {
                    ++countOpenParen;
                    continue block57;
                }
                case ")": {
                    if (++countClosedParen <= countOpenParen) continue block57;
                    return false;
                }
            }
        }
        block58: for (int n2 = 0; n2 < length; ++n2) {
            if (n2 == 0 && !this.displayField.previousResult.equals("0") && length == 1) {
                switch (components[n2]) {
                    case "+": 
                    case "-": 
                    case "*": 
                    case "/": 
                    case "^": {
                        String temp = components[n2];
                        components[n2] = this.displayField.previousResult.replaceAll(",", "") + temp;
                        return this.inputValid(components[n2].replaceAll(",", ""));
                    }
                }
            }
            if (n2 != 0 && components[n2 - 1].length() != 1 && components[n2 - 1].charAt(components[n2 - 1].length() - 1) == '.') {
                components[n2 - 1] = components[n2 - 1].substring(0, components[n2 - 1].length() - 1);
            }
            block26 : switch (components[n2]) {
                case "+": 
                case "*": 
                case "/": 
                case "^": 
                case ")": {
                    if (n2 != 0) {
                        switch (components[n2 - 1]) {
                            case "+": 
                            case "-": 
                            case "*": 
                            case "/": 
                            case "^": 
                            case "(": {
                                return false;
                            }
                        }
                        break;
                    }
                    return false;
                }
                case "(": {
                    if (n2 == 0) break;
                    switch (components[n2 - 1]) {
                        case "+": 
                        case "-": 
                        case "*": 
                        case "/": 
                        case "^": 
                        case "(": {
                            break block26;
                        }
                    }
                    components[n2] = "*(";
                }
            }
            if (!components[n2].matches(".*[.]+.*")) continue;
            String[] split = components[n2].split("\\.");
            switch (split.length) {
                case 0: {
                    components[n2] = "0.";
                    continue block58;
                }
                case 1: {
                    continue block58;
                }
                case 2: {
                    if (components[n2].charAt(components[n2].length() - 1) != '.') continue block58;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        DecimalFormat df = new DecimalFormat("#,###.###############");
        df.setRoundingMode(RoundingMode.HALF_UP);
        this.displayField.input = "";
        for (String component : components) {
            this.displayField.input = component.length() > 3 ? this.displayField.input + df.format(Double.parseDouble(component)) : this.displayField.input + component;
        }
        return true;
    }
}

