/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorpro;

import com.calculatorpro.CalculatorProConfig;
import com.calculatorpro.uiSpedwards.CalculatorPluginPanel;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Calculator Pro", description="Perform calculations using the side panel or in-game chat commands", tags={"calculator", "math", "chat", "command"})
public class CalculatorProPlugin
extends Plugin {
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;
    @Inject
    private CalculatorProConfig config;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private Client client;
    private static final String CALCULATE_STRING = "!calc";
    final HashMap<String, String> lvlTags = new HashMap();
    final HashMap<String, String> configTags = new HashMap();
    final HashMap<String, String> runTimeTags = new HashMap();
    boolean panelActive = false;
    boolean needAutoTag;
    int autoTag = 0;
    boolean isConfigTag = false;
    String newTagName;
    String output;
    String customEquation = "";

    public void startUp() {
        this.loadLvlTags();
        this.loadRunTimeTags();
        this.reloadTags();
        this.chatCommandManager.registerCommandAsync(CALCULATE_STRING, this::calculate);
        CalculatorPluginPanel panel = new CalculatorPluginPanel();
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        this.navButton = NavigationButton.builder().tooltip("Calculator Pro").priority(7).icon(icon).panel((PluginPanel)panel).build();
        if (this.config.panelActive()) {
            this.clientToolbar.addNavigation(this.navButton);
            this.panelActive = true;
        }
    }

    public void shutDown() {
        this.chatCommandManager.unregisterCommand(CALCULATE_STRING);
        if (this.panelActive) {
            this.clientToolbar.removeNavigation(this.navButton);
            this.panelActive = false;
        }
    }

    @Provides
    CalculatorProConfig provideConfig(ConfigManager configManager) {
        return (CalculatorProConfig)configManager.getConfig(CalculatorProConfig.class);
    }

    public void loadLvlTags() {
        Integer lvl = 1;
        while (lvl < 100) {
            this.lvlTags.put("lvl" + lvl, Integer.toString((int)CalculatorProPlugin.eval("(1/8)*(" + lvl + "^2-" + lvl + "+600*((2^(" + lvl + "/7)-2^(1/7)))/(2^(1/7)-1))-(" + lvl + "/10)")));
            Integer n = lvl;
            Integer n2 = lvl = Integer.valueOf(lvl + 1);
        }
    }

    private void loadRunTimeTags() {
        this.runTimeTags.put("last", "0");
        while (this.autoTag < 10) {
            this.runTimeTags.put("a" + this.autoTag, "0");
            ++this.autoTag;
        }
        this.autoTag = 0;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("calculatorpro")) {
            this.reloadTags();
            if (!this.config.panelActive() && this.panelActive) {
                this.clientToolbar.removeNavigation(this.navButton);
                this.panelActive = false;
            }
            if (this.config.panelActive() && !this.panelActive) {
                this.clientToolbar.addNavigation(this.navButton);
                this.panelActive = true;
            }
        }
    }

    private void reloadTags() {
        this.configTags.clear();
        this.customEquation = "";
        this.loadTags(this.config.customTags());
        this.loadEquation(this.config.customEquation());
    }

    private void loadTags(String textbox) {
        for (String line : textbox.split("\n")) {
            if (line.trim().equals("")) continue;
            if (line.trim().equals("###")) break;
            line = line.toLowerCase();
            String[] split = (line = line.replaceAll("\\s", "")).split("=");
            if (split.length != 2) {
                System.out.println("no value");
                continue;
            }
            this.isConfigTag = true;
            if (!this.checkTagName(split[0])) {
                this.isConfigTag = false;
                continue;
            }
            this.isConfigTag = false;
            String correctedEquation = this.checkEquation(split[1]);
            if (correctedEquation.charAt(0) == 'E') {
                System.out.println(correctedEquation);
                continue;
            }
            this.configTags.put(split[0], correctedEquation);
            if (this.runTimeTags.get(split[0]) == null) continue;
            this.runTimeTags.remove(split[0]);
        }
    }

    private void loadEquation(String textbox) {
        textbox = (String)textbox + "\n";
        String[] equation = ((String)textbox).split("\n", 2);
        this.customEquation = equation[0];
        if (this.customEquation.isEmpty()) {
            this.customEquation = "Error- Custom Equation box is empty";
            return;
        }
        this.customEquation = this.customEquation.toLowerCase();
        this.customEquation = this.customEquation.replaceAll("\\s", "");
        this.customEquation = this.customEquation.replaceAll(",", "");
    }

    private boolean checkTagName(String newTagString) {
        if (newTagString.isEmpty()) {
            this.output = "Error- no tag name";
            System.out.println(this.output);
            return false;
        }
        if (!newTagString.matches(".*[a-z]+.*")) {
            this.output = "Error- tag name (no letters): \"" + newTagString + "\"";
            System.out.println(this.output);
            return false;
        }
        int len = newTagString.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isLetterOrDigit(newTagString.charAt(i))) continue;
            this.output = "Error- tag name (contains symbols): \"" + newTagString + "\"";
            System.out.println(this.output);
            return false;
        }
        if (this.configTags.get(newTagString) != null || this.lvlTags.get(newTagString) != null) {
            this.output = "Error- tag \"" + newTagString + "\" already exists";
            System.out.println(this.output);
            return false;
        }
        if (!this.isConfigTag && this.runTimeTags.get(newTagString) != null) {
            this.output = "Error- tag \"" + newTagString + "\" already exists";
            System.out.println(this.output);
            return false;
        }
        switch (newTagString) {
            case "sqrt": 
            case "cos": 
            case "sin": 
            case "tan": {
                this.output = "Error- tag \"" + newTagString + "\" is reserved for math operations";
                System.out.println(this.output);
                return false;
            }
            case "last": 
            case "a0": 
            case "a1": 
            case "a2": 
            case "a3": 
            case "a4": 
            case "a5": 
            case "a6": 
            case "a7": 
            case "a8": 
            case "a9": {
                this.output = "Error- tag \"" + newTagString + "\" is reserved for default tags";
                System.out.println(this.output);
                return false;
            }
        }
        return true;
    }

    private void calculate(ChatMessage chatMessage, String equation) {
        String correctedEquation;
        if (!this.config.calcCommand()) {
            return;
        }
        this.output = "";
        this.newTagName = "";
        this.needAutoTag = false;
        Double answer = 0.0;
        equation = equation.toLowerCase();
        equation = equation.replaceAll("\\s", "");
        String[] split = equation.split(CALCULATE_STRING);
        switch (split.length) {
            case 0: {
                if (this.customEquation.charAt(0) == 'E') {
                    this.build(equation, this.customEquation, answer.toString(), chatMessage);
                    return;
                }
                equation = this.customEquation;
                break;
            }
            case 2: {
                equation = split[1];
                break;
            }
            default: {
                this.build(equation, "Error- invalid entry", answer.toString(), chatMessage);
                return;
            }
        }
        if (equation.charAt(0) == '!' || equation.charAt(0) == '[') {
            equation = this.checkHeaders(equation);
            if (this.output.charAt(0) == 'E' || this.output.equals("Command Complete")) {
                this.build(equation, this.output, answer.toString(), chatMessage);
                return;
            }
        } else {
            this.needAutoTag = true;
        }
        if ((correctedEquation = this.checkEquation(equation)).charAt(0) == 'E') {
            this.build(equation, correctedEquation, answer.toString(), chatMessage);
            return;
        }
        answer = CalculatorProPlugin.eval(correctedEquation.replaceAll(",", ""));
        if (answer.toString().charAt(0) == 'I') {
            this.build(equation, correctedEquation, answer.toString(), chatMessage);
            return;
        }
        Object format = "#,###";
        if (this.config.numDecimals() > 0) {
            int n;
            format = (String)format + ".";
            if (this.config.numDecimals() > 15) {
                for (n = 0; n < 15; ++n) {
                    format = (String)format + "#";
                }
            } else {
                for (n = 0; n < this.config.numDecimals(); ++n) {
                    format = (String)format + "#";
                }
            }
        }
        DecimalFormat df = new DecimalFormat((String)format);
        df.setRoundingMode(RoundingMode.HALF_UP);
        this.addNewTag(df.format(answer));
        this.build(equation, correctedEquation, "[" + this.newTagName + "] " + df.format(answer), chatMessage);
    }

    public String checkHeaders(String input) {
        switch (input.charAt(0)) {
            case '[': {
                String[] split = input.split("\\[");
                split = split[1].split("]");
                if (split.length < 2) {
                    this.output = "Error- missing ']' or missing equation after ']'";
                    return input;
                }
                split[0] = split[0].replaceAll("\\s", "");
                if (!this.checkTagName(split[0])) {
                    return input;
                }
                this.newTagName = split[0];
                this.output = split[1];
                break;
            }
            case '!': {
                if (input.equals("!clear")) {
                    String temp = "0";
                    if (this.runTimeTags.get("last") != null) {
                        temp = this.runTimeTags.get("last");
                    }
                    this.runTimeTags.clear();
                    this.loadRunTimeTags();
                    this.runTimeTags.replace("last", temp);
                    this.autoTag = 0;
                    this.output = "Command Complete";
                    return input;
                }
                if (input.charAt(1) == 'r') {
                    String[] split = input.split("!remove");
                    if (split.length != 2) {
                        this.output = "Error- invalid command. Usage: !remove tagName";
                        return input;
                    }
                    if (this.runTimeTags.get(split[1]) == null) {
                        this.output = "Error- tagName not found. Usage: !remove tagName";
                        return input;
                    }
                    this.runTimeTags.remove(split[1]);
                    this.output = "Command Complete";
                    return "!remove " + split[1];
                }
                this.output = "Error- unknown command";
                return input;
            }
            default: {
                this.output = "Error- headers";
                return input;
            }
        }
        return this.output;
    }

    public String checkEquation(String input) {
        Pattern p = Pattern.compile("(.{1})");
        Matcher m = p.matcher("(),.+-/*^");
        String temp = input.replaceAll(m.replaceAll("\\\\$1\\|"), "");
        int len = temp.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isLetterOrDigit(temp.charAt(i))) continue;
            this.output = "Error- unsupported symbols";
            return this.output;
        }
        String[] components = input.split("(?<=[-+*/^()\\[\\]])|(?=[-+*/^()\\[\\]])");
        int length = components.length;
        int countOpenParen = 0;
        int countClosedParen = 0;
        String[] stringArray = components;
        int n = stringArray.length;
        block72: for (int i = 0; i < n; ++i) {
            String component;
            switch (component = stringArray[i]) {
                case "(": {
                    ++countOpenParen;
                    continue block72;
                }
                case ")": {
                    if (++countClosedParen <= countOpenParen) continue block72;
                    this.output = "Error- found ) before (";
                    return this.output;
                }
            }
        }
        block73: for (int n2 = 0; n2 < length; ++n2) {
            String[] split;
            switch (components[n2]) {
                case "+": 
                case "-": 
                case "*": 
                case "/": 
                case "^": 
                case "(": {
                    if (n2 + 1 != length) {
                        switch (components[n2 + 1]) {
                            case "+": 
                            case "*": 
                            case "/": 
                            case "^": 
                            case ")": {
                                this.output = "Error- 2 math operators together";
                                return this.output;
                            }
                        }
                        break;
                    }
                    this.output = "Error- cant end equation in math operator";
                    return this.output;
                }
            }
            if (components[n2].equals("(") && n2 != 0) {
                switch (components[n2 - 1]) {
                    case "+": 
                    case "-": 
                    case "*": 
                    case "/": 
                    case "^": 
                    case "(": 
                    case "sqrt": 
                    case "cos": 
                    case "sin": 
                    case "tan": {
                        break;
                    }
                    default: {
                        components[n2] = "*(";
                        break;
                    }
                }
            } else if (components[n2].equals(")") && n2 + 1 != length) {
                switch (components[n2 + 1]) {
                    case "+": 
                    case "-": 
                    case "*": 
                    case "/": {
                        break;
                    }
                    default: {
                        components[n2] = ")*";
                    }
                }
            }
            switch (components[n2]) {
                case "sqrt": 
                case "cos": 
                case "sin": 
                case "tan": {
                    if (n2 + 1 == length) {
                        this.output = "Error- math tag not followed by (###)";
                        return this.output;
                    }
                    if (components[n2 + 1].equals("(")) break;
                    this.output = "Error- math tag not followed by (###)";
                    return this.output;
                }
            }
            if (components[n2].matches(".*[.]+.*") && (split = components[n2].split("\\.")).length != 2) {
                this.output = "Error- incorrect decimal usage";
                return this.output;
            }
            if (!components[n2].matches(".*[a-zA-Z]+.*")) continue;
            switch (components[n2]) {
                case "sqrt": 
                case "cos": 
                case "sin": 
                case "tan": {
                    continue block73;
                }
                default: {
                    if (this.configTags.get(components[n2]) != null) {
                        components[n2] = this.configTags.get(components[n2]);
                        continue block73;
                    }
                    if (this.lvlTags.get(components[n2]) != null) {
                        components[n2] = this.lvlTags.get(components[n2]);
                        continue block73;
                    }
                    if (this.runTimeTags.get(components[n2]) != null) {
                        components[n2] = this.runTimeTags.get(components[n2]);
                        continue block73;
                    }
                    this.output = "Error- no \"" + components[n2] + "\" tag found";
                    System.out.println(this.output);
                    return this.output;
                }
            }
        }
        this.output = "";
        for (String component : components) {
            this.output = this.output + component;
        }
        for (int n3 = 0; n3 < countOpenParen - countClosedParen; ++n3) {
            this.output = this.output + ")";
        }
        return this.output;
    }

    public static double eval(final String str) {
        return new Object(){
            int pos = -1;
            int ch;

            void nextChar() {
                this.ch = ++this.pos < str.length() ? (int)str.charAt(this.pos) : -1;
            }

            boolean eat(int charToEat) {
                while (this.ch == 32) {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < str.length()) {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                return x;
            }

            double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat(43)) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat(45)) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat(42)) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (!this.eat(47)) break;
                    x /= this.parseFactor();
                }
                return x;
            }

            double parseFactor() {
                double x;
                if (this.eat(43)) {
                    return this.parseFactor();
                }
                if (this.eat(45)) {
                    return -this.parseFactor();
                }
                int startPos = this.pos;
                if (this.eat(40)) {
                    x = this.parseExpression();
                    if (!this.eat(41)) {
                        throw new RuntimeException("Missing ')'");
                    }
                } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                    while (this.ch >= 48 && this.ch <= 57 || this.ch == 46) {
                        this.nextChar();
                    }
                    x = Double.parseDouble(str.substring(startPos, this.pos));
                } else if (this.ch >= 97 && this.ch <= 122) {
                    while (this.ch >= 97 && this.ch <= 122) {
                        this.nextChar();
                    }
                    String func = str.substring(startPos, this.pos);
                    if (this.eat(40)) {
                        x = this.parseExpression();
                        if (!this.eat(41)) {
                            throw new RuntimeException("Missing ')' after argument to " + func);
                        }
                    } else {
                        x = this.parseFactor();
                    }
                    switch (func) {
                        case "sqrt": {
                            x = Math.sqrt(x);
                            break;
                        }
                        case "sin": {
                            x = Math.sin(Math.toRadians(x));
                            break;
                        }
                        case "cos": {
                            x = Math.cos(Math.toRadians(x));
                            break;
                        }
                        case "tan": {
                            x = Math.tan(Math.toRadians(x));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown function: " + func);
                        }
                    }
                } else {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                if (this.eat(94)) {
                    x = Math.pow(x, this.parseFactor());
                }
                return x;
            }
        }.parse();
    }

    public void addNewTag(String value) {
        if (this.needAutoTag) {
            if (this.autoTag == 10) {
                this.autoTag = 0;
            }
            this.newTagName = "a" + this.autoTag++;
            if (this.runTimeTags.get(this.newTagName) != null) {
                this.runTimeTags.remove(this.newTagName);
            }
            this.runTimeTags.put(this.newTagName, value);
        } else {
            this.runTimeTags.put(this.newTagName, value);
        }
        if (this.runTimeTags.get("last") != null) {
            this.runTimeTags.remove("last");
        }
        this.runTimeTags.put("last", value);
    }

    public void build(String equ, String corEqu, String ans, ChatMessage chatMessage) {
        String response;
        if (corEqu.charAt(0) == 'E' || corEqu.charAt(0) == 'C') {
            System.out.println(equ + " " + corEqu);
            response = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(equ).append(ChatColorType.HIGHLIGHT).append(" " + corEqu).build();
        } else if (ans.charAt(0) == 'I') {
            System.out.println(equ + " Error- cannot divide by 0");
            response = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(equ).append(ChatColorType.HIGHLIGHT).append(" Error- cannot divide by 0").build();
        } else {
            response = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(equ).append(ChatColorType.HIGHLIGHT).append(" equals ").append(ChatColorType.NORMAL).append(ans).build();
        }
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.client.refreshChat();
    }
}

