/*
 * Decompiled with CFR 0.152.
 */
package com.calculatorpro;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="calculatorpro")
public interface CalculatorProConfig
extends Config {
    @ConfigSection(name="Chatbox Instructions", description="How to use the calculator in the chatbox", position=4, closedByDefault=false)
    public static final String instructionSection = "instructions";
    @ConfigSection(name="Custom Tags", description="Text-based custom tags", position=6)
    public static final String customTagsSection = "Custom Tags";
    @ConfigSection(name="Custom Equation", description="Text-based custom equation", position=8)
    public static final String customEquationSection = "Custom Equation";

    @ConfigItem(position=1, keyName="panel", name="Panel Active", description="Configures whether to turn the Calculator panel on or off")
    default public boolean panelActive() {
        return true;
    }

    @ConfigItem(position=2, keyName="calculate", name="Calculator Command", description="Configures whether the Calculator command is enabled  !calc 3*4")
    default public boolean calcCommand() {
        return true;
    }

    @ConfigItem(position=3, keyName="numDecimals", name="Decimals to Display", description="Configures how many decimal places to display on the Calculator chat result (max 15)")
    default public int numDecimals() {
        return 3;
    }

    @ConfigItem(position=5, keyName="instructions", name="Instructions", description="How to use the calculator in the chatbox", section="instructions")
    default public String instructions() {
        return "Call the calculator through the chatbox using:\n!calc 2+3\n\nYou can create a tag for the result: \n!calc [tagName] 2+3\n\nIf a [tagName] is not provided for the result, an auto-generated name will be supplied\n\nYou can reference tags in your equation:\n!calc 5*tagName+3\n\nYou can clear all tags created through the chatbox, or only remove a certain tag:\n!calc !clear\n!calc !remove tagName\n\nThere are some built-in tags:\nlvl1  --experience at lvl 1, up to\nlvl99\nlast  --result of last calculation\n\nMath functions such as ^2, sqrt, sin, cos, tan are also supported:\n!calc sqrt(9^3)\n\nHandles complex calculations:\n!calc 5*((tagName+2)-cos(2+6)/3)";
    }

    @ConfigItem(keyName="customTags", name="Custom Tags", description="Tags to use in the calculator", section="Custom Tags", position=7)
    default public String customTags() {
        return "tag1=123\noak=37.5\nexample=oak+tag1\n\n###\nInsert tags above this line, notes below this line\n\nTags should look like this:\ntagName=###\n\nWhere \"tagName\" is at least 1 letter, and can contain letters and numbers, but no symbols\n\nAnd \"###\" is a real number or equation (negative numbers, fractions and decimals are ok)\n\nYou can then reference these tags in your equation\n!calc 4*tagName";
    }

    @ConfigItem(keyName="customEquation", name="Custom Equation", description="Equation to execute by calling \"!calc\" with nothing after it", section="Custom Equation", position=9)
    default public String customEquation() {
        return "[tag] (lvl99-lvl60)/oak\n\n###\nWrite the equation you want to execute on the top line of this textbox. Long equations that wrap onto a new line are ok\n\nExecute this equation in-game by calling: \n!calc \nin-game with nothing after it";
    }
}

