/*
 * Decompiled with CFR 0.152.
 */
package com.objecthider;

import com.google.inject.Provides;
import com.objecthider.ObjectHiderConfig;
import com.objecthider.ObjectHiderOverlay;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GroundObject;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Ground Object Hider", description="Hides Ground Objects. A selector is used to choose objects to hide.", tags={"external", "objects", "memory", "usage", "ground", "decorations", "performance"})
public class ObjectHiderPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ObjectHiderConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ObjectHiderOverlay overlay;
    @Inject
    private KeyManager keyManager;
    @Inject
    private MouseManager mouseManager;
    public boolean selectGroundObjectMode = false;
    private HashMap<WorldPoint, GroundObject> hiddenObjects = new HashMap();
    private final HotkeyListener groundObjectsKeyListener = new HotkeyListener(() -> this.config.hideGroundObjectKey()){

        public void keyPressed(KeyEvent e) {
            if (ObjectHiderPlugin.this.config.hideGroundObjectKey().matches(e)) {
                ObjectHiderPlugin.this.selectGroundObjectMode = true;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (ObjectHiderPlugin.this.config.hideGroundObjectKey().matches(e)) {
                ObjectHiderPlugin.this.selectGroundObjectMode = false;
            }
        }
    };
    private final MouseListener mouseListener = new MouseListener(){

        public MouseEvent mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (!ObjectHiderPlugin.this.selectGroundObjectMode) {
                    return mouseEvent;
                }
                Tile tile = ObjectHiderPlugin.this.client.getSelectedSceneTile();
                if (tile == null) {
                    return mouseEvent;
                }
                mouseEvent.consume();
                ArrayList<Integer> curGroundHide = new ArrayList<Integer>(ObjectHiderPlugin.this.getGroundObjects());
                GroundObject obj = tile.getGroundObject();
                if (obj != null) {
                    if (!curGroundHide.contains(obj.getId())) {
                        curGroundHide.add(obj.getId());
                    }
                    ObjectHiderPlugin.this.config.setGroundObjectsToHide(Text.toCSV((Collection)curGroundHide.stream().map(String::valueOf).collect(Collectors.toList())));
                }
            }
            return mouseEvent;
        }

        public MouseEvent mousePressed(MouseEvent mouseEvent) {
            if (ObjectHiderPlugin.this.selectGroundObjectMode && SwingUtilities.isRightMouseButton(mouseEvent)) {
                mouseEvent.consume();
            }
            return mouseEvent;
        }

        public MouseEvent mouseReleased(MouseEvent mouseEvent) {
            return mouseEvent;
        }

        public MouseEvent mouseEntered(MouseEvent mouseEvent) {
            return mouseEvent;
        }

        public MouseEvent mouseExited(MouseEvent mouseEvent) {
            return mouseEvent;
        }

        public MouseEvent mouseDragged(MouseEvent mouseEvent) {
            return mouseEvent;
        }

        public MouseEvent mouseMoved(MouseEvent mouseEvent) {
            return mouseEvent;
        }
    };

    @Provides
    ObjectHiderConfig provideConfig(ConfigManager configManager) {
        return (ObjectHiderConfig)configManager.getConfig(ObjectHiderConfig.class);
    }

    protected void startUp() {
        this.clientThread.invoke(this::rebuildObjects);
        this.keyManager.registerKeyListener((KeyListener)this.groundObjectsKeyListener);
        this.mouseManager.registerMouseListener(this.mouseListener);
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this.groundObjectsKeyListener);
        this.mouseManager.unregisterMouseListener(this.mouseListener);
        this.overlayManager.remove((Overlay)this.overlay);
        this.unhideAllGroundObjects();
        this.hiddenObjects = new HashMap();
    }

    private void unhideAllGroundObjects() {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        if (tiles != null) {
            for (int plane = 0; plane < tiles.length; ++plane) {
                for (int x = 0; x < tiles[plane].length; ++x) {
                    for (int y = 0; y < tiles[plane][x].length; ++y) {
                        WorldPoint location;
                        if (tiles[plane][x][y] == null || !this.hiddenObjects.containsKey(location = tiles[plane][x][y].getWorldLocation())) continue;
                        tiles[plane][x][y].setGroundObject(this.hiddenObjects.get(location));
                        this.hiddenObjects.remove(location);
                    }
                }
            }
        }
    }

    private boolean hideGroundObjectOnTile(Tile tile, GroundObject obj) {
        if (tile == null || obj == null) {
            return false;
        }
        for (int i : this.client.getMapRegions()) {
            if (i != 13123 && i != 13379) continue;
            return false;
        }
        ObjectComposition oc = this.client.getObjectDefinition(obj.getId());
        if (oc != null && Arrays.stream(oc.getActions()).anyMatch(a -> a != null && !a.equals("Examine"))) {
            return false;
        }
        this.hiddenObjects.put(tile.getWorldLocation(), obj);
        tile.setGroundObject(null);
        return true;
    }

    private void rebuildObjects() {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        if (tiles != null) {
            for (int plane = 0; plane < tiles.length; ++plane) {
                for (int x = 0; x < tiles[plane].length; ++x) {
                    for (int y = 0; y < tiles[plane][x].length; ++y) {
                        Tile currentTile = tiles[plane][x][y];
                        if (currentTile == null) continue;
                        GroundObject groundObj = currentTile.getGroundObject();
                        if (groundObj == null) {
                            if (!this.hiddenObjects.containsKey(currentTile.getWorldLocation())) continue;
                            GroundObject oHidden = this.hiddenObjects.get(currentTile.getWorldLocation());
                            if (this.getGroundObjects().contains(oHidden.getId())) continue;
                            currentTile.setGroundObject(oHidden);
                            this.hiddenObjects.remove(currentTile.getWorldLocation());
                            continue;
                        }
                        if (this.config.getHideAll()) {
                            this.hideGroundObjectOnTile(currentTile, currentTile.getGroundObject());
                            continue;
                        }
                        for (Integer hideObjID : this.getGroundObjects()) {
                            if (groundObj.getId() != hideObjID.intValue()) continue;
                            this.hideGroundObjectOnTile(currentTile, groundObj);
                        }
                    }
                }
            }
        }
    }

    List<Integer> getGroundObjects() {
        try {
            return ObjectHiderPlugin.intsFromCSVString(this.config.getGroundObjectsToHide());
        }
        catch (NumberFormatException ex) {
            return Collections.emptyList();
        }
    }

    private static List<Integer> intsFromCSVString(String val) throws NumberFormatException {
        if (val.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)val).stream().map(Integer::parseInt).collect(Collectors.toList());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        GroundObject obj = event.getGroundObject();
        if (obj == null || event.getTile() == null) {
            return;
        }
        if (this.config.getHideAll() || this.getGroundObjects().contains(obj.getId())) {
            this.hideGroundObjectOnTile(event.getTile(), obj);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getTickCount() % 100 == 0) {
            ArrayList<WorldPoint> toRemove = new ArrayList<WorldPoint>();
            for (WorldPoint wp : this.hiddenObjects.keySet()) {
                if (wp.isInScene(this.client)) continue;
                toRemove.add(wp);
            }
            for (WorldPoint wp : toRemove) {
                this.hiddenObjects.remove(wp);
            }
        }
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        Tile t = event.getTile();
        if (t == null) {
            return;
        }
        WorldPoint loc = t.getWorldLocation();
        if (loc != null) {
            this.hiddenObjects.remove(loc);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("objecthider")) {
            return;
        }
        this.clientThread.invoke(this::rebuildObjects);
    }
}

