/*
 * Decompiled with CFR 0.152.
 */
package com.objecthider;

import com.objecthider.ObjectHiderConfig;
import com.objecthider.ObjectHiderPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class ObjectHiderOverlay
extends Overlay {
    private final Client client;
    private final ObjectHiderPlugin plugin;

    @Inject
    private ObjectHiderOverlay(Client client, ObjectHiderPlugin plugin, ObjectHiderConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.MED);
    }

    public Dimension render(Graphics2D graphics) {
        Polygon poly;
        if (this.plugin.selectGroundObjectMode && this.client.getSelectedSceneTile() != null && (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)this.client.getSelectedSceneTile().getLocalLocation())) != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)Color.MAGENTA);
        }
        return null;
    }
}

