/*
 * Decompiled with CFR 0.152.
 */
package com.thenorsepantheon.groupironman;

import com.google.common.base.Splitter;
import com.google.inject.Provides;
import com.thenorsepantheon.groupironman.GroupIronManConfig;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexedSprite;
import net.runelite.api.MenuEntry;
import net.runelite.api.Quest;
import net.runelite.api.QuestState;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Group Iron Man", description="Adds the capability to play Group Ironman")
public class GroupIronManPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GroupIronManPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private GroupIronManConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    private static final List<String> groupMembers = new ArrayList<String>();
    private static final Map<Boolean, Integer> iconMap = new HashMap<Boolean, Integer>();

    protected void startUp() throws Exception {
        log.info("Group Ironman started!");
        this.populateGroupMembers();
        if (this.client.getModIcons() == null) {
            iconMap.clear();
            return;
        }
        this.loadSprites();
    }

    protected void shutDown() throws Exception {
        iconMap.clear();
        this.clientThread.invoke(() -> this.client.runScript(new Object[]{223}));
        log.info("Group Ironman stopped!");
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.loadSprites();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String target = Text.removeTags((String)event.getMenuTarget());
        if ((this.entryMatches(event, "Trade with") || this.entryMatches(event, "Accept trade")) && !this.isGroupMember(event.getMenuTarget())) {
            event.consume();
            this.sendChatMessage("You are a Group Iron Man. You stand alone...together.");
            return;
        }
        if (this.entryMatches(event, "Challenge") && !this.isGroupMember(event.getMenuTarget())) {
            event.consume();
            this.sendChatMessage("As a Group Iron Man, you cannot duel players outside your group.");
            return;
        }
        if (this.entryMatches(event, "Exchange", "Grand Exchange Clerk") || this.entryMatches(event, "Exchange", "Grand Exchange booth") || this.entryMatches(event, "Collect", "Banker") || this.entryMatches(event, "Collect", "Grand Exchange booth")) {
            event.consume();
            this.sendChatMessage("As a Group Iron Man, you cannot use the Grand Exchange.");
            return;
        }
        if (this.entryMatches(event, "Burst", "Party Balloon")) {
            event.consume();
            this.sendChatMessage("As a Group Iron Man, you cannot receive items from the Falador Party Room");
            return;
        }
        if (this.isNMZStoreOpen() && event.getMenuOption().startsWith("Buy-") && !target.equals("Scroll of redirection") && !target.endsWith("(1)")) {
            event.consume();
            this.sendChatMessage("As a Group Iron Man, you cannot purchase this item.");
            return;
        }
        if (this.config.ultimate()) {
            if (this.entryMatches(event, "Bank") || this.entryMatches(event, "Use", "Bank chest") || this.entryMatches(event, "Deposit", "Bank deposit box")) {
                event.consume();
                this.sendChatMessage("As an Ultimate Group Iron Man, you cannot use the bank.");
            }
            if (this.entryMatches(event, "Sets", "Grand Exchange Clerk")) {
                event.consume();
                this.sendChatMessage("As an Ultimate Group Iron Man, you cannot create item sets.");
            }
            if (this.entryMatches(event, "Sand", "Bert")) {
                event.consume();
                this.sendChatMessage("As an Ultimate Group Iron Man, you cannot receive sand from Bert.");
            }
            if (this.entryMatches(event, "Collect", "Advisor Ghrim")) {
                event.consume();
                this.sendChatMessage("As an Ultimate Group Iron Man, you cannot receive resources from Managing Miscellania.");
            }
        }
    }

    @Subscribe
    private void onMenuOpened(MenuOpened event) {
        MenuEntry[] menuEntries = event.getMenuEntries();
        ArrayList<MenuEntry> newEntries = new ArrayList<MenuEntry>(menuEntries.length);
        for (MenuEntry entry : event.getMenuEntries()) {
            String option = entry.getOption();
            String target = Text.removeTags((String)entry.getTarget());
            if (option.equals("Talk-to") && (target.equals("Grand Exchange Clerk") || target.equals("Banker")) || this.entryMatches(entry, "Open", "Seed vault") || this.config.ultimate() && (this.entryMatches(entry, "Talk-to", "Bert") && Quest.THE_HAND_IN_THE_SAND.getState(this.client) == QuestState.FINISHED || this.entryMatches(entry, "Talk-to", "Advisor Ghrim") && Quest.THRONE_OF_MISCELLANIA.getState(this.client) == QuestState.FINISHED)) continue;
            if (this.isGroupMember(entry.getTarget())) {
                entry.setTarget(this.getImgTag() + entry.getTarget());
            }
            newEntries.add(entry);
        }
        this.client.setMenuEntries(newEntries.toArray(new MenuEntry[0]));
    }

    @Subscribe
    private void onBeforeRender(BeforeRender event) {
        this.updateChatbox();
    }

    @Subscribe
    private void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!event.getEventName().equals("setChatboxInput")) {
            return;
        }
        this.updateChatbox();
    }

    @Subscribe
    private void onChatMessage(ChatMessage event) {
        if (event.getName() == null || this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return;
        }
        boolean isLocalPlayer = Text.standardize((String)event.getName()).equalsIgnoreCase(Text.standardize((String)this.client.getLocalPlayer().getName()));
        if (isLocalPlayer || this.isGroupMember(event.getName().toLowerCase())) {
            event.getMessageNode().setName(this.getImgTag() + Text.removeTags((String)event.getName()));
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("groupironman")) {
            if (event.getKey().equals("groupMembers")) {
                this.populateGroupMembers();
            } else if (event.getKey().equals("iconHueOffset")) {
                this.loadSprites();
            }
        }
    }

    private boolean isNMZStoreOpen() {
        Widget w = this.client.getWidget(206, 1);
        if (w == null || w.isHidden()) {
            return false;
        }
        Widget child = w.getChild(1);
        if (child == null || child.isHidden()) {
            return false;
        }
        return child.getText().equals("Dom Onion's Reward Shop");
    }

    private String cleanName(String playerName) {
        int index = playerName.indexOf(40);
        if (index == -1) {
            return this.standardizeToJagexName(playerName);
        }
        return this.standardizeToJagexName(playerName.substring(0, index));
    }

    private String standardizeToJagexName(String name) {
        return Text.standardize((String)Text.toJagexName((String)name));
    }

    private boolean isGroupMember(String name) {
        return groupMembers.contains(this.cleanName(name));
    }

    private void populateGroupMembers() {
        Splitter NEWLINE_SPLITTER = Splitter.on((String)"\n").omitEmptyStrings().trimResults();
        groupMembers.clear();
        groupMembers.addAll(NEWLINE_SPLITTER.splitToList((CharSequence)this.config.groupMembers()).stream().map(this::standardizeToJagexName).collect(Collectors.toList()));
    }

    private boolean entryMatches(MenuEntry entry, String option) {
        return entry.getOption().equals(option);
    }

    private boolean entryMatches(MenuOptionClicked event, String option) {
        return event.getMenuOption().equals(option);
    }

    private boolean entryMatches(MenuEntry entry, String option, String target) {
        return this.entryMatches(entry, option) && Text.removeTags((String)entry.getTarget()).equals(target);
    }

    private boolean entryMatches(MenuOptionClicked event, String option, String target) {
        return this.entryMatches(event, option) && Text.removeTags((String)event.getMenuTarget()).equals(target);
    }

    private void sendChatMessage(String message) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    private void loadSprites() {
        iconMap.clear();
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(GroupIronManPlugin.class, (String)"icon.png");
        float hueOffset = (float)this.config.iconHueOffset() / 100.0f;
        IndexedSprite GROUP_IRON_MAN_ICON = ImageUtil.getImageIndexedSprite((BufferedImage)this.adjustHue(icon, hueOffset), (Client)this.client);
        IndexedSprite ULTIMATE_GROUP_IRON_MAN_ICON = ImageUtil.getImageIndexedSprite((BufferedImage)this.adjustHue(icon, hueOffset + 0.11f), (Client)this.client);
        IndexedSprite[] modIcons = this.client.getModIcons();
        IndexedSprite[] newArray = Arrays.copyOf(modIcons, modIcons.length + 2);
        int modIconsStart = modIcons.length - 1;
        newArray[++modIconsStart] = GROUP_IRON_MAN_ICON;
        iconMap.put(false, modIconsStart);
        newArray[++modIconsStart] = ULTIMATE_GROUP_IRON_MAN_ICON;
        iconMap.put(true, modIconsStart);
        this.client.setModIcons(newArray);
    }

    private void updateChatbox() {
        Widget chatboxTypedText = this.client.getWidget(WidgetInfo.CHATBOX_MESSAGE_LINES);
        if (this.getIconId() == -1) {
            return;
        }
        if (chatboxTypedText == null || chatboxTypedText.isHidden()) {
            return;
        }
        String[] chatbox = chatboxTypedText.getText().split(":", 2);
        String rsn = Objects.requireNonNull(this.client.getLocalPlayer()).getName();
        chatboxTypedText.setText(this.getImgTag() + Text.removeTags((String)rsn) + ":" + chatbox[1]);
    }

    private BufferedImage adjustHue(BufferedImage image, float hue) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int x = 0; x < newImage.getWidth(); ++x) {
            for (int y = 0; y < newImage.getHeight(); ++y) {
                Color pixelColour = new Color(image.getRGB(x, y), true);
                if (pixelColour.getAlpha() == 0) {
                    newImage.setRGB(x, y, pixelColour.getRGB());
                    continue;
                }
                float[] hsbVals = new float[3];
                Color.RGBtoHSB(pixelColour.getRed(), pixelColour.getBlue(), pixelColour.getGreen(), hsbVals);
                Color newColour = new Color(Color.HSBtoRGB((hue + hsbVals[0]) % 1.0f, hsbVals[1], hsbVals[2]));
                newImage.setRGB(x, y, newColour.getRGB());
            }
        }
        return newImage;
    }

    private String getImgTag() {
        return "<img=" + this.getIconId() + "> ";
    }

    private int getIconId() {
        return iconMap.getOrDefault(this.config.ultimate(), -1);
    }

    @Provides
    GroupIronManConfig provideConfig(ConfigManager configManager) {
        return (GroupIronManConfig)configManager.getConfig(GroupIronManConfig.class);
    }
}

