/*
 * Decompiled with CFR 0.152.
 */
package com.hablapatabla.implingfinder.ui;

import com.hablapatabla.implingfinder.ImplingFinderPlugin;
import com.hablapatabla.implingfinder.model.ImplingFinderData;
import com.hablapatabla.implingfinder.model.ImplingFinderEnum;
import com.hablapatabla.implingfinder.ui.ImplingFinderButton;
import com.hablapatabla.implingfinder.ui.ImplingFinderImpPanel;
import com.hablapatabla.implingfinder.ui.ImplingFinderSplashPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplingFinderPanel
extends PluginPanel {
    private static final String RESULTS_PANEL = "RESULTS_PANEL";
    private static final String ERROR_PANEL = "ERROR_PANEL";
    private static final String SPLASH_PANEL = "SPLASH_PANEL";
    private static String[] TargetableImplings = new String[]{"Recent", "Magpie", "Ninja", "Crystal", "Dragon", "Lucky"};
    private GridBagConstraints c = new GridBagConstraints();
    private final CardLayout cardLayout = new CardLayout();
    private JPanel impListPanel = new JPanel();
    private JPanel implingListContainer = new JPanel(this.cardLayout);
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private final ImplingFinderSplashPanel splashPanel = new ImplingFinderSplashPanel();
    private Logger logger = LoggerFactory.getLogger(ImplingFinderPanel.class);
    protected ImplingFinderPlugin plugin;
    private boolean clearRequested = false;
    private boolean fetchRequested = false;
    private boolean fetchTargetedRequested = false;
    protected List<ImplingFinderButton> buttonList = new ArrayList<ImplingFinderButton>();
    private boolean splashRequested = false;
    private ItemManager itemManager;
    @Inject
    private Client client;

    @Inject
    protected ImplingFinderPanel(ImplingFinderPlugin plugin, ItemManager itemManager) {
        this.plugin = plugin;
        this.itemManager = itemManager;
        this.implingFinderPanelHelper(plugin);
    }

    private void implingFinderPanelHelper(ImplingFinderPlugin plugin) {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.gridx = 0;
        this.c.anchor = 19;
        JPanel topContainer = new JPanel();
        topContainer.setLayout(new BorderLayout());
        topContainer.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARKER_GRAY_HOVER_COLOR));
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        titlePanel.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        title.setText("Impling Finder");
        title.setForeground(Color.WHITE);
        titlePanel.add((Component)title, "East");
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImplingFinderPanel.this.clearRequested = true;
            }
        });
        clearButton.setForeground(Color.WHITE);
        clearButton.setRequestFocusEnabled(false);
        titlePanel.add((Component)clearButton, "West");
        topContainer.add((Component)titlePanel, "North");
        JPanel fetchPanel = new JPanel();
        fetchPanel.setLayout(new BorderLayout());
        fetchPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        JPanel implingSelections = new JPanel(new GridLayout(2, 3));
        implingSelections.setBorder(new EmptyBorder(0, -1, 3, -1));
        this.populateButtonList();
        for (JButton jButton : this.buttonList) {
            implingSelections.add(jButton);
        }
        fetchPanel.add((Component)implingSelections, "North");
        JButton fetchButton = new JButton("Fetch");
        fetchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImplingFinderPanel.this.fetchRequested = true;
            }
        });
        fetchButton.setForeground(Color.WHITE);
        fetchButton.setRequestFocusEnabled(false);
        fetchPanel.add((Component)fetchButton, "South");
        topContainer.add((Component)fetchPanel, "South");
        this.add(topContainer, "North");
        this.impListPanel.setLayout(new GridBagLayout());
        this.impListPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        jPanel.add((Component)this.impListPanel, "North");
        JPanel errorWrapper = new JPanel(new BorderLayout());
        errorWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.errorPanel.setContent("Nothing to display    :(", "Either I have no implings to show you, or an error has occurred.");
        errorWrapper.add((Component)this.errorPanel, "North");
        JPanel splashWrapper = new JPanel(new BorderLayout());
        splashWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.splashPanel.setContent("Welcome to Impling Finder!", " This plugin watches for implings around you, and uploads the locations of implings of Magpie quality or higher to an external server. Try clicking on a found impling to see its precise location on your worldmap. Make sure to go to the config and check 'Splash Seen' so that you don't see this splash page again. Uploads are only done when implings are actually found, so this plugin has virtually 0 network usage. Please raise an issue in the github repo if you find one, or would like to request a feature! This plugin crowdsources data, so the more people using it, the better. Tell your friends to install!");
        splashWrapper.add((Component)this.splashPanel, "North");
        JButton getStartedButton = new JButton("Let's get started");
        getStartedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImplingFinderPanel.this.continuePastSplash();
            }
        });
        splashWrapper.add((Component)getStartedButton, "South");
        this.implingListContainer.add((Component)splashWrapper, SPLASH_PANEL);
        this.implingListContainer.add((Component)jPanel, RESULTS_PANEL);
        this.implingListContainer.add((Component)errorWrapper, ERROR_PANEL);
        this.cardLayout.show(this.implingListContainer, SPLASH_PANEL);
        this.add(this.implingListContainer, "Center");
    }

    public void notifyButtonSelected(String s) {
        for (ImplingFinderButton ib : this.buttonList) {
            if (s.equals("Recent") && !ib.getName().equals("Recent") || !s.equals("Recent") && ib.getName().equals("Recent")) {
                ib.setSelected(false);
            }
            ib.paint(ib.getGraphics());
        }
    }

    public List<Integer> getSelectedButtons() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (ImplingFinderButton ib : this.buttonList) {
            if (!ib.isSelected()) continue;
            l.add(ImplingFinderEnum.getIdByNameFuzzy(ib.getName()));
        }
        return l;
    }

    private void populateButtonList() {
        this.buttonList.clear();
        for (String s : TargetableImplings) {
            AsyncBufferedImage i;
            int id = ImplingFinderEnum.getIdByNameFuzzy(s);
            if (id == -1) {
                i = this.itemManager.getImage(8053);
            } else {
                int itemid = ImplingFinderImpPanel.getItemIdFromNpcId(id);
                i = this.itemManager.getImage(itemid);
            }
            final ImplingFinderButton b = new ImplingFinderButton((Image)i, s);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    b.setSelected(!b.isSelected());
                    ImplingFinderPanel.this.notifyButtonSelected(b.getName());
                }
            });
            if (id == -1) {
                b.setSelected(true);
            }
            this.buttonList.add(b);
        }
    }

    public void showSplash() {
        this.cardLayout.show(this.implingListContainer, SPLASH_PANEL);
    }

    public void continuePastSplash() {
        this.cardLayout.show(this.implingListContainer, ERROR_PANEL);
    }

    public void populateNpcs(List<ImplingFinderData> npcs) {
        this.c.gridy = 0;
        this.c.weighty = 0.0;
        this.impListPanel.removeAll();
        if (npcs.size() == 0) {
            this.cardLayout.show(this.implingListContainer, ERROR_PANEL);
            return;
        }
        this.cardLayout.show(this.implingListContainer, RESULTS_PANEL);
        ArrayList<JPanel> implings = new ArrayList<JPanel>();
        int defaultThumbnailId = 25613;
        for (ImplingFinderData npc : npcs) {
            JPanel marginWrapper = new JPanel(new BorderLayout());
            marginWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
            marginWrapper.setBorder(new EmptyBorder(5, 0, 0, -4));
            ImplingFinderImpPanel imp = new ImplingFinderImpPanel(this.itemManager, npc, defaultThumbnailId, this.plugin);
            imp.setAutoscrolls(true);
            imp.setBorder(new EmptyBorder(3, 0, 0, 7));
            marginWrapper.add(imp);
            implings.add(marginWrapper);
        }
        for (JPanel p : implings) {
            this.impListPanel.add((Component)p, this.c);
            ++this.c.gridy;
        }
        this.repaint();
        this.revalidate();
    }

    public boolean isClearRequested() {
        return this.clearRequested;
    }

    public void setClearRequested(boolean clearRequested) {
        this.clearRequested = clearRequested;
    }

    public boolean isFetchRequested() {
        return this.fetchRequested;
    }

    public void setFetchRequested(boolean fetchRequested) {
        this.fetchRequested = fetchRequested;
    }

    public boolean isFetchTargetedRequested() {
        return this.fetchTargetedRequested;
    }

    public void setFetchTargetedRequested(boolean fetchTargetedRequested) {
        this.fetchTargetedRequested = fetchTargetedRequested;
    }

    public boolean isSplashRequested() {
        return this.splashRequested;
    }
}

