/*
 * Decompiled with CFR 0.152.
 */
package com.hablapatabla.implingfinder.ui;

import com.hablapatabla.implingfinder.ImplingFinderPlugin;
import com.hablapatabla.implingfinder.model.ImplingFinderData;
import com.hablapatabla.implingfinder.model.ImplingFinderEnum;
import com.hablapatabla.implingfinder.model.ImplingFinderRegion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImplingFinderImpPanel
extends JPanel {
    private static final Dimension ICON_SIZE = new Dimension(32, 32);
    @Inject
    private WorldMapPointManager worldMapPointManager;
    private static Map<Integer, Integer> thumbnails = new HashMap<Integer, Integer>(){
        {
            this.put(1642, 11252);
            this.put(1643, 11254);
            this.put(8741, 23768);
            this.put(1644, 11256);
            this.put(7233, 19732);
        }
    };
    private Logger logger = LoggerFactory.getLogger(ImplingFinderImpPanel.class);
    private List<JPanel> panels = new ArrayList<JPanel>();
    protected ImplingFinderPlugin plugin;

    public static int getItemIdFromNpcId(int id) {
        return thumbnails.get(id);
    }

    ImplingFinderImpPanel(ItemManager manager, ImplingFinderData data, Integer defaultId, final ImplingFinderPlugin plugin) {
        Color background = this.getBackground();
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        this.setLayout(layout);
        this.setToolTipText(ImplingFinderEnum.findById(data.getNpcid()).getName());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.panels.add(this);
        this.setBorder(new EmptyBorder(7, 0, 0, 0));
        final WorldPoint implingWorldPoint = new WorldPoint(data.getXcoord(), data.getYcoord(), data.getPlane());
        MouseAdapter itemPanelMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                for (JPanel p : ImplingFinderImpPanel.this.panels) {
                    ImplingFinderImpPanel.this.matchComponentBackground(p, ColorScheme.DARK_GRAY_HOVER_COLOR);
                }
                ImplingFinderImpPanel.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                for (JPanel p : ImplingFinderImpPanel.this.panels) {
                    ImplingFinderImpPanel.this.matchComponentBackground(p, ColorScheme.DARKER_GRAY_COLOR);
                }
                ImplingFinderImpPanel.this.setCursor(new Cursor(0));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                plugin.addMapPoints(implingWorldPoint);
            }
        };
        this.addMouseListener(itemPanelMouseListener);
        JLabel itemIcon = new JLabel();
        itemIcon.setPreferredSize(ICON_SIZE);
        Integer id = thumbnails.get(data.getNpcid());
        if (id != null) {
            manager.getImage(id.intValue()).addTo(itemIcon);
        } else {
            manager.getImage(defaultId.intValue()).addTo(itemIcon);
        }
        JPanel iconPanel = new JPanel();
        this.panels.add(iconPanel);
        iconPanel.add(itemIcon);
        this.add((Component)iconPanel, "Before");
        JPanel rightPanel = new JPanel(new GridLayout(3, 1));
        this.panels.add(rightPanel);
        rightPanel.setBackground(background);
        JLabel itemName = new JLabel();
        itemName.setForeground(Color.WHITE);
        itemName.setMaximumSize(new Dimension(0, 0));
        itemName.setPreferredSize(new Dimension(0, 0));
        itemName.setText(ImplingFinderEnum.findById(data.getNpcid()).getName());
        rightPanel.add(itemName);
        JPanel middleTextPanel = new JPanel(new BorderLayout());
        middleTextPanel.setBackground(background);
        this.panels.add(middleTextPanel);
        JLabel middleLeftTextLabel = new JLabel();
        middleLeftTextLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        middleLeftTextLabel.setText("World: " + data.getWorld());
        middleTextPanel.add((Component)middleLeftTextLabel, "West");
        JLabel middleRightTextLabel = new JLabel();
        middleRightTextLabel.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        long daysBetween = ChronoUnit.DAYS.between(data.getDiscoveredtime(), Instant.now());
        Object day = daysBetween == 0L ? "Today" : (daysBetween == 1L ? "Yesterday" : daysBetween + " days ago");
        middleRightTextLabel.setText((String)day);
        middleTextPanel.add((Component)middleRightTextLabel, "East");
        rightPanel.add(middleTextPanel);
        JPanel bottomTextRowPanel = new JPanel(new BorderLayout());
        bottomTextRowPanel.setBackground(background);
        this.panels.add(bottomTextRowPanel);
        JLabel bottomLeftTextLabel = new JLabel();
        String foundTime = data.getDiscoveredtime().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG));
        bottomLeftTextLabel.setText(foundTime);
        bottomLeftTextLabel.setForeground(ColorScheme.GRAND_EXCHANGE_ALCH);
        bottomTextRowPanel.add((Component)bottomLeftTextLabel, "West");
        int playerRegionId = implingWorldPoint.getRegionID();
        String location = ImplingFinderRegion.fromRegion(playerRegionId) != null ? ImplingFinderRegion.fromRegion(playerRegionId).getName() : "Unknown";
        location = StringUtils.abbreviate((String)location, (int)12);
        JLabel bottomRightTextLabel = new JLabel();
        bottomRightTextLabel.setText(location);
        bottomRightTextLabel.setForeground(ColorScheme.GRAND_EXCHANGE_LIMIT);
        bottomRightTextLabel.setBorder(new CompoundBorder(bottomRightTextLabel.getBorder(), new EmptyBorder(0, 0, 0, 7)));
        bottomTextRowPanel.add((Component)bottomRightTextLabel, "East");
        rightPanel.add(bottomTextRowPanel);
        for (JPanel p : this.panels) {
            this.matchComponentBackground(p, ColorScheme.DARKER_GRAY_COLOR);
        }
        this.add((Component)rightPanel, "Center");
    }

    private void matchComponentBackground(JPanel panel, Color color) {
        panel.setBackground(color);
        for (Component c : panel.getComponents()) {
            c.setBackground(color);
        }
    }
}

