/*
 * Decompiled with CFR 0.152.
 */
package com.hablapatabla.implingfinder.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.EtchedBorder;
import net.runelite.client.ui.ColorScheme;

class ImplingFinderButton
extends JButton {
    private boolean selected;
    private String name;

    ImplingFinderButton(Image i, String name) {
        super.setContentAreaFilled(false);
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setFocusPainted(false);
        this.setRequestFocusEnabled(false);
        this.selected = false;
        this.name = name;
        this.setIcon(new ImageIcon(i));
        this.setBorder(new EtchedBorder());
    }

    @Override
    public void paint(Graphics g) {
        Color oldFg;
        Color newFg = oldFg = this.getForeground();
        ButtonModel mod = this.getModel();
        if (mod.isPressed()) {
            g.setColor(ColorScheme.DARK_GRAY_COLOR);
        } else if (mod.isRollover()) {
            g.setColor(ColorScheme.DARKER_GRAY_HOVER_COLOR);
        } else if (this.selected) {
            g.setColor(ColorScheme.DARKER_GRAY_COLOR);
        } else {
            g.setColor(ColorScheme.DARK_GRAY_COLOR);
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.setForeground(newFg);
        super.paintComponent(g);
        this.setForeground(oldFg);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

