/*
 * Decompiled with CFR 0.152.
 */
package com.hablapatabla.implingfinder.model;

import com.hablapatabla.implingfinder.ImplingFinderPlugin;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;

public class ImplingFinderWorldMapPoint
extends WorldMapPoint {
    private final ImplingFinderPlugin plugin;
    private final BufferedImage worldImage;
    private final Point worldImagePoint;

    public ImplingFinderWorldMapPoint(WorldPoint worldPoint, ImplingFinderPlugin plugin) {
        super(worldPoint, null);
        this.worldImage = new BufferedImage(plugin.getWorldMapImage().getWidth(), plugin.getWorldMapImage().getHeight(), 2);
        Graphics graphics = this.worldImage.getGraphics();
        graphics.drawImage(plugin.getWorldMapImage(), 0, 0, null);
        graphics.drawImage(plugin.getWorldMapImage(), 0, 0, null);
        this.worldImagePoint = new Point(this.worldImage.getWidth(), this.worldImage.getHeight());
        this.plugin = plugin;
        this.setName("Impling");
        this.setSnapToEdge(true);
        this.setJumpOnClick(true);
        this.setImage(this.worldImage);
        this.setImagePoint(this.worldImagePoint);
    }

    public void onEdgeSnap() {
        this.setImage(this.plugin.getWorldMapImage());
        this.setImagePoint(null);
    }

    public void onEdgeUnsnap() {
        this.setImage(this.worldImage);
        this.setImagePoint(this.worldImagePoint);
    }
}

