/*
 * Decompiled with CFR 0.152.
 */
package com.hablapatabla.implingfinder.model;

import java.util.HashMap;
import java.util.Map;

public enum ImplingFinderEnum {
    MAGPIE(1642, "Magpie impling"),
    NINJA(1643, "Ninja impling"),
    CRYSTAL(8741, "Crystal impling"),
    DRAGON(1644, "Dragon impling"),
    LUCKY(7233, "Lucky impling"),
    RECENT(-1, "Recent");

    private int npcId;
    private String name;
    private static final Map<Integer, ImplingFinderEnum> map;

    public static ImplingFinderEnum findById(int id) {
        return map.get(id);
    }

    public static int getIdByNameFuzzy(String name) {
        for (ImplingFinderEnum imp : ImplingFinderEnum.values()) {
            if (!imp.name.contains(name)) continue;
            return imp.npcId;
        }
        return -1;
    }

    public static int getIdByNameStrict(String name) {
        for (ImplingFinderEnum imp : ImplingFinderEnum.values()) {
            if (!name.contains(imp.name)) continue;
            return imp.npcId;
        }
        return -1;
    }

    public int getNpcId() {
        return this.npcId;
    }

    public String getName() {
        return this.name;
    }

    private ImplingFinderEnum(int npcId, String name) {
        this.npcId = npcId;
        this.name = name;
    }

    static {
        map = new HashMap<Integer, ImplingFinderEnum>();
        for (ImplingFinderEnum e : ImplingFinderEnum.values()) {
            map.put(e.npcId, e);
        }
    }
}

