/*
 * Decompiled with CFR 0.152.
 */
package com.hablapatabla.implingfinder.model;

import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImplingFinderData
implements Comparable {
    @SerializedName(value="npcid")
    private final int npcid;
    @SerializedName(value="world")
    private final int world;
    @SerializedName(value="xcoord")
    private final int xcoord;
    @SerializedName(value="ycoord")
    private final int ycoord;
    @SerializedName(value="plane")
    private final int plane;
    @SerializedName(value="discoveredtime")
    private final Instant discoveredtime;
    private static Logger logger = LoggerFactory.getLogger(ImplingFinderData.class);

    public String toString() {
        return this.npcid + "  " + this.world + "  " + this.xcoord + "  " + this.ycoord + "  " + this.plane + "  " + this.discoveredtime.toString();
    }

    public int compareTo(Object o) {
        ImplingFinderData other = (ImplingFinderData)o;
        return this.discoveredtime.compareTo(other.getDiscoveredtime());
    }

    ImplingFinderData(int npcid, int world, int xcoord, int ycoord, int plane, Instant discoveredtime) {
        this.npcid = npcid;
        this.world = world;
        this.xcoord = xcoord;
        this.ycoord = ycoord;
        this.plane = plane;
        this.discoveredtime = discoveredtime;
    }

    public static ImplingFinderDataBuilder builder() {
        return new ImplingFinderDataBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplingFinderData)) {
            return false;
        }
        ImplingFinderData other = (ImplingFinderData)o;
        if (this.getNpcid() != other.getNpcid()) {
            return false;
        }
        if (this.getWorld() != other.getWorld()) {
            return false;
        }
        if (this.getXcoord() != other.getXcoord()) {
            return false;
        }
        if (this.getYcoord() != other.getYcoord()) {
            return false;
        }
        if (this.getPlane() != other.getPlane()) {
            return false;
        }
        Instant this$discoveredtime = this.getDiscoveredtime();
        Instant other$discoveredtime = other.getDiscoveredtime();
        return !(this$discoveredtime == null ? other$discoveredtime != null : !((Object)this$discoveredtime).equals(other$discoveredtime));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNpcid();
        result = result * 59 + this.getWorld();
        result = result * 59 + this.getXcoord();
        result = result * 59 + this.getYcoord();
        result = result * 59 + this.getPlane();
        Instant $discoveredtime = this.getDiscoveredtime();
        result = result * 59 + ($discoveredtime == null ? 43 : ((Object)$discoveredtime).hashCode());
        return result;
    }

    public int getNpcid() {
        return this.npcid;
    }

    public int getWorld() {
        return this.world;
    }

    public int getXcoord() {
        return this.xcoord;
    }

    public int getYcoord() {
        return this.ycoord;
    }

    public int getPlane() {
        return this.plane;
    }

    public Instant getDiscoveredtime() {
        return this.discoveredtime;
    }

    public static class ImplingFinderDataBuilder {
        private int npcid;
        private int world;
        private int xcoord;
        private int ycoord;
        private int plane;
        private Instant discoveredtime;

        ImplingFinderDataBuilder() {
        }

        public ImplingFinderDataBuilder npcid(int npcid) {
            this.npcid = npcid;
            return this;
        }

        public ImplingFinderDataBuilder world(int world) {
            this.world = world;
            return this;
        }

        public ImplingFinderDataBuilder xcoord(int xcoord) {
            this.xcoord = xcoord;
            return this;
        }

        public ImplingFinderDataBuilder ycoord(int ycoord) {
            this.ycoord = ycoord;
            return this;
        }

        public ImplingFinderDataBuilder plane(int plane) {
            this.plane = plane;
            return this;
        }

        public ImplingFinderDataBuilder discoveredtime(Instant discoveredtime) {
            this.discoveredtime = discoveredtime;
            return this;
        }

        public ImplingFinderData build() {
            return new ImplingFinderData(this.npcid, this.world, this.xcoord, this.ycoord, this.plane, this.discoveredtime);
        }

        public String toString() {
            return "ImplingFinderData.ImplingFinderDataBuilder(npcid=" + this.npcid + ", world=" + this.world + ", xcoord=" + this.xcoord + ", ycoord=" + this.ycoord + ", plane=" + this.plane + ", discoveredtime=" + this.discoveredtime + ")";
        }
    }
}

