/*
 * Decompiled with CFR 0.152.
 */
package com.hablapatabla.implingfinder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.hablapatabla.implingfinder.ImplingFinderPlugin;
import com.hablapatabla.implingfinder.model.ImplingFinderData;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ImplingFinderWebManager {
    protected static final String CONTENT = "Content-Type";
    protected static final String JSON = "application/json";
    private static final MediaType JSONTYPE = MediaType.parse((String)"application/json; charset=utf-8");
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private ImplingFinderPlugin plugin;
    @Inject
    private GsonBuilder gsonBuilder;
    private Logger logger = LoggerFactory.getLogger(ImplingFinderWebManager.class);

    protected void postImplings() {
        try {
            for (ImplingFinderData data : this.plugin.getImplingsToUpload()) {
                Request r = new Request.Builder().url(ImplingFinderPlugin.implingPostEndpoint).addHeader(CONTENT, JSON).post(RequestBody.create((MediaType)JSONTYPE, (String)this.getGson().toJson((Object)data))).build();
                this.okHttpClient.newCall(r).enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        ImplingFinderWebManager.this.logger.error("Failed to post implings", (Throwable)e);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Call call, Response response) throws IOException {
                        try {
                            if (!response.isSuccessful()) {
                                ImplingFinderWebManager.this.logger.error("On post response error " + response.body().string());
                            }
                        }
                        catch (Exception e) {
                            ImplingFinderWebManager.this.logger.error("POST responded unsuccessful ", (Throwable)e);
                        }
                        finally {
                            response.close();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("Outer catch block POST ", (Throwable)e);
        }
        this.plugin.getImplingsToUpload().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ImplingFinderData> getData(List<Integer> ids) {
        ArrayList<Future<ImplingsWrapper>> futures = new ArrayList<Future<ImplingsWrapper>>();
        List<ImplingFinderData> implings = new ArrayList<ImplingFinderData>();
        for (Integer n : ids) {
            Object endpoint = n != -1 ? ImplingFinderPlugin.implingGetIdEndpoint + Integer.toString(n) : ImplingFinderPlugin.implingGetAnyEndpoint;
            Future<ImplingsWrapper> f = this.fetchAndDeserializeSpecificImpling((String)endpoint, this.getGson(), new TypeToken<ImplingsWrapper>(){});
            futures.add(f);
        }
        try {
            for (Future future : futures) {
                List<ImplingFinderData> l = ((ImplingsWrapper)future.get()).implings;
                implings.addAll(l);
            }
        }
        catch (Exception e) {
            this.logger.error("Error opening futures", (Throwable)e);
        }
        finally {
            Collections.sort(implings, Collections.reverseOrder());
            if (implings.size() > 25) {
                implings = implings.subList(0, 25);
            }
            return implings;
        }
    }

    private <T> Future<T> fetchAndDeserializeSpecificImpling(String url, final Gson gson, final TypeToken<T> typeToken) {
        CompletableFuture<String> future = this.getSpecificImplingResponseAsync(url);
        return future.thenApply(new Function<String, T>(){

            @Override
            public T apply(String body) {
                return gson.fromJson(body, typeToken.getType());
            }
        });
    }

    private CompletableFuture<String> getSpecificImplingResponseAsync(String url) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        Request r = new Request.Builder().url(url).build();
        this.okHttpClient.newCall(r).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                block6: {
                    try {
                        if (response.isSuccessful()) {
                            future.complete(response.body().string());
                            break block6;
                        }
                        throw new IOException("Http error");
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                    finally {
                        response.close();
                    }
                }
            }
        });
        return future;
    }

    private Gson getGson() {
        return this.gsonBuilder.registerTypeAdapter(Instant.class, (Object)new InstantSecondsConverter()).create();
    }

    private static class InstantSecondsConverter
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        private InstantSecondsConverter() {
        }

        public JsonElement serialize(Instant src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getEpochSecond());
        }

        public Instant deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return Instant.ofEpochSecond(json.getAsLong());
        }
    }

    private static final class ImplingsWrapper {
        @SerializedName(value="items")
        private final List<ImplingFinderData> implings;

        public ImplingsWrapper(List<ImplingFinderData> implings) {
            this.implings = implings;
        }

        public List<ImplingFinderData> getImplings() {
            return this.implings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImplingsWrapper)) {
                return false;
            }
            ImplingsWrapper other = (ImplingsWrapper)o;
            List<ImplingFinderData> this$implings = this.getImplings();
            List<ImplingFinderData> other$implings = other.getImplings();
            return !(this$implings == null ? other$implings != null : !((Object)this$implings).equals(other$implings));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ImplingFinderData> $implings = this.getImplings();
            result = result * 59 + ($implings == null ? 43 : ((Object)$implings).hashCode());
            return result;
        }

        public String toString() {
            return "ImplingFinderWebManager.ImplingsWrapper(implings=" + this.getImplings() + ")";
        }
    }
}

