/*
 * Decompiled with CFR 0.152.
 */
package com.hablapatabla.implingfinder;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.hablapatabla.implingfinder.ImplingFinderConfig;
import com.hablapatabla.implingfinder.ImplingFinderWebManager;
import com.hablapatabla.implingfinder.model.ImplingFinderData;
import com.hablapatabla.implingfinder.model.ImplingFinderEnum;
import com.hablapatabla.implingfinder.model.ImplingFinderWorldMapPoint;
import com.hablapatabla.implingfinder.ui.ImplingFinderPanel;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Impling Finder", description="A plugin to crowdsource impling locations", tags={"config", "menu", "impling", "finder", "hunter", "group", "fun", "crowdsource", "crowd", "party", "implingfinder", "impling finder", "clue", "clue scroll", "medium clue", "Impling Finder", "Impling", "Finder"}, loadWhenOutdated=true, enabledByDefault=true)
public class ImplingFinderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ImplingFinderPlugin.class);
    @Inject
    private ImplingFinderConfig config;
    @Inject
    private ImplingFinderPanel panel;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    private Gson gson;
    @Inject
    private ItemManager itemManager;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private ImplingFinderWebManager webManager;
    @Inject
    private WorldService worldService;
    @Inject
    private Notifier notifier;
    private NavigationButton button = null;
    private List<ImplingFinderData> implingsToUpload = new ArrayList<ImplingFinderData>();
    private List<ImplingFinderData> remotelyFetchedImplings = new ArrayList<ImplingFinderData>();
    protected static String implingGetAnyEndpoint = "https://puos0bfgxc2lno5-implingdb.adb.us-phoenix-1.oraclecloudapps.com/ords/impling/implingdev/dev";
    protected static String implingGetIdEndpoint = "https://puos0bfgxc2lno5-implingdb.adb.us-phoenix-1.oraclecloudapps.com/ords/impling/implingdev/dev/";
    protected static String implingPostEndpoint = "https://puos0bfgxc2lno5-implingdb.adb.us-phoenix-1.oraclecloudapps.com/ords/impling/implingdev/dev";
    public static final int RECENT_IMPLINGS_ID = -1;
    private Logger logger;
    private BufferedImage icon;
    private BufferedImage mapArrow = null;
    private boolean mapPointSet = false;
    private boolean displayingButton = true;
    private boolean wantSpawnNotifications = false;
    private long lastGetCall = System.currentTimeMillis();
    protected static final String CONFIG_GROUP = "Impling Finder";
    private static final int NPC_UPLOAD_TIME = 20;
    private static final int PANEL_REFRESH_TIME = 1;
    private static final int GET_REQUEST_COOLDOWN_TIME = 2000;

    @Provides
    ImplingFinderConfig provideConfig(ConfigManager configManager) {
        return (ImplingFinderConfig)configManager.getConfig(ImplingFinderConfig.class);
    }

    protected void startUp() throws Exception {
        this.logger = LoggerFactory.getLogger(ImplingFinderPlugin.class);
        this.loadPluginPanel();
        if (!this.config.beenOpened()) {
            this.panel.showSplash();
        } else {
            this.panel.continuePastSplash();
        }
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.button);
    }

    private void loadPluginPanel() {
        try {
            this.icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        }
        catch (Exception e) {
            this.logger.error("Couldn't load plugin icon");
            return;
        }
        if (this.button != null) {
            this.clientToolbar.removeNavigation(this.button);
        }
        this.panel = (ImplingFinderPanel)((Object)this.injector.getInstance(ImplingFinderPanel.class));
        this.button = NavigationButton.builder().tooltip(CONFIG_GROUP).icon(this.icon).priority(6).panel((PluginPanel)this.panel).build();
        if (this.displayingButton) {
            this.clientToolbar.addNavigation(this.button);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            switch (event.getKey()) {
                case "hideButton": {
                    if (this.config.hideButton()) {
                        this.clientToolbar.removeNavigation(this.button);
                        break;
                    }
                    this.clientToolbar.addNavigation(this.button);
                    break;
                }
                case "post endpoint": {
                    implingPostEndpoint = this.config.implingFinderPostEndpointConfig();
                    break;
                }
                case "get endpoint": {
                    implingGetAnyEndpoint = this.config.implingFinderGetEndpointConfig();
                    break;
                }
                case "spawnNotify": {
                    this.wantSpawnNotifications = this.config.implingSpawnNotify();
                }
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (npc.getName() == null) {
            return;
        }
        if (!this.isImpling(npc.getName())) {
            return;
        }
        if (this.wantSpawnNotifications) {
            this.notifier.notify("An impling just spawned!");
        }
        ImplingFinderData imp = this.makeImp(npc);
        this.logger.error(imp.toString());
        this.implingsToUpload.add(imp);
    }

    private boolean isImpling(String name) {
        return ImplingFinderEnum.getIdByNameStrict(name) != -1;
    }

    private boolean isImpling(int id) {
        return ImplingFinderEnum.findById(id) != null;
    }

    private ImplingFinderData makeImp(NPC n) {
        int world = this.client.getWorld();
        WorldArea area = n.getWorldArea();
        WorldPoint point = area.toWorldPoint();
        return ImplingFinderData.builder().npcid(ImplingFinderEnum.getIdByNameStrict(n.getName())).world(world).xcoord(point.getX()).ycoord(point.getY()).plane(point.getPlane()).discoveredtime(Instant.now()).build();
    }

    public BufferedImage getWorldMapImage() {
        return ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
    }

    public void addMapPoints(WorldPoint ... points) {
        WorldPoint p = this.client.getLocalPlayer().getWorldLocation();
        if (p == null) {
            return;
        }
        if (this.mapPointSet) {
            this.mapPointSet = false;
            this.worldMapPointManager.removeIf(ImplingFinderWorldMapPoint.class::isInstance);
            return;
        }
        this.mapPointSet = true;
        this.worldMapPointManager.removeIf(ImplingFinderWorldMapPoint.class::isInstance);
        for (WorldPoint point : points) {
            this.worldMapPointManager.add((WorldMapPoint)new ImplingFinderWorldMapPoint(point, this));
        }
    }

    @Schedule(period=20L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void uploadFoundImplings() {
        if (this.implingsToUpload.size() > 0) {
            this.webManager.postImplings();
        }
    }

    @Schedule(period=1L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void checkPanelRequest() {
        long currTime = System.currentTimeMillis();
        if (this.panel.isClearRequested()) {
            this.remotelyFetchedImplings.clear();
            this.updatePanels();
            this.panel.setClearRequested(false);
        }
        if (this.panel.isFetchRequested() && currTime - this.lastGetCall >= 2000L) {
            this.remotelyFetchedImplings.clear();
            this.remotelyFetchedImplings = this.webManager.getData(this.panel.getSelectedButtons());
            this.panel.setFetchRequested(false);
            this.lastGetCall = System.currentTimeMillis();
            this.updatePanels();
        }
    }

    public void updatePanels() {
        Collections.sort(this.remotelyFetchedImplings, Collections.reverseOrder());
        SwingUtilities.invokeLater(() -> this.panel.populateNpcs(this.remotelyFetchedImplings));
    }

    NavigationButton getButton() {
        return this.button;
    }

    List<ImplingFinderData> getImplingsToUpload() {
        return this.implingsToUpload;
    }

    void setRemotelyFetchedImplings(List<ImplingFinderData> remotelyFetchedImplings) {
        this.remotelyFetchedImplings = remotelyFetchedImplings;
    }
}

