/*
 * Decompiled with CFR 0.152.
 */
package com.switching;

import com.switching.SwitchingPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.runelite.api.Experience;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ImageUtil;

public class XPOverlay
extends Overlay {
    private SwitchingPlugin plugin;
    private boolean hovering = false;
    BufferedImage cursorSkill;

    public XPOverlay(SwitchingPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.cursorSkill = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/switching.png");
        this.setDragTargetable(true);
        this.setPreferredPosition(OverlayPosition.TOP_CENTER);
    }

    public void onMouseOver() {
        super.onMouseOver();
        this.hovering = true;
    }

    public Dimension render(Graphics2D graphics) {
        FontMetrics metrics = graphics.getFontMetrics();
        graphics.drawImage(this.cursorSkill, 0, 0, this.cursorSkill.getWidth(), this.cursorSkill.getHeight(), null);
        graphics.setColor(Color.YELLOW);
        graphics.drawString("" + Experience.getLevelForXp((int)this.plugin.switchingXP), this.cursorSkill.getWidth() / 2 + 1, 17);
        graphics.drawString("" + Experience.getLevelForXp((int)this.plugin.switchingXP), this.cursorSkill.getWidth() / 2 + 15, 27);
        if (this.hovering) {
            String text = "Switching XP: " + this.plugin.switchingXP;
            Rectangle rect = new Rectangle(5, this.cursorSkill.getHeight() + 5, metrics.stringWidth(text) + 4, metrics.getMaxAscent() + 6);
            graphics.setColor(Color.BLACK);
            graphics.fillRect(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
            graphics.setColor(new Color(255, 255, 160));
            graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
            graphics.setColor(Color.BLACK);
            graphics.drawString(text, rect.x + 2, rect.y + metrics.getMaxAscent() + 2);
        }
        this.hovering = false;
        return new Dimension(this.cursorSkill.getWidth(), this.cursorSkill.getHeight());
    }
}

