/*
 * Decompiled with CFR 0.152.
 */
package com.switching;

import com.google.inject.Provides;
import com.switching.DropsOverlay;
import com.switching.SwitchData;
import com.switching.SwitchingConfig;
import com.switching.TrainingMode;
import com.switching.XPDrop;
import com.switching.XPOverlay;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Switching Trainer")
public class SwitchingPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SwitchingPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SwitchingConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    private Item[] previousEquipment;
    private int ticksSinceStarted = 0;
    private int ticksSinceLastSwitch = 0;
    private int numberWaySwitch = 0;
    private ArrayList<Integer> waySwitchesToTrack = new ArrayList();
    public static final String DEFAULT_WAY_SWITCHES = "2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28";
    public int globalTickCounter = 0;
    public ArrayList<SwitchData> sessionData = new ArrayList();
    public File file = new File(RuneLite.RUNELITE_DIR, "switching-trainer/");
    public String textFile = "count.txt";
    public int switchingXP = 0;
    public XPOverlay overlay;
    public DropsOverlay dropsOverlay;
    public Clip levelup = null;
    Integer[] fireWorks = new Integer[]{199, 1388, 1389};

    protected void startUp() {
        this.loadWaySwitches(this.config.trackWaySwitches());
        this.switchingXP = this.loadFile();
        this.overlay = new XPOverlay(this);
        this.dropsOverlay = new DropsOverlay(this);
        try {
            this.levelup = AudioSystem.getClip();
            AudioInputStream sound = AudioSystem.getAudioInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/levelup.wav"));
            this.levelup.open(sound);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
    }

    protected void shutDown() {
        this.saveFile();
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.dropsOverlay);
        if (this.levelup != null) {
            this.levelup.close();
        }
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown clientShutdown) {
        this.saveFile();
    }

    public void saveFile() {
        this.file.mkdir();
        try {
            DataOutputStream writer = new DataOutputStream(new FileOutputStream(new File(this.file, this.textFile)));
            writer.writeInt(this.switchingXP);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int loadFile() {
        try {
            DataInputStream reader = new DataInputStream(new FileInputStream(new File(this.file, this.textFile)));
            int out = reader.readInt();
            reader.close();
            return out;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean loadWaySwitches(String commaSeparatedList) {
        String[] arr = commaSeparatedList.split(",");
        this.waySwitchesToTrack.clear();
        try {
            for (String s : arr) {
                if (s.length() == 0) continue;
                this.waySwitchesToTrack.add(Integer.parseInt(s));
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (this.config.trackWaySwitches().split(",").length <= 0 || !this.loadWaySwitches(this.config.trackWaySwitches())) {
            this.configManager.setConfiguration("switchingTrainer", "trackWaySwitches", DEFAULT_WAY_SWITCHES);
            this.loadWaySwitches(DEFAULT_WAY_SWITCHES);
            this.client.addChatMessage(ChatMessageType.CONSOLE, "", "Switching Plugin Error: \"# Way Switches was invalid\"", null);
            this.client.addChatMessage(ChatMessageType.CONSOLE, "", "Switching Plugin Loaded default value \"2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28\"", null);
        }
    }

    public void updateXPOverlay() {
        if (!this.config.skillingInterface()) {
            this.overlayManager.remove((Overlay)this.overlay);
            this.overlayManager.remove((Overlay)this.dropsOverlay);
            return;
        }
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.dropsOverlay);
    }

    public void startTimer() {
        if (this.ticksSinceStarted > 0) {
            return;
        }
        this.ticksSinceStarted = 1;
    }

    public void updateTimer() {
        if (this.ticksSinceStarted <= 0) {
            return;
        }
        ++this.ticksSinceStarted;
    }

    public void stopTimer() {
        if (this.ticksSinceStarted <= 0) {
            return;
        }
        this.ticksSinceStarted -= 100;
    }

    public int getTimer() {
        if (this.ticksSinceStarted < 0) {
            return this.ticksSinceStarted + 100;
        }
        return this.ticksSinceStarted;
    }

    public int getSlot(Item i) {
        ItemStats itemStats = this.itemManager.getItemStats(i.getId(), false);
        if (itemStats == null) {
            return 0;
        }
        if (itemStats.getEquipment() == null) {
            return 0;
        }
        return itemStats.getEquipment().getSlot();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getContainerId() == InventoryID.EQUIPMENT.getId()) {
            if (this.previousEquipment == null) {
                this.previousEquipment = this.client.getItemContainer(InventoryID.EQUIPMENT).getItems();
            }
            Item[] newItems = itemContainerChanged.getItemContainer().getItems();
            ArrayList<Integer> slots = new ArrayList<Integer>();
            int amt = 0;
            for (Item i : newItems) {
                boolean isNew = true;
                for (Object j : this.previousEquipment) {
                    if (i.getId() != j.getId()) continue;
                    isNew = false;
                    break;
                }
                if (!isNew) continue;
                ++amt;
                slots.add(this.getSlot(i));
            }
            block2: for (Item i : this.previousEquipment) {
                boolean existedBefore = false;
                for (Integer integer : slots) {
                    if (!integer.equals(this.getSlot(i))) continue;
                    continue block2;
                }
                for (Object j : newItems) {
                    if (i.getId() != j.getId()) continue;
                    existedBefore = true;
                    break;
                }
                if (existedBefore) continue;
                ++amt;
            }
            this.previousEquipment = newItems;
            if (amt == 0) {
                return;
            }
            this.startTimer();
            this.numberWaySwitch += amt;
            this.ticksSinceLastSwitch = 0;
        }
    }

    private void giveXP(int amt) {
        if (Experience.getLevelForXp((int)this.switchingXP) != Experience.getLevelForXp((int)(this.switchingXP + (amt *= Experience.getLevelForXp((int)this.switchingXP))))) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Congratulations, you've just advanced your Switching level. You are now level " + Experience.getLevelForXp((int)(this.switchingXP + amt)) + ".", null);
            this.levelup.loop(0);
            this.client.getLocalPlayer().setGraphic((Experience.getLevelForXp((int)(this.switchingXP + amt)) == 99 ? this.fireWorks[2] : (Experience.getLevelForXp((int)this.switchingXP) % 10 == 0 ? this.fireWorks[1] : this.fireWorks[0])).intValue());
            this.client.getLocalPlayer().setSpotAnimFrame(0);
        }
        this.switchingXP += amt;
        this.dropsOverlay.xpDrops.add(new XPDrop(amt));
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.ticksSinceLastSwitch > 0 && this.numberWaySwitch > 0) {
            this.ticksSinceStarted -= this.ticksSinceLastSwitch;
            this.stopTimer();
            if (this.waySwitchesToTrack.contains(this.numberWaySwitch) || this.config.trackAnyWaySwitches()) {
                SwitchData newData = new SwitchData(this.numberWaySwitch, this.getTimer(), this.globalTickCounter);
                this.giveXP(this.numberWaySwitch);
                this.sessionData.add(newData);
                if (this.config.trainingMode() == TrainingMode.BOTH || this.config.trainingMode() == TrainingMode.LIVE_FEEDBACK) {
                    this.sendMessage(this.getRatingColor(newData.getSwitchesPerTick()), newData.toString() + " (" + this.getRating(newData.getSwitchesPerTick()) + ")");
                }
                this.saveFile();
            }
            this.numberWaySwitch = 0;
        }
        if (this.config.trainingMode() == TrainingMode.OCCASIONAL_UPDATES || this.config.trainingMode() == TrainingMode.BOTH) {
            int tickFrequency = Math.round((float)(this.config.updateFrequency() * 60) / 0.6f);
            if (tickFrequency == 0) {
                tickFrequency = 1;
            }
            if (this.globalTickCounter % tickFrequency == 0) {
                ArrayList<SwitchData> latestData = new ArrayList<SwitchData>();
                for (int i = this.sessionData.size() - 1; i >= 0 && this.globalTickCounter - this.sessionData.get((int)i).timestamp < tickFrequency; --i) {
                    latestData.add(this.sessionData.get(i));
                }
                if (latestData.size() > 0) {
                    int totalSwitches = 0;
                    int totalTicks = 0;
                    for (SwitchData data : latestData) {
                        totalSwitches += data.getNumberWaySwitch();
                        totalTicks += data.getTicksTaken();
                    }
                    float avgSwitchesPerTick = totalTicks == 0 ? 0.0f : (float)totalSwitches / (float)totalTicks;
                    this.sendMessage(Color.CYAN, "*Switching Training Progress Update*");
                    this.sendMessage(Color.DARK_GRAY, "Switching Level: " + Experience.getLevelForXp((int)this.switchingXP) + " (" + this.switchingXP + " xp)");
                    this.sendMessage(Color.GRAY, "In the past " + this.config.updateFrequency() + " minutes, you've done:");
                    this.sendMessage(Color.GRAY, totalSwitches + " switches using " + totalTicks + " ticks, making for");
                    this.sendMessage(Color.LIGHT_GRAY, avgSwitchesPerTick + " switches per tick.");
                    this.sendMessage(this.getRatingColor(avgSwitchesPerTick), "Average Rating: " + this.getRating(avgSwitchesPerTick));
                }
            }
        }
        this.updateTimer();
        ++this.ticksSinceLastSwitch;
        ++this.globalTickCounter;
        this.updateXPOverlay();
    }

    public void sendMessage(Color color, String message) {
        String last = new ChatMessageBuilder().append(color, message).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(last).build());
    }

    public int lerp(int x, int y, float a) {
        return Math.round((float)x + (float)(y - x) * a);
    }

    public Color lerpColor(Color x, Color y, float a) {
        a = Math.max(0.0f, Math.min(1.0f, a));
        return new Color(this.lerp(x.getRed(), y.getRed(), a), this.lerp(x.getGreen(), y.getGreen(), a), this.lerp(x.getBlue(), y.getBlue(), a));
    }

    public Color lerpThreeColors(Color x, Color y, Color c, float a) {
        if ((double)(a = Math.max(0.0f, Math.min(1.0f, a))) <= 0.5) {
            return new Color(this.lerp(x.getRed(), y.getRed(), a), this.lerp(x.getGreen(), y.getGreen(), a), this.lerp(x.getBlue(), y.getBlue(), a));
        }
        return new Color(this.lerp(y.getRed(), c.getRed(), a), this.lerp(y.getGreen(), c.getGreen(), a), this.lerp(y.getBlue(), c.getBlue(), a));
    }

    public Color getRatingColor(float average) {
        return this.lerpThreeColors(Color.RED, Color.YELLOW, Color.GREEN, (average - 1.0f) / 4.0f);
    }

    public String getRating(float average) {
        if (average <= 1.0f) {
            return "F";
        }
        if (average <= 1.1f) {
            return "D-";
        }
        if (average <= 1.2f) {
            return "D";
        }
        if (average <= 1.3f) {
            return "D+";
        }
        if (average <= 1.4f) {
            return "C-";
        }
        if (average <= 1.5f) {
            return "C";
        }
        if (average <= 1.6f) {
            return "C+";
        }
        if (average <= 1.75f) {
            return "B-";
        }
        if (average <= 2.0f) {
            return "B";
        }
        if (average <= 2.5f) {
            return "B+";
        }
        if (average <= 2.75f) {
            return "A-";
        }
        if (average <= 3.25f) {
            return "A";
        }
        if (average <= 4.0f) {
            return "A+";
        }
        return "God-like";
    }

    @Provides
    SwitchingConfig provideConfig(ConfigManager configManager) {
        return (SwitchingConfig)configManager.getConfig(SwitchingConfig.class);
    }
}

