/*
 * Decompiled with CFR 0.152.
 */
package com.switching;

import com.switching.TrainingMode;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="switchingTrainer")
public interface SwitchingConfig
extends Config {
    @ConfigSection(name="Occasional Training Mode", description="Settings related to the occasional-update training mode", position=1)
    public static final String occasionalMode = "Occasional Training Mode";

    @ConfigItem(keyName="trackAnyWaySwitches", name="Track Any Way Switches", description="If true, allows any # of switches instead of just the ones specified in 'Track # Way Switches (,)'")
    default public boolean trackAnyWaySwitches() {
        return true;
    }

    @ConfigItem(keyName="trackWaySwitches", name="Track # Way Switches (,)", description="Comma separated list of numbers to track certain switches (e.g. '2,4,8')")
    default public String trackWaySwitches() {
        return "2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28";
    }

    @ConfigItem(keyName="skillingInterface", name="Show Skilling Interface", description="Whether or not to show the 'switching' skill for dopamine numbers.")
    default public boolean skillingInterface() {
        return true;
    }

    @ConfigItem(keyName="trainingMode", name="Mode", description="Whether to give instant feedback on switches via an overlay or to give occasional updates in chat.")
    default public TrainingMode trainingMode() {
        return TrainingMode.BOTH;
    }

    @Range(min=0)
    @ConfigItem(keyName="updateFrequency", name="Update Frequency (min)", description="How many minutes to update the player on their progress", section="Occasional Training Mode")
    default public int updateFrequency() {
        return 2;
    }
}

