/*
 * Decompiled with CFR 0.152.
 */
package herb10hp;

import com.google.inject.Provides;
import herb10hp.RangedGuildMinigameConfig;
import herb10hp.RangedGuildMinigameOverlay;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Ranged Guild Minigame Plugin", tags={"ranged", "ranging", "range", "minigame", "guild", "ranging guild", "ranged guild", "score", "hiscore", "high score"})
public class RangedGuildMinigamePlugin
extends Plugin {
    private int personalHighscore;
    private int turn;
    private int currentScore;
    @Inject
    private RangedGuildMinigameConfig config;
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private RangedGuildMinigameOverlay overlay;

    public boolean getCanPlayerShootOnCurrentTile() {
        int REGION_ID = 10549;
        WorldPoint playerPosition = this.client.getLocalPlayer().getWorldLocation();
        if (playerPosition.getRegionID() != 10549) {
            return false;
        }
        int[][] validTiles = new int[][]{{45, 25}, {45, 26}, {45, 28}, {46, 24}, {46, 25}, {46, 26}, {46, 27}, {46, 28}, {46, 29}, {47, 25}, {47, 26}, {47, 27}, {47, 28}, {48, 25}, {48, 26}, {48, 27}, {48, 28}, {48, 29}, {49, 24}, {49, 25}, {49, 26}, {49, 27}, {49, 28}, {50, 25}, {50, 26}, {51, 26}};
        int playerPositionX = playerPosition.getRegionX();
        int playerPositionY = playerPosition.getRegionY();
        return Arrays.stream(validTiles).anyMatch(tile -> tile[0] == playerPositionX && tile[1] == playerPositionY);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    RangedGuildMinigameConfig provideConfig(ConfigManager configManager) {
        return (RangedGuildMinigameConfig)configManager.getConfig(RangedGuildMinigameConfig.class);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int id = event.getVarpId();
        int value = event.getValue();
        int RANGED_GUILD_MINIGAME_TURN = 156;
        int RANGED_GUILD_MINIGAME_SCORE = 157;
        if (id == 156) {
            this.turn = Math.min(value, 10);
            if (this.turn == 0 && this.config.isNotifyOnCompletion()) {
                this.notifier.notify("Ranged Guild Minigame is complete.");
            }
        } else if (id == 157) {
            this.currentScore = value;
            if (value > this.personalHighscore) {
                this.personalHighscore = value;
            }
        }
    }

    int getPersonalHighscore() {
        return this.personalHighscore;
    }

    int getTurn() {
        return this.turn;
    }

    int getCurrentScore() {
        return this.currentScore;
    }
}

