/*
 * Decompiled with CFR 0.152.
 */
package com.dailyimplingjars;

import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Daily Impling Jars")
public class DailyImplingJarsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DailyImplingJarsPlugin.class);
    private static final int ONE_DAY = 86400000;
    private static final int DAILY_JARS_STATE = 11769;
    private static final String IMPLING_JARS_MESSAGE = "You have impling jars waiting to be collected from Elnock Inquisitor.";
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    private long lastReset;
    private boolean loggingIn;

    public void startUp() {
        this.loggingIn = true;
    }

    public void shutDown() {
        this.lastReset = 0L;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.loggingIn = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        boolean dailyReset;
        long currentTime = System.currentTimeMillis();
        boolean bl = dailyReset = !this.loggingIn && currentTime - this.lastReset > 86400000L;
        if ((dailyReset || this.loggingIn) && this.client.getVarcIntValue(103) == 1) {
            this.lastReset = (long)Math.floor(currentTime / 86400000L) * 86400000L;
            this.loggingIn = false;
            this.checkJars(dailyReset);
        }
    }

    private void checkJars(boolean dailyReset) {
        if (this.client.getVarbitValue(11769) < 10 || dailyReset) {
            this.sendChatMessage(IMPLING_JARS_MESSAGE);
        }
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }
}

