/*
 * Decompiled with CFR 0.152.
 */
package com.wellness;

import com.google.inject.Provides;
import com.wellness.WellnessConfig;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wellness Notifications", description="A plugin to add reminders that promote wellness and healthy gaming.", tags={"wellness", "health", "eye", "reminder", "hydration"})
public class WellnessPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WellnessPlugin.class);
    @Inject
    private Client client;
    @Inject
    private WellnessConfig config;
    @Inject
    private Notifier notifier;
    private Instant eyeNotifyTime;
    private Instant postureNotifyTime;

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN && this.eyeNotifyTime == null && this.config.eyenotify()) {
            this.eyeNotifyTime = Instant.now();
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN && this.postureNotifyTime == null && this.config.posturenotify()) {
            this.postureNotifyTime = Instant.now();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player local = this.client.getLocalPlayer();
        Duration eyeDuration = Duration.ofMinutes(this.config.eyeinterval());
        Duration postureDuration = Duration.ofMinutes(this.config.postureinterval());
        if (this.config.eyenotify() && Instant.now().compareTo(this.eyeNotifyTime.plus(eyeDuration)) >= 0) {
            this.notifier.notify(local.getName() + " it has been " + this.config.eyeinterval() + " minutes. Consider taking a small 20 second break from looking at the screen.");
            this.eyeNotifyTime = Instant.now();
        }
        if (this.config.posturenotify() && Instant.now().compareTo(this.postureNotifyTime.plus(postureDuration)) >= 0) {
            this.notifier.notify("Posture check!!! It has been " + this.config.postureinterval() + " minutes");
            this.postureNotifyTime = Instant.now();
        }
    }

    @Provides
    WellnessConfig provideConfig(ConfigManager configManager) {
        return (WellnessConfig)configManager.getConfig(WellnessConfig.class);
    }
}

