/*
 * Decompiled with CFR 0.152.
 */
package com.fightcavehelper.ui;

import com.fightcavehelper.Wave;
import com.fightcavehelper.ui.SpawnButton;
import com.fightcavehelper.ui.WaveSpawnPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    private static final Insets INSETS_LEFT_BORDER = new Insets(1, 0, 1, 1);
    private static final Insets INSETS_RIGHT_BORDER = new Insets(1, 1, 1, 0);
    private static final Insets INSETS = new Insets(1, 1, 1, 1);
    public static String spawn1;
    public static String spawn2A;
    public static String spawn2B;
    public static String spawn4A;
    public static String spawn4B;
    private static int choices;
    private static int choices4;
    static ArrayList<JButton> btns1;
    static ArrayList<JButton> btns2;
    static ArrayList<JButton> btns4;
    private final GridBagConstraints c;
    public static JLabel wave1;
    public static JLabel wave2;
    public static JLabel wave4;

    public ButtonPanel() {
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.add(wave1);
        this.createBtns1();
        this.add(wave2);
        this.createBtns2();
        this.add(wave4);
        wave4.setVisible(false);
        this.createBtns4();
    }

    public void createBtns1() {
        btns1.add(new SpawnButton("C"));
        btns1.add(new SpawnButton("NW"));
        btns1.add(new SpawnButton("S"));
        btns1.add(new SpawnButton("SE"));
        btns1.add(new SpawnButton("SW"));
        this.addComp(wave1);
        for (JButton btn : btns1) {
            btn.addActionListener(e -> {
                this.disableBtns1();
                this.setSpawn1(btn);
                this.enableBtns2();
                try {
                    Wave.addWaveSpawn();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                WaveSpawnPanel.updateWave();
            });
            this.add(btn);
            this.addComp(btn);
        }
    }

    public void disableBtns1() {
        for (JButton btn : btns1) {
            btn.setEnabled(false);
        }
    }

    public void setSpawn1(JButton btn) {
        spawn1 = btn.getText();
        btn.setBackground(Color.green);
    }

    public void createBtns2() {
        btns2.add(new SpawnButton("C"));
        btns2.add(new SpawnButton("NW"));
        btns2.add(new SpawnButton("S"));
        btns2.add(new SpawnButton("SE"));
        btns2.add(new SpawnButton("SW"));
        this.addComp(wave2);
        for (JButton btn : btns2) {
            btn.setEnabled(false);
            btn.addActionListener(e -> {
                btn.setEnabled(false);
                this.disableBtns2(btn.getText());
                try {
                    this.setSpawn2(btn);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            this.add(btn);
            this.addComp(btn);
        }
    }

    public void enableBtns2() {
        for (JButton btn : btns2) {
            if (Objects.equals(btn.getText(), spawn1)) continue;
            btn.setEnabled(true);
        }
    }

    public void disableBtns2(String text) {
        if (choices >= 2) {
            for (JButton btn : btns2) {
                if (btn.getText().equals(text)) continue;
                btn.setEnabled(false);
            }
        }
    }

    public void setSpawn2(JButton btn) throws IOException {
        if (choices == 0) {
            ++choices;
            spawn2A = btn.getText();
            btn.setBackground(Color.green);
        } else {
            ++choices;
            spawn2B = btn.getText();
            btn.setBackground(Color.green);
            Wave.addWaveSpawn();
            WaveSpawnPanel.updateWave();
        }
    }

    public void createBtns4() {
        btns4.add(new SpawnButton("S"));
        btns4.add(new SpawnButton("SE"));
        btns4.add(new SpawnButton("SW"));
        this.addComp(wave4);
        for (JButton btn : btns4) {
            btn.setEnabled(false);
            btn.setVisible(false);
            btn.addActionListener(e -> {
                btn.setEnabled(false);
                try {
                    this.setSpawn4(btn);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            this.add(btn);
            this.addComp(btn);
        }
    }

    public void disableBtns4() {
        for (JButton btn : btns4) {
            btn.setEnabled(false);
        }
    }

    public void setSpawn4(JButton btn) throws IOException {
        if (choices4 == 0) {
            ++choices4;
            spawn4A = btn.getText();
            btn.setBackground(Color.green);
        } else {
            spawn4B = btn.getText();
            btn.setBackground(Color.green);
            Wave.addWaveSpawn();
            WaveSpawnPanel.updateWave();
        }
    }

    public static void enableWave4() {
        for (JButton btn : btns2) {
            btn.setEnabled(false);
        }
        wave4.setVisible(true);
        for (JButton btn : btns4) {
            btn.setEnabled(true);
            btn.setVisible(true);
        }
    }

    public static void resetBtns() {
        choices = 0;
        choices4 = 0;
        spawn1 = "-";
        spawn2A = "-";
        spawn2B = "-";
        spawn4A = "-";
        spawn4B = "-";
        wave1.setVisible(true);
        wave2.setVisible(true);
        wave4.setVisible(false);
        WaveSpawnPanel.enableButtons(false);
        for (JButton btn : btns1) {
            btn.setForeground(Color.white);
            btn.setBackground(null);
            btn.setEnabled(true);
            btn.setVisible(true);
        }
        for (JButton btn : btns2) {
            btn.setForeground(Color.white);
            btn.setBackground(null);
            btn.setEnabled(false);
            btn.setVisible(true);
        }
        for (JButton btn : btns4) {
            btn.setForeground(Color.white);
            btn.setBackground(null);
            btn.setEnabled(false);
            btn.setVisible(false);
        }
    }

    private void addComp(Component component) {
        switch (this.c.gridx) {
            case 0: {
                this.c.insets = INSETS_LEFT_BORDER;
                break;
            }
            case 6: {
                this.c.insets = INSETS_RIGHT_BORDER;
                break;
            }
            default: {
                this.c.insets = INSETS;
            }
        }
        if (this.c.gridwidth == 6) {
            this.c.insets = INSETS_RIGHT_BORDER;
        }
        this.add(component, this.c);
        ++this.c.gridx;
        this.c.gridx %= 6;
        if (this.c.gridx == 0) {
            ++this.c.gridy;
        }
    }

    public static void hidePanel() {
        wave1.setVisible(false);
        wave2.setVisible(false);
        wave4.setVisible(false);
        for (JButton btn : btns1) {
            btn.setVisible(false);
        }
        for (JButton btn : btns2) {
            btn.setVisible(false);
        }
        for (JButton btn : btns4) {
            btn.setVisible(false);
        }
    }

    public static void Debug() {
        System.out.println("-------------------");
        System.out.println("Spawn1 = " + spawn1);
        System.out.println("Spawn2A = " + spawn2A);
        System.out.println("Spawn2B = " + spawn2B);
        System.out.println("Choices = " + choices);
        System.out.println("Rotation = " + Wave.rotation);
        System.out.println("Wave Number = " + Wave.number);
    }

    static {
        choices = 0;
        choices4 = 0;
        btns1 = new ArrayList();
        btns2 = new ArrayList();
        btns4 = new ArrayList();
        wave1 = new JLabel("Wave 1:");
        wave2 = new JLabel("Wave 2:");
        wave4 = new JLabel("Wave 4:");
    }
}

