/*
 * Decompiled with CFR 0.152.
 */
package com.fightcavehelper;

import com.fightcavehelper.ui.ButtonPanel;
import com.fightcavehelper.ui.WaveSpawnPanel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.runelite.client.util.ImageUtil;

public class Wave
extends JPanel {
    public static int rotation;
    public static int number;
    private static String waveImgPath;
    private static String url;
    private static BufferedImage image;
    private static ImageIcon img;
    public static final String IMG_PATH = "/waves/%s-%s.jpg";
    public static String spawn1;
    public static String spawn2;
    public static String spawn4;
    public static String spawn2_sorted;

    public Wave() {
        rotation = 0;
        number = 1;
        waveImgPath = String.format(IMG_PATH, rotation, number);
        image = ImageUtil.loadImageResource(this.getClass(), (String)waveImgPath);
        img = new ImageIcon(image);
    }

    public static void setImage() {
        waveImgPath = String.format(IMG_PATH, rotation, number);
        image = ImageUtil.loadImageResource(Wave.class, (String)waveImgPath);
        img = new ImageIcon(image);
    }

    public static ImageIcon getImage() {
        return img;
    }

    public static int getRotation() {
        return rotation;
    }

    public static int getNumber() {
        return number;
    }

    public static void setRotation(int rotation) {
        Wave.rotation = rotation;
    }

    public static void setNumber(int number) {
        Wave.number = number;
    }

    public static void reset() throws IOException {
        Wave.setRotation(0);
        Wave.setNumber(1);
        spawn1 = "-";
        spawn2 = "-";
        spawn4 = "-";
        Wave.setImage();
        WaveSpawnPanel.updateWave();
    }

    public static void addWaveSpawn() throws IOException {
        if (number == 1) {
            spawn1 = ButtonPanel.spawn1;
            Wave.increment();
        } else if (number == 2) {
            spawn2 = ButtonPanel.spawn2A + ButtonPanel.spawn2B;
            spawn2_sorted = spawn1 + "-" + Wave.sortString(spawn2);
            switch (spawn2_sorted) {
                case "C-NSWW": {
                    rotation = 1;
                    Wave.updatePanel();
                    break;
                }
                case "C-ESS": {
                    rotation = 2;
                    Wave.updatePanel();
                    break;
                }
                case "C-ESSW": {
                    rotation = 3;
                    Wave.updatePanel();
                    break;
                }
                case "NW-CS": {
                    rotation = 4;
                    Wave.updatePanel();
                    break;
                }
                case "NW-CES": {
                    rotation = 5;
                    Wave.updatePanel();
                    break;
                }
                case "NW-ESSW": {
                    rotation = 6;
                    Wave.updatePanel();
                    break;
                }
                case "S-CNW": {
                    rotation = 0;
                    Wave.updatePanel();
                    break;
                }
                case "S-ESSW": {
                    rotation = 9;
                    Wave.updatePanel();
                    break;
                }
                case "SE-NSW": {
                    rotation = 10;
                    Wave.updatePanel();
                    break;
                }
                case "SE-CSW": {
                    rotation = 11;
                    Wave.updatePanel();
                    break;
                }
                case "SE-SSW": {
                    rotation = 12;
                    Wave.updatePanel();
                    break;
                }
                case "SW-CNW": {
                    rotation = 13;
                    Wave.updatePanel();
                    break;
                }
                case "SW-NSW": {
                    rotation = 14;
                    Wave.updatePanel();
                    break;
                }
                case "SW-ESS": {
                    rotation = 15;
                    Wave.updatePanel();
                    break;
                }
                default: {
                    ButtonPanel.resetBtns();
                    Wave.reset();
                    System.out.println("Invalid selection, try again");
                    break;
                }
            }
        } else {
            spawn4 = ButtonPanel.spawn4A + ButtonPanel.spawn4B;
            String s = Wave.sortString(spawn4);
            WaveSpawnPanel.enableButtons(false);
            switch (s) {
                case "ESS": {
                    rotation = 7;
                    WaveSpawnPanel.enableButtons(true);
                    Wave.updatePanel();
                    break;
                }
                case "ESSW": {
                    rotation = 8;
                    WaveSpawnPanel.enableButtons(true);
                    Wave.updatePanel();
                    break;
                }
                default: {
                    ButtonPanel.resetBtns();
                    Wave.reset();
                    System.out.println("Invalid selection, try again");
                }
            }
        }
    }

    public static String getSpawn1() {
        return spawn1;
    }

    public static String getSpawn2() {
        return Wave.sortString(spawn2);
    }

    public static void increment() throws IOException {
        ++number;
        Wave.setImage();
    }

    public static void decrement() throws IOException {
        --number;
        Wave.setImage();
    }

    public static String sortString(String input) {
        char[] tempArr = input.toCharArray();
        Arrays.sort(tempArr);
        return new String(tempArr);
    }

    public static void updatePanel() throws IOException {
        ButtonPanel.hidePanel();
        Wave.increment();
        WaveSpawnPanel.enableButtons(true);
    }

    static {
        spawn1 = "-";
        spawn2 = "-";
        spawn4 = "-";
        spawn2_sorted = "-";
    }
}

