/*
 * Decompiled with CFR 0.152.
 */
package com.defaulttab;

import com.defaulttab.DefaultTabConfig;
import com.google.inject.Inject;
import com.google.inject.Provides;
import java.util.Collection;
import java.util.EnumSet;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Default Tab", description="Set and load a specific tab on every login", tags={"default", "tab", "login", "combat", "skills", "quest", "inventory", "equipment", "prayer", "spellbook", "clan", "chat", "friends", "account", "logout", "settings", "emotes", "music", "damen"}, enabledByDefault=true, loadInSafeMode=false)
public class DefaultTabPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DefaultTabPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private DefaultTabConfig config;
    private static final int TAB_SWITCH_SCRIPT = 915;
    private boolean pushTab = false;
    private int tickDelay = 0;

    @Provides
    DefaultTabConfig provideConfig(ConfigManager configManager) {
        return (DefaultTabConfig)configManager.getConfig(DefaultTabConfig.class);
    }

    protected void shutDown() {
        this.pushTab = false;
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged e) {
        if (!this.config.isOnLoginEnabled() || !this.config.isOnWorldHop()) {
            return;
        }
        switch (e.getGameState()) {
            case LOGGING_IN: {
                if (!this.config.isOnLoginEnabled()) break;
                this.pushTab = true;
                this.tickDelay = 0;
                break;
            }
            case HOPPING: {
                if (!this.config.isOnWorldHop()) break;
                this.pushTab = true;
                this.tickDelay = 0;
            }
        }
    }

    @Subscribe
    private void onGameTick(GameTick e) {
        if (!this.pushTab || this.client.getGameState() != GameState.LOGGED_IN || this.client.getLocalPlayer() == null) {
            this.pushTab = false;
            return;
        }
        EnumSet worldType = this.client.getWorldType();
        if (this.client.getVarbitValue(5963) == 1 || WorldType.isPvpWorld((Collection)worldType)) {
            if (!this.config.enabledInPvp()) {
                return;
            }
            if (this.tickDelay != 3) {
                ++this.tickDelay;
                return;
            }
        }
        this.clientThread.invokeLater(() -> {
            this.client.runScript(new Object[]{915, this.getTabPreference()});
            this.pushTab = this.getCurrentTab() != this.getTabPreference();
        });
    }

    private int getTabPreference() {
        return this.config.getDefaultInterfaceTab().getIndex();
    }

    private int getCurrentTab() {
        return this.client.getVarcIntValue(171);
    }
}

