/*
 * Decompiled with CFR 0.152.
 */
package de0.loadinglines;

import com.google.inject.Inject;
import de0.loadinglines.LoadingLinesConfig;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;

public class LoadingLinesWorldmapOverlay
extends Overlay {
    private static final int CHUNK_SIZE = 8;
    private static final int SCENE_SIZE = 104;
    private Client client;
    private LoadingLinesConfig config;
    @Inject
    private WorldMapOverlay worldMapOverlay;

    @Inject
    private LoadingLinesWorldmapOverlay(Client client, LoadingLinesConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.WORLD_MAP_VIEW);
    }

    public Dimension render(Graphics2D g) {
        if (!this.config.worldmap()) {
            return null;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(this.config.lineColor());
        Area mapClipArea = this.getWorldMapClipArea();
        if (mapClipArea == null) {
            return null;
        }
        g.setClip(mapClipArea);
        int z = this.client.getPlane();
        int baseX = this.client.getBaseX();
        int baseY = this.client.getBaseY();
        WorldPoint southWest = new WorldPoint(baseX + 16, baseY + 16, z);
        WorldPoint northWest = new WorldPoint(baseX + 16, baseY + 104 - 16, z);
        WorldPoint northEast = new WorldPoint(baseX + 104 - 16, baseY + 104 - 16, z);
        WorldPoint southEast = new WorldPoint(baseX + 104 - 16, baseY + 16, z);
        Point sw = this.worldMapOverlay.mapWorldPointToGraphicsPoint(southWest);
        Point nw = this.worldMapOverlay.mapWorldPointToGraphicsPoint(northWest);
        Point ne = this.worldMapOverlay.mapWorldPointToGraphicsPoint(northEast);
        Point se = this.worldMapOverlay.mapWorldPointToGraphicsPoint(southEast);
        if (sw != null && nw != null) {
            g.drawLine(sw.getX(), sw.getY(), nw.getX(), nw.getY());
        }
        if (nw != null && ne != null) {
            g.drawLine(nw.getX(), nw.getY(), ne.getX(), ne.getY());
        }
        if (ne != null && se != null) {
            g.drawLine(ne.getX(), ne.getY(), se.getX(), se.getY());
        }
        if (se != null && sw != null) {
            g.drawLine(se.getX(), se.getY(), sw.getX(), sw.getY());
        }
        return null;
    }

    private Area getWorldMapClipArea() {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Widget worldMapView = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (worldMapView == null) {
            return null;
        }
        Rectangle bounds = worldMapView.getBounds();
        if (bounds == null) {
            return null;
        }
        Area clipArea = new Area(bounds);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }
}

