/*
 * Decompiled with CFR 0.152.
 */
package de0.loadinglines;

import de0.loadinglines.LoadingLinesConfig;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.CollisionData;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class LoadingLinesOverlay
extends Overlay {
    private Client client;
    private LoadingLinesConfig config;
    private static final int MASK_W = 2359680;
    private static final int MASK_E = 2359560;
    private static final int MASK_S = 2359584;
    private static final int MASK_N = 2359554;

    @Inject
    LoadingLinesOverlay(Client client, LoadingLinesConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D g) {
        int fl2;
        int fl1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(this.config.lineColor());
        CollisionData cmap = this.client.getCollisionMaps()[this.client.getPlane()];
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        int curr_x = wp.getX() - this.client.getBaseX();
        int curr_y = wp.getY() - this.client.getBaseY();
        int[][] t = null;
        if (this.client.isInInstancedRegion()) {
            t = this.client.getInstanceTemplateChunks()[this.client.getPlane()];
        }
        int draw_dist = this.config.drawDistance();
        int min_x = Math.max(curr_x - draw_dist, 16);
        int max_x = Math.min(curr_x + draw_dist, 88);
        int min_y = Math.max(curr_y - draw_dist, 16);
        int max_y = Math.min(curr_y + draw_dist, 88);
        for (int y = min_y; y < max_y; ++y) {
            int x = 16;
            if (x >= min_x) {
                if (t != null && (t[x / 8][y / 8] == -1 || t[(x - 1) / 8][y / 8] == -1)) continue;
                fl1 = cmap.getFlags()[x][y];
                fl2 = cmap.getFlags()[x - 1][y];
                if ((fl1 & 0x240180) == 0 && (fl2 & 0x240108) == 0) {
                    this.line(g, 16, y, 16, y + 1);
                }
            }
            if ((x = 88) > max_x || t != null && (t[(x - 1) / 8][y / 8] == -1 || t[x / 8][y / 8] == -1)) continue;
            fl1 = cmap.getFlags()[x - 1][y];
            fl2 = cmap.getFlags()[x][y];
            if ((fl1 & 0x240108) != 0 || (fl2 & 0x240180) != 0) continue;
            this.line(g, 88, y, 88, y + 1);
        }
        for (int x = min_x; x < max_x; ++x) {
            int y = 16;
            if (y >= min_y) {
                if (t != null && (t[x / 8][y / 8] == -1 || t[x / 8][(y - 1) / 8] == -1)) continue;
                fl1 = cmap.getFlags()[x][y];
                fl2 = cmap.getFlags()[x][y - 1];
                if ((fl1 & 0x240120) == 0 && (fl2 & 0x240102) == 0) {
                    this.line(g, x, y, x + 1, y);
                }
            }
            if ((y = 88) > max_y || t != null && (t[x / 8][(y - 1) / 8] == -1 || t[x / 8][y / 8] == -1)) continue;
            fl1 = cmap.getFlags()[x][y - 1];
            fl2 = cmap.getFlags()[x][y];
            if ((fl1 & 0x240102) != 0 || (fl2 & 0x240120) != 0) continue;
            this.line(g, x, 88, x + 1, 88);
        }
        return null;
    }

    private void line(Graphics g, int x0, int y0, int x1, int y1) {
        int p = this.client.getPlane();
        int[][][] h = this.client.getTileHeights();
        Point p0 = Perspective.localToCanvas((Client)this.client, (int)(x0 << 7), (int)(y0 << 7), (int)h[p][x0][y0]);
        Point p1 = Perspective.localToCanvas((Client)this.client, (int)(x1 << 7), (int)(y1 << 7), (int)h[p][x1][y1]);
        if (p0 != null && p1 != null) {
            g.drawLine(p0.getX(), p0.getY(), p1.getX(), p1.getY());
        }
    }
}

