/*
 * Decompiled with CFR 0.152.
 */
package de0.loadinglines;

import com.google.inject.Inject;
import de0.loadinglines.LoadingLinesConfig;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class LoadingLinesMinimapOverlay
extends Overlay {
    private static final int CHUNK_SIZE = 8;
    private static final int SCENE_SIZE = 104;
    private static final int TILE_SIZE = 4;
    private Client client;
    private LoadingLinesConfig config;

    @Inject
    LoadingLinesMinimapOverlay(Client client, LoadingLinesConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D g) {
        if (!this.config.minimap()) {
            return null;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(this.config.lineColor());
        Area minimapClipArea = this.getMinimapClipArea();
        if (minimapClipArea == null) {
            return null;
        }
        g.setClip(minimapClipArea);
        int z = this.client.getPlane();
        int baseX = this.client.getBaseX();
        int baseY = this.client.getBaseY();
        WorldPoint southWest = new WorldPoint(baseX + 16, baseY + 16, z);
        WorldPoint northWest = new WorldPoint(baseX + 16, baseY + 104 - 16, z);
        WorldPoint northEast = new WorldPoint(baseX + 104 - 16, baseY + 104 - 16, z);
        WorldPoint southEast = new WorldPoint(baseX + 104 - 16, baseY + 16, z);
        Point sw = this.worldToMinimap(southWest);
        Point nw = this.worldToMinimap(northWest);
        Point ne = this.worldToMinimap(northEast);
        Point se = this.worldToMinimap(southEast);
        if (sw != null && nw != null) {
            g.drawLine(sw.getX(), sw.getY(), nw.getX(), nw.getY());
        }
        if (nw != null && ne != null) {
            g.drawLine(nw.getX(), nw.getY(), ne.getX(), ne.getY());
        }
        if (ne != null && se != null) {
            g.drawLine(ne.getX(), ne.getY(), se.getX(), se.getY());
        }
        if (se != null && sw != null) {
            g.drawLine(se.getX(), se.getY(), sw.getX(), sw.getY());
        }
        return null;
    }

    private Point worldToMinimap(WorldPoint worldPoint) {
        if (this.client.getLocalPlayer() == null) {
            return null;
        }
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        LocalPoint playerLocalPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerLocation);
        if (playerLocalPoint == null) {
            return null;
        }
        int offsetX = playerLocalPoint.getX() - localLocation.getX();
        int offsetY = playerLocalPoint.getY() - localLocation.getY();
        int x = (worldPoint.getX() - playerLocation.getX()) * 4 + offsetX / 32 - 2;
        int y = (worldPoint.getY() - playerLocation.getY()) * 4 + offsetY / 32 - 2 + 1;
        int angle = this.client.getMapAngle() & 0x7FF;
        int sin = (int)(65536.0 * Math.sin((double)angle * 0.0030679615757712823));
        int cos = (int)(65536.0 * Math.cos((double)angle * 0.0030679615757712823));
        Widget minimapDrawWidget = this.getMinimapDrawWidget();
        if (minimapDrawWidget == null || minimapDrawWidget.isHidden()) {
            return null;
        }
        int xx = y * sin + cos * x >> 16;
        int yy = sin * x - y * cos >> 16;
        Point loc = minimapDrawWidget.getCanvasLocation();
        int minimapX = loc.getX() + xx + minimapDrawWidget.getWidth() / 2;
        int minimapY = loc.getY() + yy + minimapDrawWidget.getHeight() / 2;
        return new Point(minimapX, minimapY);
    }

    private Widget getMinimapDrawWidget() {
        Widget minimapDrawArea = this.client.isResized() ? (this.client.getVar(4607) == 1 ? this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA) : this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA)) : this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
        return minimapDrawArea;
    }

    private Area getMinimapClipArea() {
        Widget minimapDrawArea = this.getMinimapDrawWidget();
        if (minimapDrawArea == null || minimapDrawArea.isHidden()) {
            return null;
        }
        Rectangle bounds = minimapDrawArea.getBounds();
        Ellipse2D.Double ellipse = new Ellipse2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        return new Area(ellipse);
    }
}

