/*
 * Decompiled with CFR 0.152.
 */
package com.example.dialog;

import com.example.dialog.DialogNode;
import com.example.dialog.DialogType;
import com.example.dialog.FakeDialogChatheadInput;
import com.example.dialog.FakeDialogChoiceInput;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.chatbox.ChatboxPanelManager;

@Singleton
public class FakeDialogManager {
    @Inject
    private Client client;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    private int selectedIx = -1;
    private DialogNode currentNode;

    public void open(@NonNull DialogNode startNode) {
        if (startNode == null) {
            throw new NullPointerException("startNode is marked non-null but is null");
        }
        this.selectedIx = -1;
        this.currentNode = startNode;
        this.chatboxPanelManager.openInput(startNode.getType() == DialogType.CHOICE ? new FakeDialogChoiceInput(this.chatboxPanelManager, startNode, this::setSelectedIx) : new FakeDialogChatheadInput(this.client, this.chatboxPanelManager, startNode, this::setSelectedIx));
    }

    @Subscribe(priority=1.0f)
    public void onGameTick(GameTick e) {
        if (this.selectedIx == -1 || this.currentNode == null) {
            return;
        }
        this.currentNode = this.currentNode.getNext(this.selectedIx);
        if (this.currentNode == null) {
            this.chatboxPanelManager.close();
        } else {
            this.open(this.currentNode);
        }
    }

    public void setSelectedIx(int selectedIx) {
        if (this.selectedIx == -1) {
            this.selectedIx = selectedIx;
        }
    }
}

