/*
 * Decompiled with CFR 0.152.
 */
package com.example.dialog;

import com.example.dialog.DialogNode;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import javax.inject.Inject;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.input.KeyListener;

public class FakeDialogChoiceInput
extends ChatboxInput
implements KeyListener {
    private static final int COLOUR_TITLE = 0x800000;
    private static final int COLOUR_OPTION = 0;
    private static final int COLOUR_OPTION_HOVER = 0xFFFFFF;
    private final ChatboxPanelManager chatboxPanelManager;
    private final DialogNode dialogNode;
    private final IntConsumer onSelected;
    private final List<Widget> optionWidgets = new ArrayList<Widget>(5);

    @Inject
    public FakeDialogChoiceInput(ChatboxPanelManager chatboxPanelManager, DialogNode dialogNode, IntConsumer onSelected) {
        this.chatboxPanelManager = chatboxPanelManager;
        this.dialogNode = dialogNode;
        this.onSelected = onSelected;
    }

    protected void open() {
        int maxStep;
        Widget container = this.chatboxPanelManager.getContainerWidget();
        Widget prompt = container.createChild(-1, 4);
        prompt.setText(this.dialogNode.getTitle());
        prompt.setTextColor(0x800000);
        prompt.setFontId(497);
        prompt.setXPositionMode(1);
        prompt.setOriginalX(0);
        prompt.setYPositionMode(0);
        prompt.setOriginalY(8);
        prompt.setOriginalHeight(24);
        prompt.setXTextAlignment(1);
        prompt.setYTextAlignment(1);
        prompt.setWidthMode(1);
        prompt.revalidate();
        int y = prompt.getRelativeX() + prompt.getHeight() + 6;
        int height = container.getHeight() - y - 8;
        int step = height / this.dialogNode.getChoices().size();
        int n = maxStep = this.dialogNode.getChoices().size() >= 3 ? 25 : 30;
        if (step > maxStep) {
            int ds = step - maxStep;
            step = maxStep;
            y += ds * this.dialogNode.getChoices().size() / 2;
        }
        int i = 0;
        while (i < this.dialogNode.getChoices().size()) {
            DialogNode.DialogChoice option = this.dialogNode.getChoices().get(i);
            Widget optWidget = container.createChild(-1, 4);
            optWidget.setText(option.getOption());
            optWidget.setTextColor(0);
            optWidget.setFontId(497);
            optWidget.setXPositionMode(1);
            optWidget.setOriginalX(0);
            optWidget.setYPositionMode(0);
            optWidget.setOriginalY(y);
            optWidget.setOriginalHeight(24);
            optWidget.setXTextAlignment(1);
            optWidget.setYTextAlignment(1);
            optWidget.setWidthMode(1);
            optWidget.setAction(0, "Continue");
            int selectIx = i++;
            optWidget.setOnOpListener(new Object[]{_e -> this.queueAdvance(selectIx)});
            optWidget.setOnMouseOverListener(new Object[]{_e -> optWidget.setTextColor(0xFFFFFF)});
            optWidget.setOnMouseLeaveListener(new Object[]{_e -> optWidget.setTextColor(0)});
            optWidget.setHasListener(true);
            this.optionWidgets.add(optWidget);
            optWidget.revalidate();
            y += step;
        }
        container.createChild(-1, 5).setSpriteId(302).setOriginalX(71).setOriginalY(12).setOriginalWidth(57).setOriginalHeight(13).revalidate();
        container.createChild(-1, 5).setSpriteId(301).setOriginalX(351).setOriginalY(12).setOriginalWidth(57).setOriginalHeight(13).revalidate();
        container.revalidate();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int ix = e.getKeyCode() - 49;
        if (ix >= 0 && ix < this.optionWidgets.size()) {
            this.queueAdvance(ix);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    private void queueAdvance(int ix) {
        Widget optWidget = this.optionWidgets.get(ix);
        optWidget.setText("Please wait...");
        optWidget.setTextColor(0);
        this.onSelected.accept(ix);
    }
}

