/*
 * Decompiled with CFR 0.152.
 */
package com.example.dialog;

import com.example.dialog.DialogNode;
import com.google.common.base.Strings;
import java.util.function.IntConsumer;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.chatbox.ChatboxInput;
import net.runelite.client.game.chatbox.ChatboxPanelManager;

public class FakeDialogChatheadInput
extends ChatboxInput {
    private static final int COLOUR_TITLE = 0x800000;
    private static final int COLOUR_CONTINUE = 255;
    private static final int COLOUR_CONTINUE_HOVER = 0xFFFFFF;
    private static final int CHATHEAD_MODEL_ZOOM = 796;
    private static final int CHATHEAD_WIDTH = 32;
    private static final int CHATHEAD_HEIGHT = 32;
    private static final int TEXT_WIDTH = 380;
    private static final int TEXT_LINE_HEIGHT = 17;
    private static final int TEXT_BLOCK_HEIGHT = 67;
    private final Client client;
    private final ChatboxPanelManager chatboxPanelManager;
    private final DialogNode currentNode;
    private final IntConsumer onSelected;

    protected void open() {
        Widget container = this.chatboxPanelManager.getContainerWidget();
        container.deleteAllChildren();
        this.buildChatHead(container);
        this.buildTitle(container);
        this.buildBody(container);
        this.buildContinue(container);
        container.revalidate();
    }

    private void buildChatHead(Widget container) {
        container.createChild(-1, 6).setModelType(this.currentNode.isPlayer() ? 3 : 2).setModelId(this.currentNode.isPlayer() ? -1 : this.currentNode.getNpcId()).setAnimationId(this.currentNode.getAnimationId()).setModelZoom(796).setRotationX(this.currentNode.getType().getHeadRotX()).setRotationY(this.currentNode.getType().getHeadRotY()).setRotationZ(this.currentNode.getType().getHeadRotZ()).setOriginalX(this.currentNode.getType().getHeadX()).setOriginalY(this.currentNode.getType().getHeadY()).setOriginalWidth(32).setOriginalHeight(32).setXPositionMode(0).setYPositionMode(0).setWidthMode(0).setHeightMode(0).revalidate();
    }

    private void buildTitle(Widget container) {
        String title = this.currentNode.getTitle();
        if (Strings.isNullOrEmpty((String)title) && this.currentNode.isPlayer()) {
            title = this.client.getLocalPlayer().getName();
        }
        container.createChild(-1, 4).setText(title).setTextColor(0x800000).setFontId(497).setXTextAlignment(1).setYTextAlignment(0).setOriginalX(this.currentNode.getType().getTextX()).setOriginalY(this.currentNode.getType().getNameY()).setOriginalWidth(380).setOriginalHeight(17).setXPositionMode(0).setYPositionMode(0).setWidthMode(0).setHeightMode(0).revalidate();
    }

    private void buildBody(Widget container) {
        container.createChild(-1, 4).setText(this.currentNode.getBody()).setFontId(497).setXTextAlignment(1).setYTextAlignment(1).setOriginalX(this.currentNode.getType().getTextX()).setOriginalY(this.currentNode.getType().getTextY()).setOriginalWidth(380).setOriginalHeight(67).setLineHeight(this.currentNode.getLineHeight()).setXPositionMode(0).setYPositionMode(0).setWidthMode(0).setHeightMode(0).revalidate();
    }

    private void buildContinue(Widget container) {
        Widget continueWidget = container.createChild(-1, 4).setText("Click here to continue").setTextColor(255).setFontId(497).setXTextAlignment(1).setYTextAlignment(0).setOriginalX(this.currentNode.getType().getTextX()).setOriginalY(this.currentNode.getType().getContinueY()).setOriginalWidth(380).setOriginalHeight(17).setXPositionMode(0).setYPositionMode(0).setWidthMode(0).setHeightMode(0);
        Runnable queueAdvance = () -> {
            continueWidget.setText("Please wait...");
            continueWidget.setTextColor(255);
            this.onSelected.accept(0);
        };
        continueWidget.setAction(0, "Continue");
        continueWidget.setOnOpListener(new Object[]{_e -> queueAdvance.run()});
        continueWidget.setOnMouseOverListener(new Object[]{_e -> continueWidget.setTextColor(0xFFFFFF)});
        continueWidget.setOnMouseLeaveListener(new Object[]{_e -> continueWidget.setTextColor(255)});
        continueWidget.setOnKeyListener(new Object[]{e -> {
            if (e.getTypedKeyCode() == 83) {
                queueAdvance.run();
            }
        }});
        continueWidget.setHasListener(true);
        continueWidget.revalidate();
    }

    public FakeDialogChatheadInput(Client client, ChatboxPanelManager chatboxPanelManager, DialogNode currentNode, IntConsumer onSelected) {
        this.client = client;
        this.chatboxPanelManager = chatboxPanelManager;
        this.currentNode = currentNode;
        this.onSelected = onSelected;
    }
}

