/*
 * Decompiled with CFR 0.152.
 */
package com.example.dialog;

import com.example.dialog.DialogType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public final class DialogNode {
    private final DialogType type;
    private final boolean player;
    private final int npcId;
    private final int animationId;
    private final String title;
    private final String body;
    private final List<DialogChoice> choices;

    public DialogNode getNext(int selectedIx) {
        if (selectedIx >= this.choices.size()) {
            return null;
        }
        return this.choices.get(selectedIx).getOnSelected().get();
    }

    public int getLineHeight() {
        switch (this.body.split("<br>").length) {
            case 2: {
                return 28;
            }
            case 3: {
                return 20;
            }
        }
        return 16;
    }

    private static String $default$title() {
        return null;
    }

    DialogNode(DialogType type, boolean player, int npcId, int animationId, String title, String body, List<DialogChoice> choices) {
        this.type = type;
        this.player = player;
        this.npcId = npcId;
        this.animationId = animationId;
        this.title = title;
        this.body = body;
        this.choices = choices;
    }

    public static DialogNodeBuilder builder() {
        return new DialogNodeBuilder();
    }

    public DialogType getType() {
        return this.type;
    }

    public boolean isPlayer() {
        return this.player;
    }

    public int getNpcId() {
        return this.npcId;
    }

    public int getAnimationId() {
        return this.animationId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public List<DialogChoice> getChoices() {
        return this.choices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialogNode)) {
            return false;
        }
        DialogNode other = (DialogNode)o;
        if (this.isPlayer() != other.isPlayer()) {
            return false;
        }
        if (this.getNpcId() != other.getNpcId()) {
            return false;
        }
        if (this.getAnimationId() != other.getAnimationId()) {
            return false;
        }
        DialogType this$type = this.getType();
        DialogType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        List<DialogChoice> this$choices = this.getChoices();
        List<DialogChoice> other$choices = other.getChoices();
        return !(this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPlayer() ? 79 : 97);
        result = result * 59 + this.getNpcId();
        result = result * 59 + this.getAnimationId();
        DialogType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        List<DialogChoice> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        return result;
    }

    public String toString() {
        return "DialogNode(type=" + this.getType() + ", player=" + this.isPlayer() + ", npcId=" + this.getNpcId() + ", animationId=" + this.getAnimationId() + ", title=" + this.getTitle() + ", body=" + this.getBody() + ", choices=" + this.getChoices() + ")";
    }

    public DialogNode withType(DialogType type) {
        return this.type == type ? this : new DialogNode(type, this.player, this.npcId, this.animationId, this.title, this.body, this.choices);
    }

    public DialogNode withPlayer(boolean player) {
        return this.player == player ? this : new DialogNode(this.type, player, this.npcId, this.animationId, this.title, this.body, this.choices);
    }

    public DialogNode withNpcId(int npcId) {
        return this.npcId == npcId ? this : new DialogNode(this.type, this.player, npcId, this.animationId, this.title, this.body, this.choices);
    }

    public DialogNode withAnimationId(int animationId) {
        return this.animationId == animationId ? this : new DialogNode(this.type, this.player, this.npcId, animationId, this.title, this.body, this.choices);
    }

    public DialogNode withTitle(String title) {
        return this.title == title ? this : new DialogNode(this.type, this.player, this.npcId, this.animationId, title, this.body, this.choices);
    }

    public DialogNode withBody(String body) {
        return this.body == body ? this : new DialogNode(this.type, this.player, this.npcId, this.animationId, this.title, body, this.choices);
    }

    public DialogNode withChoices(List<DialogChoice> choices) {
        return this.choices == choices ? this : new DialogNode(this.type, this.player, this.npcId, this.animationId, this.title, this.body, choices);
    }

    public static class DialogNodeBuilder {
        private DialogType type;
        private boolean player;
        private int npcId;
        private int animationId;
        private boolean title$set;
        private String title$value;
        private String body;
        private ArrayList<DialogChoice> choices;

        public DialogNodeBuilder player() {
            this.player = true;
            this.type(DialogType.DIALOG_HEAD_RIGHT);
            return this;
        }

        public DialogNodeBuilder npc(int npcId) {
            this.player = false;
            this.npcId = npcId;
            this.type(DialogType.DIALOG_HEAD_LEFT);
            return this;
        }

        public DialogNodeBuilder next(DialogNode next) {
            this.onContinue(() -> next);
            return this;
        }

        public DialogNodeBuilder onContinue(Supplier<DialogNode> onContinue) {
            this.clearChoices().choice(DialogChoice.of("Click here to continue", onContinue));
            return this;
        }

        public DialogNodeBuilder option(String option, DialogNode next) {
            this.option(option, () -> next);
            return this;
        }

        public DialogNodeBuilder option(String option, Supplier<DialogNode> onSelect) {
            if (!this.title$set) {
                this.title("Select an Option");
            }
            this.type(DialogType.CHOICE).choice(DialogChoice.of(option, onSelect));
            return this;
        }

        DialogNodeBuilder() {
        }

        public DialogNodeBuilder type(DialogType type) {
            this.type = type;
            return this;
        }

        public DialogNodeBuilder npcId(int npcId) {
            this.npcId = npcId;
            return this;
        }

        public DialogNodeBuilder animationId(int animationId) {
            this.animationId = animationId;
            return this;
        }

        public DialogNodeBuilder title(String title) {
            this.title$value = title;
            this.title$set = true;
            return this;
        }

        public DialogNodeBuilder body(String body) {
            this.body = body;
            return this;
        }

        public DialogNodeBuilder choice(DialogChoice choice) {
            if (this.choices == null) {
                this.choices = new ArrayList();
            }
            this.choices.add(choice);
            return this;
        }

        public DialogNodeBuilder choices(Collection<? extends DialogChoice> choices) {
            if (choices == null) {
                throw new NullPointerException("choices cannot be null");
            }
            if (this.choices == null) {
                this.choices = new ArrayList();
            }
            this.choices.addAll(choices);
            return this;
        }

        public DialogNodeBuilder clearChoices() {
            if (this.choices != null) {
                this.choices.clear();
            }
            return this;
        }

        public DialogNode build() {
            List<DialogChoice> choices;
            switch (this.choices == null ? 0 : this.choices.size()) {
                case 0: {
                    choices = Collections.emptyList();
                    break;
                }
                case 1: {
                    choices = Collections.singletonList(this.choices.get(0));
                    break;
                }
                default: {
                    choices = Collections.unmodifiableList(new ArrayList<DialogChoice>(this.choices));
                }
            }
            String title$value = this.title$value;
            if (!this.title$set) {
                title$value = DialogNode.$default$title();
            }
            return new DialogNode(this.type, this.player, this.npcId, this.animationId, title$value, this.body, choices);
        }

        public String toString() {
            return "DialogNode.DialogNodeBuilder(type=" + this.type + ", player=" + this.player + ", npcId=" + this.npcId + ", animationId=" + this.animationId + ", title$value=" + this.title$value + ", body=" + this.body + ", choices=" + this.choices + ")";
        }
    }

    public static final class DialogChoice {
        private final String option;
        private final Supplier<DialogNode> onSelected;

        public String getOption() {
            return this.option;
        }

        public Supplier<DialogNode> getOnSelected() {
            return this.onSelected;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DialogChoice)) {
                return false;
            }
            DialogChoice other = (DialogChoice)o;
            String this$option = this.getOption();
            String other$option = other.getOption();
            if (this$option == null ? other$option != null : !this$option.equals(other$option)) {
                return false;
            }
            Supplier<DialogNode> this$onSelected = this.getOnSelected();
            Supplier<DialogNode> other$onSelected = other.getOnSelected();
            return !(this$onSelected == null ? other$onSelected != null : !this$onSelected.equals(other$onSelected));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $option = this.getOption();
            result = result * 59 + ($option == null ? 43 : $option.hashCode());
            Supplier<DialogNode> $onSelected = this.getOnSelected();
            result = result * 59 + ($onSelected == null ? 43 : $onSelected.hashCode());
            return result;
        }

        public String toString() {
            return "DialogNode.DialogChoice(option=" + this.getOption() + ", onSelected=" + this.getOnSelected() + ")";
        }

        private DialogChoice(String option, Supplier<DialogNode> onSelected) {
            this.option = option;
            this.onSelected = onSelected;
        }

        public static DialogChoice of(String option, Supplier<DialogNode> onSelected) {
            return new DialogChoice(option, onSelected);
        }
    }
}

