/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.PetData;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;

public class PetObjectModel {
    private Client client;
    private RuneLiteObject rlObject;
    private final int MAX_TARGET_QUEUE_SIZE = 10;
    private Target[] targetQueue = new Target[10];
    private int cTargetIndex;
    public int targetQueueSize;
    private int lastDistance;
    public int distance;
    private PetData petData;
    public Animation[] animationPoses = new Animation[3];

    public void init(Client client, PetData petData) {
        this.client = client;
        this.rlObject = client.createRuneLiteObject();
        this.petData = petData;
        for (int i = 0; i < 10; ++i) {
            this.targetQueue[i] = new Target();
        }
    }

    public int getPetAttkAnim() {
        return this.petData.getAttkAnim();
    }

    public int getPetAttkAnimFrames() {
        return this.petData.getAttkAnimFrames();
    }

    public int getSize() {
        return this.petData.getSize();
    }

    public void setPetData(PetData petData) {
        this.petData = petData;
    }

    public void setModel(Model model) {
        this.rlObject.setModel(model);
    }

    public int getHeight() {
        return this.rlObject.getModelHeight();
    }

    public RuneLiteObject getRlObject() {
        return this.rlObject;
    }

    public WorldArea getWorldArea() {
        if (this.petData.getSize() == 2) {
            return new WorldArea(WorldPoint.fromLocal((Client)this.client, (LocalPoint)new LocalPoint(this.rlObject.getLocation().getX() - 64, this.rlObject.getLocation().getY() - 64)), 2, 2);
        }
        return new WorldArea(WorldPoint.fromLocal((Client)this.client, (LocalPoint)this.rlObject.getLocation()), 1, 1);
    }

    public void spawn(WorldPoint position, int jauOrientation, int size) {
        LocalPoint localPosition = LocalPoint.fromWorld((Client)this.client, (WorldPoint)position);
        if (localPosition != null && this.client.getPlane() == position.getPlane()) {
            this.rlObject.setLocation(localPosition, position.getPlane());
        } else {
            this.rlObject.setLocation(new LocalPoint(0, 0), this.client.getPlane());
        }
        this.rlObject.setOrientation(jauOrientation);
        this.rlObject.setShouldLoop(true);
        this.rlObject.setActive(true);
        this.lastDistance = 0;
        this.cTargetIndex = 0;
        this.targetQueueSize = 0;
    }

    public void despawn() {
        this.rlObject.setActive(false);
        this.lastDistance = 0;
        this.cTargetIndex = 0;
        this.targetQueueSize = 0;
    }

    public void setPoseAnimations(int idle, int walk, int run) {
        this.animationPoses[POSE_ANIM.IDLE.ordinal()] = this.client.loadAnimation(idle);
        this.animationPoses[POSE_ANIM.WALK.ordinal()] = this.client.loadAnimation(walk);
        this.animationPoses[POSE_ANIM.RUN.ordinal()] = this.client.loadAnimation(run);
    }

    public WorldPoint getWorldLocation() {
        return this.targetQueueSize > 0 ? this.targetQueue[this.cTargetIndex].wpDest : WorldPoint.fromLocal((Client)this.client, (LocalPoint)this.rlObject.getLocation());
    }

    public void setAnimation(Animation animation) {
        this.rlObject.setAnimation(animation);
    }

    public LocalPoint getLocalLocation() {
        return this.rlObject.getLocation();
    }

    public boolean isActive() {
        return this.rlObject.isActive();
    }

    public int getOrientation() {
        return this.rlObject.getOrientation();
    }

    public void moveTo(WorldPoint worldPosition, int jauOrientation, int size) {
        if (!this.rlObject.isActive()) {
            this.spawn(worldPosition, jauOrientation, size);
        }
        LocalPoint localPosition = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPosition);
        if (size == 2) {
            localPosition = new LocalPoint(localPosition.getX() + 64, localPosition.getY() + 64);
            worldPosition = WorldPoint.fromLocal((Client)this.client, (LocalPoint)localPosition);
        }
        if (this.targetQueueSize >= 8) {
            this.targetQueueSize = 0;
        }
        int prevTargetIndex = (this.cTargetIndex + this.targetQueueSize - 1) % 10;
        int newTargetIndex = (this.cTargetIndex + this.targetQueueSize) % 10;
        if (localPosition == null) {
            return;
        }
        WorldPoint prevWorldPosition = this.targetQueueSize++ > 0 ? this.targetQueue[prevTargetIndex].wpDest : WorldPoint.fromLocal((Client)this.client, (LocalPoint)this.rlObject.getLocation());
        int distance = prevWorldPosition.distanceTo(worldPosition);
        this.targetQueue[newTargetIndex].wpDest = worldPosition;
        this.targetQueue[newTargetIndex].lpDest = localPosition;
        this.targetQueue[newTargetIndex].currentDistance = distance;
    }

    public boolean onClientTick(ClientTick clientTick, int orentation) {
        if (this.rlObject.isActive()) {
            boolean rotationDone = this.rotateObject(orentation);
            if (this.targetQueueSize > 0) {
                int targetPlane = this.targetQueue[this.cTargetIndex].wpDest.getPlane();
                LocalPoint targetPosition = this.targetQueue[this.cTargetIndex].lpDest;
                if (this.client.getPlane() != targetPlane || targetPosition == null || !targetPosition.isInScene()) {
                    this.despawn();
                    return false;
                }
                if (this.lastDistance != this.targetQueue[this.cTargetIndex].currentDistance && this.getRlObject().getAnimation().getId() != this.petData.getAttkAnim()) {
                    int distance = this.targetQueue[this.cTargetIndex].currentDistance;
                    this.rlObject.setAnimation(distance > 2 ? null : this.animationPoses[distance]);
                    if (this.rlObject.getAnimation() == null) {
                        this.rlObject.setAnimation(this.animationPoses[1]);
                    }
                }
                this.lastDistance = this.targetQueue[this.cTargetIndex].currentDistance;
                LocalPoint currentPosition = this.rlObject.getLocation();
                int dx = targetPosition.getX() - currentPosition.getX();
                int dy = targetPosition.getY() - currentPosition.getY();
                if (dx != 0 || dy != 0) {
                    int speed;
                    int n = speed = this.lastDistance < 2 ? 4 : 8;
                    if (speed > 0) {
                        if (Math.abs(dx) > speed) {
                            dx = Integer.signum(dx) * speed;
                        }
                        if (Math.abs(dy) > speed) {
                            dy = Integer.signum(dy) * speed;
                        }
                    }
                    LocalPoint newLocation = new LocalPoint(currentPosition.getX() + dx, currentPosition.getY() + dy);
                    this.rlObject.setLocation(newLocation, targetPlane);
                    dx = targetPosition.getX() - this.rlObject.getLocation().getX();
                    dy = targetPosition.getY() - this.rlObject.getLocation().getY();
                }
                if (dx == 0 && dy == 0 && rotationDone) {
                    this.cTargetIndex = (this.cTargetIndex + 1) % 10;
                    --this.targetQueueSize;
                }
            }
            return true;
        }
        return false;
    }

    public boolean rotateObject(int orentation) {
        int JAU_FULL_ROTATION = 2048;
        int targetOrientation = orentation;
        int currentOrientation = this.rlObject.getOrientation();
        int dJau = (targetOrientation - currentOrientation) % 2048;
        if (dJau != 0) {
            int JAU_HALF_ROTATION = 1024;
            int JAU_TURN_SPEED = 32;
            int dJauCW = Math.abs(dJau);
            if (dJauCW > 1024) {
                dJau = (currentOrientation - targetOrientation) % 2048;
            } else if (dJauCW == 1024) {
                dJau = dJauCW;
            }
            if (Math.abs(dJau) > 32) {
                dJau = Integer.signum(dJau) * 32;
            }
            int newOrientation = (2048 + this.rlObject.getOrientation() + dJau) % 2048;
            this.rlObject.setOrientation(newOrientation);
            dJau = (targetOrientation - newOrientation) % 2048;
        }
        return dJau == 0;
    }

    static int radToJau(double a) {
        int j = (int)Math.round(a / 0.0030679615757712823);
        return j & 0x7FF;
    }

    private static enum POSE_ANIM {
        IDLE,
        WALK,
        RUN;

    }

    private class Target {
        public WorldPoint wpDest;
        public LocalPoint lpDest;
        public int currentDistance;

        private Target() {
        }
    }
}

