/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import java.util.function.Predicate;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;

public class PathingLogic {
    public static WorldArea calculateNextTravellingPoint(Client client, WorldArea start, WorldArea target, boolean stopAtMeleeDistance) {
        return PathingLogic.calculateNextTravellingPoint(client, start, target, stopAtMeleeDistance, x -> true);
    }

    public static WorldArea calculateNextTravellingPoint(Client client, WorldArea start, WorldArea target, boolean stopAtMeleeDistance, Predicate<? super WorldPoint> extraCondition) {
        if (start.getPlane() != target.getPlane()) {
            return null;
        }
        if (start.intersectsWith(target)) {
            if (stopAtMeleeDistance) {
                return null;
            }
            return start;
        }
        int dx = target.getX() - start.getX();
        int dy = target.getY() - start.getY();
        Point axisDistances = PathingLogic.getAxisDistances(start, target);
        if (stopAtMeleeDistance && axisDistances.getX() + axisDistances.getY() == 1) {
            return start;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)client, (int)start.getX(), (int)start.getY());
        if (lp == null || lp.getSceneX() + dx < 0 || lp.getSceneX() + dy >= 104 || lp.getSceneY() + dx < 0 || lp.getSceneY() + dy >= 104) {
            return null;
        }
        int dxSig = Integer.signum(dx);
        int dySig = Integer.signum(dy);
        if (stopAtMeleeDistance && axisDistances.getX() == 1 && axisDistances.getY() == 1) {
            if (start.canTravelInDirection(client, dxSig, 0, extraCondition)) {
                return new WorldArea(start.getX() + dxSig, start.getY(), start.getWidth(), start.getHeight(), start.getPlane());
            }
        } else {
            if (start.canTravelInDirection(client, dxSig, dySig, extraCondition)) {
                return new WorldArea(start.getX() + dxSig, start.getY() + dySig, start.getWidth(), start.getHeight(), start.getPlane());
            }
            if (dx != 0 && start.canTravelInDirection(client, dxSig, 0, extraCondition)) {
                return new WorldArea(start.getX() + dxSig, start.getY(), start.getWidth(), start.getHeight(), start.getPlane());
            }
            if (dy != 0 && Math.max(Math.abs(dx), Math.abs(dy)) > 1 && start.canTravelInDirection(client, 0, dy, extraCondition)) {
                return new WorldArea(start.getX(), start.getY() + dySig, start.getWidth(), start.getHeight(), start.getPlane());
            }
        }
        return start;
    }

    private static Point getAxisDistances(WorldArea wa1, WorldArea wa2) {
        Point p1 = PathingLogic.getComparisonPoint(wa1, wa2);
        Point p2 = PathingLogic.getComparisonPoint(wa2, wa1);
        return new Point(Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getY() - p2.getY()));
    }

    private static Point getComparisonPoint(WorldArea wa1, WorldArea wa2) {
        int x = wa2.getX() <= wa1.getX() ? wa1.getX() : (wa2.getX() >= wa1.getX() + wa1.getWidth() - 1 ? wa1.getX() + wa1.getWidth() - 1 : wa2.getX());
        int y = wa2.getY() <= wa1.getY() ? wa1.getY() : (wa2.getY() >= wa1.getY() + wa1.getHeight() - 1 ? wa1.getY() + wa1.getHeight() - 1 : wa2.getY());
        return new Point(x, y);
    }
}

