/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.CompanionPetConfig;
import com.example.CompanionPetOverlay;
import com.example.CompanionPetPanel;
import com.example.PathingLogic;
import com.example.PetData;
import com.example.PetObjectModel;
import com.example.dialog.DialogNode;
import com.example.dialog.FakeDialogManager;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.AABB;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.geometry.SimplePolygon;
import net.runelite.api.model.Jarvis;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.callback.Hooks;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Companion Pet Plugin", description="Spawn any pet as a Follower or to act as a Thrall.", tags={"pet", "companion pet", "fake", "pvm", "fake follower", "Thrall"})
public class CompanionPetPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CompanionPetPlugin.class);
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private CompanionPetConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CompanionPetOverlay overlayPet;
    @Inject
    private FakeDialogManager fakeDialogManager;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private Hooks hooks;
    private int lastActorOrientation;
    private boolean dialogOpen;
    private boolean petFollowing = false;
    private boolean petEnterHouse;
    public PetObjectModel pet = new PetObjectModel();
    public PetData petData;
    private WorldPoint lastPlayerWP;
    private WorldPoint lastActorWP;
    public WorldArea nextTravellingPoint;
    public WorldArea petWorldArea = null;
    private Model petModel;
    private final List<WorldPoint> prevPlayerWPs = new ArrayList<WorldPoint>();
    private final HashMap<NPC, PetObjectModel> activeThralls = new HashMap();
    public SimplePolygon petPoly;
    private CompanionPetPanel panel;
    private NavigationButton navButton;
    private static final String CONFIG_GROUP = "CompanionPetPlugin";
    private static final List<Integer> MELEE_THRALLS = Arrays.asList(10886, 10885, 10884);
    private static final List<Integer> RANGE_THRALLS = Arrays.asList(10883, 10882, 10881);
    private static final List<Integer> MAGE_THRALLS = Arrays.asList(10880, 10879, 10878);
    private static final List<Integer> ALL_THRALL_IDS = Arrays.asList(10886, 10885, 10884, 10883, 10882, 10881, 10880, 10879, 10878);
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;

    protected void startUp() throws Exception {
        this.buildSidePanel();
        this.overlayManager.add((Overlay)this.overlayPet);
        this.eventBus.register((Object)this.fakeDialogManager);
        this.hooks.registerRenderableDrawListener(this.drawListener);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlayPet);
        this.eventBus.unregister((Object)this.fakeDialogManager);
        this.clientToolbar.removeNavigation(this.navButton);
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
        this.panel.removeAll();
        this.clientThread.invokeLater(this::despawnAnyActivePOMs);
    }

    @Provides
    CompanionPetConfig provideConfig(ConfigManager configManager) {
        return (CompanionPetConfig)configManager.getConfig(CompanionPetConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getKey().equals("pet")) {
            this.petData = PetData.pets.get(this.config.pet().getIdentifier());
            this.clientThread.invokeLater(() -> this.updatePet());
        }
        if (event.getKey().equals("companionThralls") && !this.config.companionThralls()) {
            for (PetObjectModel thrallObjectModel : this.activeThralls.values()) {
                this.clientThread.invokeLater(thrallObjectModel::despawn);
            }
        } else if (event.getKey().equals("companionThralls")) {
            for (Map.Entry<NPC, PetObjectModel> entry : this.activeThralls.entrySet()) {
                NPC npc = entry.getKey();
                PetObjectModel thrallObjectModel = entry.getValue();
                this.clientThread.invokeLater(() -> {
                    thrallObjectModel.spawn(npc.getWorldLocation(), npc.getOrientation(), thrallObjectModel.getSize());
                    thrallObjectModel.setAnimation(thrallObjectModel.animationPoses[0]);
                });
            }
        }
        if (event.getKey().equals("allowBrokenPets") && this.config.allowBrokenPets() && !this.config.debug()) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("--------------------------------------------------------------------------------").build());
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("<col=ff0000>[Companion Pets] Warning<col=000000>:<col=ffff00>").build());
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("<col=000000>You have enabled the broken pets. These pets will not scale correctly and are awaiting a fix from RL.<col=ffff00>").build());
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("--------------------------------------------------------------------------------").build());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN || gameStateChanged.getGameState() == GameState.HOPPING) {
            this.activeThralls.clear();
        }
        if (gameStateChanged.getGameState() == GameState.LOADING) {
            if (this.pet.getRlObject() != null && this.pet.isActive()) {
                this.lastPlayerWP = this.client.getLocalPlayer().getWorldLocation();
                this.lastActorWP = this.pet.getWorldLocation();
                this.lastActorOrientation = this.pet.getOrientation();
                this.pet.despawn();
            }
            for (PetObjectModel petObjectModel : this.activeThralls.values()) {
                petObjectModel.despawn();
            }
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            if (this.pet.getRlObject() != null && this.petFollowing) {
                WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
                WorldPoint worldPoint = this.pet.getWorldLocation();
                double intx = worldPoint.toWorldArea().getX() - wp.toWorldArea().getX();
                double inty = worldPoint.toWorldArea().getY() - wp.toWorldArea().getY();
                if (this.lastPlayerWP.distanceTo(this.client.getLocalPlayer().getWorldLocation()) < 5) {
                    this.pet.spawn(this.lastActorWP, this.lastActorOrientation, this.petData.getSize());
                    this.pet.setAnimation(this.pet.animationPoses[0]);
                } else {
                    this.pet.spawn(this.client.getLocalPlayer().getWorldLocation(), PetObjectModel.radToJau(Math.atan2(intx, inty)), this.petData.getSize());
                    this.pet.setAnimation(this.pet.animationPoses[0]);
                }
                this.nextTravellingPoint = this.pet.getWorldLocation().toWorldArea();
            }
            for (Map.Entry entry : this.activeThralls.entrySet()) {
                PetObjectModel thrallObjectModel = (PetObjectModel)entry.getValue();
                NPC npc = (NPC)entry.getKey();
                thrallObjectModel.spawn(npc.getWorldLocation(), npc.getOrientation(), this.petData.getSize());
                thrallObjectModel.setAnimation(thrallObjectModel.animationPoses[0]);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message = event.getMessage();
        if (message.equals("You do not have a follower.") && event.getType() == ChatMessageType.GAMEMESSAGE) {
            this.callPet(event);
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (varbitChanged.getVarbitId() == 6719 && varbitChanged.getValue() == 0) {
            this.petEnterHouse = this.petFollowing;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        WorldPoint playerDelayedLoc = this.getAndUpdatePlayersDelayedLoc();
        this.spawnPetInHouse();
        if (this.pet.getRlObject() != null && this.pet.isActive()) {
            Player player = this.client.getLocalPlayer();
            double intx = this.pet.getLocalLocation().getX() - player.getLocalLocation().getX();
            double inty = this.pet.getLocalLocation().getY() - player.getLocalLocation().getY();
            if (this.nextTravellingPoint != null) {
                this.petWorldArea = this.nextTravellingPoint;
                this.petWorldArea = new WorldArea(this.nextTravellingPoint.toWorldPoint(), this.petData.getSize(), this.petData.getSize());
            }
            WorldArea worldArea = new WorldArea(playerDelayedLoc, 1, 1);
            this.nextTravellingPoint = PathingLogic.calculateNextTravellingPoint(this.client, this.petWorldArea, worldArea, true, this::extraBlockageCheck);
            if (this.petData == PetData.NEXLING && this.nextTravellingPoint != null) {
                this.nextTravellingPoint = PathingLogic.calculateNextTravellingPoint(this.client, this.nextTravellingPoint, worldArea, true, this::extraBlockageCheck);
            }
            if (this.nextTravellingPoint == null) {
                this.nextTravellingPoint = new WorldArea(this.getPathOutWorldPoint(this.petWorldArea), this.petData.getSize(), this.petData.getSize());
            }
            if (this.pet.isActive() && this.nextTravellingPoint != null) {
                this.pet.moveTo(this.nextTravellingPoint.toWorldPoint(), PetObjectModel.radToJau(Math.atan2(intx, inty)), this.petData.getSize());
            }
            if (this.pet.getWorldLocation().distanceTo(this.client.getLocalPlayer().getWorldLocation()) > 16 && this.petFollowing) {
                this.callPet(null);
            }
        }
        for (Map.Entry<NPC, PetObjectModel> entry : this.activeThralls.entrySet()) {
            PetObjectModel pet = entry.getValue();
            NPC npc = entry.getKey();
            if (pet.getRlObject() == null || !pet.isActive()) {
                return;
            }
            WorldArea petWorldArea = new WorldArea(pet.getWorldLocation(), 1, 1);
            WorldArea nextTravellingPoint = PathingLogic.calculateNextTravellingPoint(this.client, petWorldArea, npc.getWorldArea(), false, this::extraBlockageCheck);
            if (!pet.isActive() || nextTravellingPoint == null) continue;
            pet.moveTo(nextTravellingPoint.toWorldPoint(), npc.getCurrentOrientation(), 1);
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        int npcID = event.getNpc().getId();
        if (ALL_THRALL_IDS.contains(npcID)) {
            PetObjectModel thrallObjectModel = new PetObjectModel();
            if (thrallObjectModel.getRlObject() == null || !thrallObjectModel.isActive()) {
                PetData petData = PetData.pets.get(this.getThrallTypeData(npcID).getIdentifier());
                Model petModel = this.provideModel(petData);
                thrallObjectModel.init(this.client, petData);
                thrallObjectModel.setPoseAnimations(petData.getIdleAnim(), petData.getWalkAnim(), petData.getRunAnim());
                thrallObjectModel.setModel(petModel);
                thrallObjectModel.getRlObject().setDrawFrontTilesFirst(true);
            }
            if (this.config.companionThralls()) {
                thrallObjectModel.spawn(event.getNpc().getWorldLocation(), event.getNpc().getOrientation(), 1);
                thrallObjectModel.setAnimation(thrallObjectModel.animationPoses[0]);
            }
            this.activeThralls.putIfAbsent(event.getNpc(), thrallObjectModel);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (this.activeThralls.containsKey(event.getNpc())) {
            this.activeThralls.get(event.getNpc()).despawn();
            this.activeThralls.remove(event.getNpc());
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        PetObjectModel thrallPet;
        NPC npc;
        if (event.getActor() instanceof NPC && this.activeThralls.containsKey(npc = (NPC)event.getActor()) && npc.getAnimation() != -1 && this.activeThralls.get(npc).isActive() && (thrallPet = this.activeThralls.get(npc)).getPetAttkAnim() != -1) {
            thrallPet.setAnimation(this.client.loadAnimation(thrallPet.getPetAttkAnim()));
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.pet.getRlObject() != null && this.pet.animationPoses != null) {
            LocalPoint lp = this.pet.getLocalLocation();
            int zOff = Perspective.getTileHeight((Client)this.client, (LocalPoint)lp, (int)this.client.getPlane());
            this.petPoly = CompanionPetPlugin.calculateAABB(this.client, this.pet.getRlObject().getModel(), this.pet.getOrientation(), this.pet.getLocalLocation().getX(), this.pet.getLocalLocation().getY(), this.client.getPlane(), zOff);
            double intx = this.pet.getRlObject().getLocation().getX() - this.client.getLocalPlayer().getLocalLocation().getX();
            double inty = this.pet.getRlObject().getLocation().getY() - this.client.getLocalPlayer().getLocalLocation().getY();
            this.pet.onClientTick(event, PetObjectModel.radToJau(Math.atan2(intx, inty)));
            if (this.petData.getSize() == 2 && this.pet.getRlObject().getAnimation() == this.pet.animationPoses[1]) {
                this.pet.getRlObject().setDrawFrontTilesFirst(true);
            } else if (this.pet.getRlObject().getAnimation() == this.pet.animationPoses[0] && this.pet.getRlObject().drawFrontTilesFirst()) {
                this.pet.getRlObject().setDrawFrontTilesFirst(false);
            }
        }
        for (Map.Entry<NPC, PetObjectModel> entry : this.activeThralls.entrySet()) {
            PetObjectModel thrallOM = entry.getValue();
            NPC thrall = entry.getKey();
            if (thrallOM.getRlObject().getAnimation() != null && thrallOM.getPetAttkAnim() != -1 && thrallOM.getRlObject().getAnimation().getId() == thrallOM.getPetAttkAnim() && thrallOM.getRlObject().getAnimationFrame() == thrallOM.getPetAttkAnimFrames()) {
                if (thrallOM.targetQueueSize == 0 && thrallOM.getRlObject().getAnimation() != thrallOM.animationPoses[0]) {
                    thrallOM.setAnimation(thrallOM.animationPoses[0]);
                } else {
                    thrallOM.setAnimation(thrallOM.animationPoses[1]);
                }
            }
            thrallOM.onClientTick(event, thrall.getOrientation());
        }
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved event) {
        if (event.getProjectile().getStartCycle() == this.client.getGameCycle()) {
            LocalPoint point = new LocalPoint(event.getProjectile().getX1(), event.getProjectile().getY1());
            for (Map.Entry<NPC, PetObjectModel> entry : this.activeThralls.entrySet()) {
                NPC npc = entry.getKey();
                PetObjectModel thrall = entry.getValue();
                if (!npc.getLocalLocation().equals((Object)point) || npc.getAnimation() != -1 || thrall.getPetAttkAnim() == -1) continue;
                thrall.setAnimation(this.client.loadAnimation(thrall.getPetAttkAnim()));
            }
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        if (this.pet.getRlObject() == null || !this.pet.isActive()) {
            return;
        }
        int firstMenuIndex = 0;
        for (int i = 0; i < this.client.getMenuEntries().length; ++i) {
            if (!this.client.getMenuEntries()[i].getOption().equals("Cancel")) continue;
            firstMenuIndex = i + 1;
            break;
        }
        List<String> options = Arrays.asList("Talk-to", "Pick-up", "Examine");
        if (this.petData.isMetamorph()) {
            options = Arrays.asList("Talk-to", "Pick-up", "Metamorphosis", "Examine");
        }
        for (String string : options) {
            if (!this.petPoly.contains((double)this.client.getMouseCanvasPosition().getX(), (double)this.client.getMouseCanvasPosition().getY())) continue;
            this.client.createMenuEntry(firstMenuIndex).setOption(string).setTarget("<col=ffff00>" + this.petData.getName() + "</col>").setType(MenuAction.RUNELITE).setParam0(0).setParam1(0).setDeprioritized(true);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (this.petData == null) {
            return;
        }
        if (event.getMenuEntry().getType() == MenuAction.RUNELITE && event.getMenuTarget().contains(this.petData.getName()) && event.getMenuOption().equals("Pick-up") && this.pet.isActive()) {
            this.petFollowing = false;
            this.pet.despawn();
        }
        if (event.getMenuEntry().getType() == MenuAction.RUNELITE && event.getMenuTarget().contains(this.petData.getName()) && event.getMenuOption().equals("Examine") && this.pet.isActive()) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.petData.getExamine(), "", false);
        }
        if (event.getMenuEntry().getType() == MenuAction.RUNELITE && event.getMenuTarget().contains(this.petData.getName()) && event.getMenuOption().equals("Metamorphosis") && this.pet.isActive()) {
            if (!PetData.morphModel.get((Object)this.petData).isWorking() && !this.config.allowBrokenPets()) {
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("<col=000000>Sadly the transmog for this pet is awaiting a RL fix to work correctly<col=ffff00>").build());
                return;
            }
            this.petData = PetData.morphModel.get((Object)this.petData);
            this.updatePet();
        }
        if (event.getMenuEntry().getType() == MenuAction.RUNELITE && event.getMenuTarget().contains(this.petData.getName()) && event.getMenuOption().equals("Talk-to") && this.pet.isActive() && this.pet.getWorldArea().isInMeleeDistance(this.client.getLocalPlayer().getWorldArea())) {
            this.dialogOpen = true;
            this.fakeDialogManager.open(this.provideDialog());
        }
        if (!event.getMenuTarget().contains(this.petData.getName()) && !event.getMenuOption().equals("Continue") && this.dialogOpen) {
            this.dialogOpen = false;
            this.chatboxPanelManager.close();
        }
    }

    private boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        if (renderable instanceof RuneLiteObject) {
            RuneLiteObject rlObject = (RuneLiteObject)renderable;
            if (this.pet.getRlObject() != null && this.pet.getRlObject().equals(rlObject)) {
                ArrayList localPoints = new ArrayList();
                List<Player> nonLocalPlayers = this.client.getPlayers().stream().filter(player -> !Objects.equals(player.getName(), this.client.getLocalPlayer().getName())).collect(Collectors.toList());
                nonLocalPlayers.forEach(player -> localPoints.add(player.getLocalLocation()));
                this.client.getNpcs().forEach(npc -> localPoints.add(npc.getLocalLocation()));
                boolean overlappingModel = localPoints.stream().anyMatch(localPoint -> localPoint.equals((Object)this.pet.getLocalLocation()));
                return !overlappingModel;
            }
            for (PetObjectModel thrallOM : this.activeThralls.values()) {
                if (!thrallOM.getRlObject().equals(rlObject)) continue;
                ArrayList localPoints = new ArrayList();
                this.client.getPlayers().forEach(player -> localPoints.add(player.getLocalLocation()));
                this.client.getNpcs().stream().filter(npc -> !ALL_THRALL_IDS.contains(npc.getId())).forEach(npc -> localPoints.add(npc.getLocalLocation()));
                boolean overlappingModel = localPoints.stream().anyMatch(localPoint -> localPoint.equals((Object)thrallOM.getLocalLocation()));
                return !overlappingModel;
            }
        }
        if (renderable instanceof NPC && this.config.companionThralls()) {
            NPC npc2 = (NPC)renderable;
            return !ALL_THRALL_IDS.contains(npc2.getId());
        }
        return true;
    }

    private PetData getThrallTypeData(int npcID) {
        if (MELEE_THRALLS.contains(npcID)) {
            return this.config.meleeThrall();
        }
        if (RANGE_THRALLS.contains(npcID)) {
            return this.config.rangeThrall();
        }
        if (MAGE_THRALLS.contains(npcID)) {
            return this.config.mageThrall();
        }
        return null;
    }

    private void despawnAnyActivePOMs() {
        if (this.pet.getRlObject() != null && this.pet.isActive()) {
            this.pet.despawn();
        }
        for (PetObjectModel pom : this.activeThralls.values()) {
            pom.despawn();
        }
        this.activeThralls.clear();
    }

    private WorldPoint getAndUpdatePlayersDelayedLoc() {
        if (this.client.getLocalPlayer().getWorldLocation() == null) {
            return null;
        }
        WorldPoint worldPoint = null;
        this.prevPlayerWPs.add(0, this.client.getLocalPlayer().getWorldLocation());
        if (this.prevPlayerWPs.size() >= 2) {
            worldPoint = this.prevPlayerWPs.get(1);
        }
        if (worldPoint == null) {
            worldPoint = this.client.getLocalPlayer().getWorldLocation();
        }
        if (this.prevPlayerWPs.size() > 10) {
            this.prevPlayerWPs.subList(10, this.prevPlayerWPs.size()).clear();
        }
        return worldPoint;
    }

    private void spawnPetInHouse() {
        if (this.petEnterHouse && this.petFollowing) {
            this.petEnterHouse = false;
            WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
            WorldPoint aWP = this.pet.getWorldLocation();
            double intx = aWP.toWorldArea().getX() - wp.toWorldArea().getX();
            double inty = aWP.toWorldArea().getY() - wp.toWorldArea().getY();
            this.pet.spawn(this.client.getLocalPlayer().getWorldLocation(), PetObjectModel.radToJau(Math.atan2(intx, inty)), this.petData.getSize());
            this.pet.setAnimation(this.pet.animationPoses[0]);
            this.nextTravellingPoint = this.pet.getWorldLocation().toWorldArea();
        }
    }

    public WorldPoint getPathOutWorldPoint(WorldArea worldArea) {
        ArrayList<WorldPoint> points = new ArrayList<WorldPoint>();
        for (int i = -1; i < 2; ++i) {
            WorldArea area;
            boolean secondCheck;
            WorldPoint worldPoint;
            if (i == 0) continue;
            if (worldArea.canTravelInDirection(this.client, i, 0)) {
                worldPoint = new WorldPoint(worldArea.getX() + i, worldArea.getY(), this.client.getPlane());
                secondCheck = true;
                if (this.petData.getSize() == 2) {
                    area = new WorldArea(worldPoint, 2, 2);
                    secondCheck = area.canTravelInDirection(this.client, i, 0);
                }
                if (!worldPoint.equals((Object)this.client.getLocalPlayer().getWorldLocation()) && secondCheck) {
                    points.add(worldPoint);
                }
            }
            if (!worldArea.canTravelInDirection(this.client, 0, i)) continue;
            worldPoint = new WorldPoint(worldArea.getX(), worldArea.getY() + i, this.client.getPlane());
            secondCheck = true;
            if (this.petData.getSize() == 2) {
                area = new WorldArea(worldPoint, 2, 2);
                secondCheck = area.canTravelInDirection(this.client, 0, i);
            }
            if (worldPoint.equals((Object)this.client.getLocalPlayer().getWorldLocation()) || !secondCheck) continue;
            points.add(worldPoint);
        }
        if (!points.isEmpty()) {
            return (WorldPoint)points.get(this.getRandomInt(points.size() - 1, 0));
        }
        return null;
    }

    private int getRandomInt(int max, int min) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    private DialogNode provideDialog() {
        List data = Arrays.stream(this.petData.getDryestPerson().split(":")).collect(Collectors.toList());
        String kcIdentifer = (String)data.get(0);
        String name = (String)data.get(1);
        String kc = (String)data.get(2);
        String date = (String)data.get(3);
        return DialogNode.builder().player().animationId(567).body("Tell me something to make me feel better").onContinue(() -> DialogNode.builder().npc(this.petData.getNpcId()).title(this.petData.getName()).body("It took " + name + " " + kc + " " + kcIdentifer + " but<br>They finally got me on " + date).animationId(this.petData.getChatHeadAnimID()).build()).build();
    }

    public Model provideModel(PetData petData) {
        ModelData[] modelDataArray = new ModelData[petData.getModelIDs().size()];
        for (int i = 0; i < petData.getModelIDs().size(); ++i) {
            modelDataArray[i] = this.client.loadModelData(petData.getModelIDs().get(i).intValue());
        }
        ModelData modelData = CompanionPetPlugin.createModel(this.client, modelDataArray);
        if (petData.getScale() != -1) {
            modelData.cloneVertices();
            modelData.scale(petData.getScale(), petData.getScale(), petData.getScale());
        }
        if (petData.getRecolorIDs() != null) {
            modelData.cloneColors();
            int mid = petData.getRecolorIDs().size() / 2;
            for (int i = 0; i < mid; ++i) {
                modelData.recolor(petData.getRecolorIDs().get(i).shortValue(), petData.getRecolorIDs().get(mid + i).shortValue());
            }
        }
        int ambient = petData.getAmbient() != -1 ? petData.getAmbient() : 0;
        int contrast = petData.getContrast() != -1 ? petData.getContrast() : 0;
        return modelData.light(ambient + 64, contrast + 850, -30, -50, -30);
    }

    private void buildSidePanel() {
        this.panel = (CompanionPetPanel)((Object)this.injector.getInstance(CompanionPetPanel.class));
        this.panel.sidePanelInitializer();
        if (this.petData == null) {
            this.petData = PetData.pets.get(this.config.pet().getIdentifier());
        }
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/nav_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Companion Pet Plugin").icon(icon).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    public void updatePet() {
        if (this.petData != null) {
            this.configManager.setConfiguration(CONFIG_GROUP, "pet", (Object)this.petData);
        }
        if (this.pet.getRlObject() == null) {
            this.pet.init(this.client, this.petData);
        }
        this.petModel = this.provideModel(this.petData);
        this.pet.setPoseAnimations(this.petData.getIdleAnim(), this.petData.getWalkAnim(), this.petData.getRunAnim());
        this.pet.setPetData(this.petData);
        if (this.client.getGameState() == GameState.LOGGED_IN && this.pet.isActive()) {
            if (this.pet.getLocalLocation().distanceTo(LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.nextTravellingPoint.toWorldPoint())) > 0 && this.pet.getLocalLocation().distanceTo(LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.nextTravellingPoint.toWorldPoint())) != 90) {
                this.pet.setAnimation(this.pet.animationPoses[1]);
            } else {
                this.pet.setAnimation(this.pet.animationPoses[0]);
            }
        }
        this.pet.setModel(this.petModel);
        this.panel.updateCurrentPetIcon();
    }

    public void updatePet(PetData buttonPetData) {
        this.petData = buttonPetData;
        this.updatePet();
    }

    public boolean extraBlockageCheck(WorldPoint worldPoint) {
        if (this.petData.getSize() != 2) {
            return true;
        }
        WorldArea area = new WorldArea(worldPoint, 1, 1);
        ArrayList worldAreas = new ArrayList();
        this.client.getPlayers().forEach(p -> worldAreas.add(p.getWorldArea()));
        this.client.getNpcs().forEach(npc -> worldAreas.add(npc.getWorldArea()));
        boolean overlappingModel = worldAreas.stream().anyMatch(wa -> wa.intersectsWith(area));
        return !overlappingModel;
    }

    private void callPet(ChatMessage event) {
        if (this.pet.getRlObject() == null || !this.pet.isActive()) {
            this.petData = PetData.pets.get(this.config.pet().getIdentifier());
            this.petModel = this.provideModel(this.petData);
            this.pet.init(this.client, this.petData);
            this.pet.setPoseAnimations(this.petData.getIdleAnim(), this.petData.getWalkAnim(), this.petData.getRunAnim());
            this.pet.setModel(this.petModel);
            this.pet.getRlObject().setDrawFrontTilesFirst(true);
        }
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        WorldPoint aWP = this.pet.getWorldLocation();
        boolean petHasLOS = wp.toWorldArea().hasLineOfSightTo(this.client, aWP);
        if (event != null && wp.toWorldArea().distanceTo(aWP.toWorldArea()) < 6 && petHasLOS && this.pet.isActive()) {
            event.getMessageNode().setValue("Your follower is already close enough.");
            return;
        }
        if (this.pet.isActive()) {
            this.pet.despawn();
        }
        double intx = aWP.toWorldArea().getX() - wp.toWorldArea().getX();
        double inty = aWP.toWorldArea().getY() - wp.toWorldArea().getY();
        if (event != null) {
            event.getMessageNode().setValue("");
        }
        this.petFollowing = true;
        this.pet.spawn(this.getPathOutWorldPoint(new WorldArea(this.getAndUpdatePlayersDelayedLoc(), this.petData.getSize(), this.petData.getSize())), PetObjectModel.radToJau(Math.atan2(intx, inty)), this.petData.getSize());
        this.pet.setAnimation(this.pet.animationPoses[0]);
        this.nextTravellingPoint = this.pet.getWorldLocation().toWorldArea();
    }

    private static ModelData createModel(Client client, ModelData ... data) {
        return client.mergeModels(data);
    }

    private static ModelData createModel(Client client, int ... data) {
        ModelData[] modelData = new ModelData[data.length];
        for (int i = 0; i < data.length; ++i) {
            modelData[i] = client.loadModelData(data[i]);
        }
        return client.mergeModels(modelData);
    }

    private static SimplePolygon calculateAABB(Client client, Model m, int jauOrient, int x, int y, int z, int zOff) {
        AABB aabb = m.getAABB(jauOrient);
        int x1 = aabb.getCenterX();
        int y1 = aabb.getCenterZ();
        int z1 = aabb.getCenterY() + zOff;
        int ex = aabb.getExtremeX();
        int ey = aabb.getExtremeZ();
        int ez = aabb.getExtremeY();
        int x2 = x1 + ex;
        int y2 = y1 + ey;
        int z2 = z1 + ez;
        int[] xa = new int[]{x1 -= ex, x2, x1, x2, x1, x2, x1, x2};
        int[] ya = new int[]{y1 -= ey, y1, y2, y2, y1, y1, y2, y2};
        int[] za = new int[]{z1 -= ez, z1, z1, z1, z2, z2, z2, z2};
        int[] x2d = new int[8];
        int[] y2d = new int[8];
        CompanionPetPlugin.modelToCanvasCpu(client, 8, x, y, z, 0, xa, ya, za, x2d, y2d);
        return Jarvis.convexHull((int[])x2d, (int[])y2d);
    }

    private static void modelToCanvasCpu(Client client, int end, int x3dCenter, int y3dCenter, int z3dCenter, int rotate, int[] x3d, int[] y3d, int[] z3d, int[] x2d, int[] y2d) {
        int cameraPitch = client.getCameraPitch();
        int cameraYaw = client.getCameraYaw();
        int pitchSin = Perspective.SINE[cameraPitch];
        int pitchCos = Perspective.COSINE[cameraPitch];
        int yawSin = Perspective.SINE[cameraYaw];
        int yawCos = Perspective.COSINE[cameraYaw];
        int rotateSin = Perspective.SINE[rotate];
        int rotateCos = Perspective.COSINE[rotate];
        int cx = x3dCenter - client.getCameraX();
        int cy = y3dCenter - client.getCameraY();
        int cz = z3dCenter - client.getCameraZ();
        int viewportXMiddle = client.getViewportWidth() / 2;
        int viewportYMiddle = client.getViewportHeight() / 2;
        int viewportXOffset = client.getViewportXOffset();
        int viewportYOffset = client.getViewportYOffset();
        int zoom3d = client.getScale();
        for (int i = 0; i < end; ++i) {
            int viewY;
            int viewX;
            int x = x3d[i];
            int y = y3d[i];
            int z = z3d[i];
            if (rotate != 0) {
                int x0 = x;
                x = x0 * rotateCos + y * rotateSin >> 16;
                y = y * rotateCos - x0 * rotateSin >> 16;
            }
            int x1 = (x += cx) * yawCos + (y += cy) * yawSin >> 16;
            int y1 = y * yawCos - x * yawSin >> 16;
            int y2 = (z += cz) * pitchCos - y1 * pitchSin >> 16;
            int z1 = y1 * pitchCos + z * pitchSin >> 16;
            if (z1 < 50) {
                viewX = Integer.MIN_VALUE;
                viewY = Integer.MIN_VALUE;
            } else {
                viewX = viewportXMiddle + x1 * zoom3d / z1 + viewportXOffset;
                viewY = viewportYMiddle + y2 * zoom3d / z1 + viewportYOffset;
            }
            x2d[i] = viewX;
            y2d[i] = viewY;
        }
    }
}

